/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.DictionaryPasswordValidatorCfg;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class DictionaryPasswordValidator
extends PasswordValidator<DictionaryPasswordValidatorCfg>
implements ConfigurationChangeListener<DictionaryPasswordValidatorCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DictionaryPasswordValidatorCfg currentConfig;
    private HashSet<String> dictionary;

    @Override
    public void initializePasswordValidator(DictionaryPasswordValidatorCfg configuration) throws ConfigException, InitializationException {
        configuration.addDictionaryChangeListener(this);
        this.currentConfig = configuration;
        this.dictionary = this.loadDictionary(configuration);
    }

    @Override
    public void finalizePasswordValidator() {
        this.currentConfig.removeDictionaryChangeListener(this);
    }

    @Override
    public boolean passwordIsAcceptable(ByteString newPassword, Set<ByteString> currentPasswords, Operation operation, Entry userEntry, MessageBuilder invalidReason) {
        DictionaryPasswordValidatorCfg config = this.currentConfig;
        String password = newPassword.toString();
        if (!config.isCaseSensitiveValidation()) {
            password = StaticUtils.toLowerCase(password);
        }
        int minSubstringLength = password.length();
        if (config.isCheckSubstrings() && config.getMinSubstringLength() < password.length()) {
            minSubstringLength = config.getMinSubstringLength();
        }
        if (this.isDictionaryBased(password, minSubstringLength)) {
            invalidReason.append(ExtensionMessages.ERR_DICTIONARY_VALIDATOR_PASSWORD_IN_DICTIONARY.get());
            return false;
        }
        if (config.isTestReversedPassword() && this.isDictionaryBased(new StringBuilder(password).reverse().toString(), minSubstringLength)) {
            invalidReason.append(ExtensionMessages.ERR_DICTIONARY_VALIDATOR_PASSWORD_IN_DICTIONARY.get());
            return false;
        }
        return true;
    }

    private HashSet<String> loadDictionary(DictionaryPasswordValidatorCfg configuration) throws ConfigException, InitializationException {
        File dictionaryFile = StaticUtils.getFileForPath(configuration.getDictionaryFile());
        if (!dictionaryFile.exists()) {
            Message message = ExtensionMessages.ERR_DICTIONARY_VALIDATOR_NO_SUCH_FILE.get(configuration.getDictionaryFile());
            throw new ConfigException(message);
        }
        BufferedReader reader = null;
        HashSet<String> dictionary = new HashSet<String>();
        try {
            reader = new BufferedReader(new FileReader(dictionaryFile));
            String line = reader.readLine();
            while (line != null) {
                if (!configuration.isCaseSensitiveValidation()) {
                    line = line.toLowerCase();
                }
                dictionary.add(line);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_DICTIONARY_VALIDATOR_CANNOT_READ_FILE.get(configuration.getDictionaryFile(), String.valueOf(e));
            throw new InitializationException(message);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return dictionary;
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordValidatorCfg configuration, List<Message> unacceptableReasons) {
        DictionaryPasswordValidatorCfg config = (DictionaryPasswordValidatorCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(DictionaryPasswordValidatorCfg configuration, List<Message> unacceptableReasons) {
        try {
            this.loadDictionary(configuration);
        }
        catch (ConfigException ce) {
            unacceptableReasons.add(ce.getMessageObject());
            return false;
        }
        catch (InitializationException ie) {
            unacceptableReasons.add(ie.getMessageObject());
            return false;
        }
        catch (Exception e) {
            unacceptableReasons.add(StaticUtils.getExceptionMessage(e));
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(DictionaryPasswordValidatorCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.dictionary = this.loadDictionary(configuration);
            this.currentConfig = configuration;
        }
        catch (Exception e) {
            resultCode = DirectoryConfig.getServerErrorResultCode();
            messages.add(StaticUtils.getExceptionMessage(e));
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private boolean isDictionaryBased(String password, int minSubstringLength) {
        HashSet<String> dictionary = this.dictionary;
        int passwordLength = password.length();
        for (int i = 0; i < passwordLength; ++i) {
            for (int j = i + minSubstringLength; j <= passwordLength; ++j) {
                String substring = password.substring(i, j);
                if (!dictionary.contains(substring)) continue;
                return true;
            }
        }
        return false;
    }
}

