/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.GoverningStructureRuleVirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;

public class GoverningStructureRuleVirtualAttributeProvider
extends VirtualAttributeProvider<GoverningStructureRuleVirtualAttributeCfg> {
    @Override
    public void initializeVirtualAttributeProvider(GoverningStructureRuleVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        DITStructureRule ditRule = this.getDITStructureRule(entry);
        if (ditRule != null) {
            return Collections.singleton(AttributeValues.create(rule.getAttributeType(), String.valueOf(ditRule.getRuleID())));
        }
        return Collections.emptySet();
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        return this.getDITStructureRule(entry) != null;
    }

    @Override
    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult lessThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation, boolean isPreIndexed) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
        Message message = ExtensionMessages.ERR_VATTR_NOT_SEARCHABLE.get(rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
    }

    private boolean matchesNameForm(NameForm nameForm, AcceptRejectWarn structuralPolicy, Entry entry) {
        RDN rdn = entry.getDN().getRDN();
        if (rdn != null) {
            for (AttributeType t : nameForm.getRequiredAttributes()) {
                if (rdn.hasAttributeType(t) || structuralPolicy != AcceptRejectWarn.REJECT) continue;
                return false;
            }
            int numAVAs = rdn.getNumValues();
            for (int i = 0; i < numAVAs; ++i) {
                AttributeType t = rdn.getAttributeType(i);
                if (nameForm.isRequiredOrOptional(t) || structuralPolicy != AcceptRejectWarn.REJECT) continue;
                return false;
            }
        }
        return true;
    }

    private DITStructureRule getDITStructureRule(Entry entry) {
        ObjectClass oc = entry.getStructuralObjectClass();
        List<NameForm> listForms = DirectoryServer.getNameForm(oc);
        NameForm nameForm = null;
        DITStructureRule ditRule = null;
        if (listForms != null) {
            boolean obsolete = true;
            AcceptRejectWarn structuralPolicy = DirectoryServer.getSingleStructuralObjectClassPolicy();
            for (NameForm nf : listForms) {
                if (nf.isObsolete()) continue;
                obsolete = false;
                if (!this.matchesNameForm(nf, structuralPolicy, entry)) continue;
                nameForm = nf;
                break;
            }
            if (nameForm != null && !obsolete) {
                ditRule = DirectoryServer.getDITStructureRule(nameForm);
            }
        }
        return ditRule;
    }
}

