/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.opends.messages.ConfigMessages;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.AlertHandlerCfg;
import org.opends.server.admin.std.server.JMXAlertHandlerCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.AlertHandler;
import org.opends.server.api.DirectoryServerMBean;
import org.opends.server.config.ConfigException;
import org.opends.server.config.JMXMBean;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class JMXAlertHandler
extends NotificationBroadcasterSupport
implements AlertHandler<JMXAlertHandlerCfg>,
ConfigurationChangeListener<JMXAlertHandlerCfg>,
DynamicMBean,
DirectoryServerMBean {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.JMXAlertHandler";
    private AlertHandlerCfg currentConfig;
    private AtomicLong sequenceNumber;
    private DN configEntryDN;
    private ObjectName objectName;

    @Override
    public void initializeAlertHandler(JMXAlertHandlerCfg configuration) throws ConfigException, InitializationException {
        this.sequenceNumber = new AtomicLong(1L);
        this.configEntryDN = configuration == null ? null : configuration.dn();
        MBeanServer mBeanServer = DirectoryServer.getJMXMBeanServer();
        if (mBeanServer != null) {
            try {
                String nameStr = "org.opends.server:type=JMXAlertHandler";
                this.objectName = new ObjectName(nameStr);
                if (mBeanServer.isRegistered(this.objectName)) {
                    mBeanServer.unregisterMBean(this.objectName);
                }
                mBeanServer.registerMBean(this, this.objectName);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ExtensionMessages.ERR_JMX_ALERT_HANDLER_CANNOT_REGISTER.get(String.valueOf(e));
                throw new InitializationException(message, (Throwable)e);
            }
        }
        if (configuration != null) {
            configuration.addJMXChangeListener(this);
            this.currentConfig = configuration;
        }
    }

    @Override
    public AlertHandlerCfg getAlertHandlerConfiguration() {
        return this.currentConfig;
    }

    @Override
    public boolean isConfigurationAcceptable(AlertHandlerCfg configuration, List<Message> unacceptableReasons) {
        JMXAlertHandlerCfg cfg = (JMXAlertHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public void finalizeAlertHandler() {
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public void sendAlertNotification(AlertGenerator generator, String alertType, Message alertMessage) {
        this.sendNotification(new Notification(alertType, generator.getClassName(), this.sequenceNumber.getAndIncrement(), System.currentTimeMillis(), alertMessage.toString()));
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        ArrayList<MBeanNotificationInfo> notifications = new ArrayList<MBeanNotificationInfo>();
        ConcurrentHashMap<DN, JMXMBean> mBeans = DirectoryServer.getJMXMBeans();
        for (JMXMBean mBean : mBeans.values()) {
            MBeanInfo mBeanInfo = mBean.getMBeanInfo();
            for (MBeanNotificationInfo notification : mBeanInfo.getNotifications()) {
                notifications.add(notification);
            }
        }
        MBeanNotificationInfo[] notificationArray = new MBeanNotificationInfo[notifications.size()];
        notifications.toArray(notificationArray);
        return notificationArray;
    }

    @Override
    public Attribute getAttribute(String attribute) throws AttributeNotFoundException {
        Message message = ConfigMessages.ERR_CONFIG_JMX_ATTR_NO_ATTR.get(String.valueOf(this.configEntryDN), attribute);
        throw new AttributeNotFoundException(message.toString());
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        Message message = ConfigMessages.ERR_CONFIG_JMX_ATTR_NO_ATTR.get(String.valueOf(this.configEntryDN), String.valueOf(attribute));
        throw new AttributeNotFoundException(message.toString());
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return new AttributeList();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(actionName);
        buffer.append("(");
        if (signature.length > 0) {
            buffer.append(signature[0]);
            for (int i = 1; i < signature.length; ++i) {
                buffer.append(", ");
                buffer.append(signature[i]);
            }
        }
        buffer.append(")");
        Message message = ConfigMessages.ERR_CONFIG_JMX_NO_METHOD.get(buffer.toString(), String.valueOf(this.configEntryDN));
        throw new MBeanException(new ConfigException(message));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(CLASS_NAME, "JMX Alert Handler", new MBeanAttributeInfo[0], new MBeanConstructorInfo[0], new MBeanOperationInfo[0], this.getNotificationInfo());
    }

    @Override
    public boolean isConfigurationChangeAcceptable(JMXAlertHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(JMXAlertHandlerCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

