/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.PBKDF2PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

public class PBKDF2PasswordStorageScheme
extends PasswordStorageScheme<PBKDF2PasswordStorageSchemeCfg>
implements ConfigurationChangeListener<PBKDF2PasswordStorageSchemeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.extensions.PBKDF2PasswordStorageScheme";
    private static final int NUM_SALT_BYTES = 8;
    private static final int SHA1_LENGTH = 20;
    private SecureRandom random;
    private volatile PBKDF2PasswordStorageSchemeCfg config;

    @Override
    public void initializePasswordStorageScheme(PBKDF2PasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
            SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InitializationException(null);
        }
        this.config = configuration;
        this.config.addPBKDF2ChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PBKDF2PasswordStorageSchemeCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PBKDF2PasswordStorageSchemeCfg configuration) {
        this.config = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public String getStorageSchemeName() {
        return "PBKDF2";
    }

    @Override
    public ByteString encodePassword(ByteSequence plaintext) throws DirectoryException {
        byte[] saltBytes = new byte[8];
        int iterations = this.config.getPBKDF2Iterations();
        byte[] digestBytes = PBKDF2PasswordStorageScheme.encodeWithRandomSalt(plaintext, saltBytes, iterations, this.random);
        byte[] hashPlusSalt = PBKDF2PasswordStorageScheme.concatenateHashPlusSalt(saltBytes, digestBytes);
        return ByteString.valueOf(iterations + ":" + Base64.encode(hashPlusSalt));
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteSequence plaintext) throws DirectoryException {
        return ByteString.valueOf("{PBKDF2}" + this.encodePassword(plaintext));
    }

    @Override
    public boolean passwordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        try {
            String stored = storedPassword.toString();
            int pos = stored.indexOf(58);
            if (pos == -1) {
                throw new Exception();
            }
            int iterations = Integer.parseInt(stored.substring(0, pos));
            byte[] decodedBytes = Base64.decode(stored.substring(pos + 1));
            int saltLength = decodedBytes.length - 20;
            if (saltLength <= 0) {
                Message message = ExtensionMessages.ERR_PWSCHEME_INVALID_BASE64_DECODED_STORED_PASSWORD.get(storedPassword.toString());
                ErrorLogger.logError(message);
                return false;
            }
            byte[] digestBytes = new byte[20];
            byte[] saltBytes = new byte[saltLength];
            System.arraycopy(decodedBytes, 0, digestBytes, 0, 20);
            System.arraycopy(decodedBytes, 20, saltBytes, 0, saltLength);
            return this.encodeAndMatch(plaintextPassword, saltBytes, digestBytes, iterations);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_BASE64_DECODE_STORED_PASSWORD.get(storedPassword.toString(), String.valueOf(e));
            ErrorLogger.logError(message);
            return false;
        }
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return true;
    }

    @Override
    public String getAuthPasswordSchemeName() {
        return "PBKDF2";
    }

    @Override
    public ByteString encodeAuthPassword(ByteSequence plaintext) throws DirectoryException {
        byte[] saltBytes = new byte[8];
        int iterations = this.config.getPBKDF2Iterations();
        byte[] digestBytes = PBKDF2PasswordStorageScheme.encodeWithRandomSalt(plaintext, saltBytes, iterations, this.random);
        return ByteString.valueOf("PBKDF2$" + iterations + ':' + Base64.encode(saltBytes) + '$' + Base64.encode(digestBytes));
    }

    @Override
    public boolean authPasswordMatches(ByteSequence plaintextPassword, String authInfo, String authValue) {
        try {
            int pos = authInfo.indexOf(58);
            if (pos == -1) {
                throw new Exception();
            }
            int iterations = Integer.parseInt(authInfo.substring(0, pos));
            byte[] saltBytes = Base64.decode(authInfo.substring(pos + 1));
            byte[] digestBytes = Base64.decode(authValue);
            return this.encodeAndMatch(plaintextPassword, saltBytes, digestBytes, iterations);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public ByteString getPlaintextValue(ByteSequence storedPassword) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("PBKDF2");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("PBKDF2");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return true;
    }

    public static String encodeOffline(byte[] passwordBytes) throws DirectoryException {
        byte[] saltBytes = new byte[8];
        int iterations = 10000;
        ByteString password = ByteString.wrap(passwordBytes);
        byte[] digestBytes = PBKDF2PasswordStorageScheme.encodeWithRandomSalt(password, saltBytes, iterations);
        byte[] hashPlusSalt = PBKDF2PasswordStorageScheme.concatenateHashPlusSalt(saltBytes, digestBytes);
        return "{PBKDF2}" + iterations + ':' + Base64.encode(hashPlusSalt);
    }

    private static byte[] encodeWithRandomSalt(ByteString plaintext, byte[] saltBytes, int iterations) throws DirectoryException {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            return PBKDF2PasswordStorageScheme.encodeWithRandomSalt(plaintext, saltBytes, iterations, random);
        }
        catch (DirectoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw PBKDF2PasswordStorageScheme.cannotEncodePassword(e);
        }
    }

    private static byte[] encodeWithSalt(ByteSequence plaintext, byte[] saltBytes, int iterations) throws DirectoryException {
        char[] plaintextChars = plaintext.toString().toCharArray();
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(plaintextChars, saltBytes, iterations, 160);
            byte[] byArray = factory.generateSecret(spec).getEncoded();
            return byArray;
        }
        catch (Exception e) {
            throw PBKDF2PasswordStorageScheme.cannotEncodePassword(e);
        }
        finally {
            Arrays.fill(plaintextChars, '0');
        }
    }

    private boolean encodeAndMatch(ByteSequence plaintext, byte[] saltBytes, byte[] digestBytes, int iterations) {
        try {
            byte[] userDigestBytes = PBKDF2PasswordStorageScheme.encodeWithSalt(plaintext, saltBytes, iterations);
            return Arrays.equals(digestBytes, userDigestBytes);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static byte[] encodeWithRandomSalt(ByteSequence plaintext, byte[] saltBytes, int iterations, SecureRandom random) throws DirectoryException {
        random.nextBytes(saltBytes);
        return PBKDF2PasswordStorageScheme.encodeWithSalt(plaintext, saltBytes, iterations);
    }

    private static DirectoryException cannotEncodePassword(Exception e) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
        }
        Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.getExceptionMessage(e));
        return new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
    }

    private static byte[] concatenateHashPlusSalt(byte[] saltBytes, byte[] digestBytes) {
        byte[] hashPlusSalt = new byte[digestBytes.length + 8];
        System.arraycopy(digestBytes, 0, hashPlusSalt, 0, digestBytes.length);
        System.arraycopy(saltBytes, 0, hashPlusSalt, digestBytes.length, 8);
        return hashPlusSalt;
    }
}

