/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.PKCS11KeyManagerProviderCfg;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class PKCS11KeyManagerProvider
extends KeyManagerProvider<PKCS11KeyManagerProviderCfg>
implements ConfigurationChangeListener<PKCS11KeyManagerProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String PKCS11_KEYSTORE_TYPE = "PKCS11";
    private DN configEntryDN;
    private char[] keyStorePIN;
    private PKCS11KeyManagerProviderCfg currentConfig;

    @Override
    public void initializeKeyManagerProvider(PKCS11KeyManagerProviderCfg configuration) throws ConfigException, InitializationException {
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        configuration.addPKCS11ChangeListener(this);
        this.keyStorePIN = null;
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                Message message = ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_PROPERTY_NOT_SET.get(String.valueOf(propertyName), String.valueOf(this.configEntryDN));
                throw new InitializationException(message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                Message message = ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_ENVAR_NOT_SET.get(String.valueOf(enVarName), String.valueOf(this.configEntryDN));
                throw new InitializationException(message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePinFile() != null) {
            String pinStr;
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                Message message = ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_NO_SUCH_FILE.get(String.valueOf(fileName), String.valueOf(this.configEntryDN));
                throw new InitializationException(message);
            }
            try {
                BufferedReader br = new BufferedReader(new FileReader(pinFile));
                pinStr = br.readLine();
                br.close();
            }
            catch (IOException ioe) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
                }
                Message message = ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_FILE_CANNOT_READ.get(String.valueOf(fileName), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe));
                throw new InitializationException(message, (Throwable)ioe);
            }
            if (pinStr == null) {
                Message message = ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_FILE_EMPTY.get(String.valueOf(fileName), String.valueOf(this.configEntryDN));
                throw new InitializationException(message);
            }
            this.keyStorePIN = pinStr.toCharArray();
        } else if (configuration.getKeyStorePin() != null) {
            this.keyStorePIN = configuration.getKeyStorePin().toCharArray();
        } else {
            Message message = ExtensionMessages.ERR_PKCS11_KEYMANAGER_NO_PIN.get(String.valueOf(this.configEntryDN));
            throw new ConfigException(message);
        }
    }

    @Override
    public void finalizeKeyManagerProvider() {
        this.currentConfig.removePKCS11ChangeListener(this);
    }

    @Override
    public KeyManager[] getKeyManagers() throws DirectoryException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(PKCS11_KEYSTORE_TYPE);
            keyStore.load(null, this.keyStorePIN);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PKCS11_KEYMANAGER_CANNOT_LOAD.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            keyManagerFactory.init(keyStore, this.keyStorePIN);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PKCS11_KEYMANAGER_CANNOT_CREATE_FACTORY.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    @Override
    public boolean isConfigurationAcceptable(PKCS11KeyManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        return this.isConfigurationChangeAcceptable(configuration, unacceptableReasons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfigurationChangeAcceptable(PKCS11KeyManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                unacceptableReasons.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_PROPERTY_NOT_SET.get(String.valueOf(propertyName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                unacceptableReasons.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_ENVAR_NOT_SET.get(String.valueOf(enVarName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        } else if (configuration.getKeyStorePinFile() != null) {
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                unacceptableReasons.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_NO_SUCH_FILE.get(String.valueOf(fileName), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            } else {
                String pinStr = null;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(pinFile));
                    pinStr = br.readLine();
                }
                catch (IOException ioe) {
                    unacceptableReasons.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_FILE_CANNOT_READ.get(String.valueOf(fileName), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(ioe)));
                    configAcceptable = false;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
                if (pinStr == null) {
                    unacceptableReasons.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_FILE_EMPTY.get(String.valueOf(fileName), String.valueOf(cfgEntryDN)));
                    configAcceptable = false;
                }
            }
        } else if (configuration.getKeyStorePin() != null) {
            String pinStr = configuration.getKeyStorePin();
            if (pinStr == null) {
                unacceptableReasons.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_CANNOT_DETERMINE_PIN_FROM_ATTR.get(String.valueOf(cfgEntryDN), "null"));
                configAcceptable = false;
            }
        } else {
            unacceptableReasons.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_NO_PIN.get(String.valueOf(cfgEntryDN)));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(PKCS11KeyManagerProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        char[] newPIN = null;
        if (configuration.getKeyStorePinProperty() != null) {
            String propertyName = configuration.getKeyStorePinProperty();
            String pinStr = System.getProperty(propertyName);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_PROPERTY_NOT_SET.get(String.valueOf(propertyName), String.valueOf(this.configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        } else if (configuration.getKeyStorePinEnvironmentVariable() != null) {
            String enVarName = configuration.getKeyStorePinEnvironmentVariable();
            String pinStr = System.getenv(enVarName);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_ENVAR_NOT_SET.get(String.valueOf(enVarName), String.valueOf(this.configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        } else if (configuration.getKeyStorePinFile() != null) {
            String fileName = configuration.getKeyStorePinFile();
            File pinFile = StaticUtils.getFileForPath(fileName);
            if (!pinFile.exists()) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_NO_SUCH_FILE.get(String.valueOf(fileName), String.valueOf(this.configEntryDN)));
            } else {
                String pinStr = null;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(pinFile));
                    pinStr = br.readLine();
                }
                catch (IOException ioe) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_FILE_CANNOT_READ.get(String.valueOf(fileName), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe)));
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
                if (pinStr == null) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_PIN_FILE_EMPTY.get(String.valueOf(fileName), String.valueOf(this.configEntryDN)));
                } else {
                    newPIN = pinStr.toCharArray();
                }
            }
        } else if (configuration.getKeyStorePin() != null) {
            newPIN = configuration.getKeyStorePin().toCharArray();
        } else {
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(ExtensionMessages.ERR_PKCS11_KEYMANAGER_NO_PIN.get(String.valueOf(this.configEntryDN)));
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.currentConfig = configuration;
            this.keyStorePIN = newPIN;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

