/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collections;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.PasswordExpirationTimeVirtualAttributeCfg;
import org.opends.server.api.AuthenticationPolicy;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.StaticUtils;

public class PasswordExpirationTimeVirtualAttributeProvider
extends VirtualAttributeProvider<PasswordExpirationTimeVirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeVirtualAttributeProvider(PasswordExpirationTimeVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        if (!entry.isSubentry() && !entry.isLDAPSubentry()) {
            long expirationTime = this.getPasswordExpirationTime(entry);
            if (expirationTime == -1L) {
                return Collections.emptySet();
            }
            AttributeValue value = GeneralizedTimeSyntax.createGeneralizedTimeValue(expirationTime);
            return Collections.singleton(value);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation, boolean isPreIndexed) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
        Message message = ExtensionMessages.ERR_PWDEXPTIME_VATTR_NOT_SEARCHABLE.get(rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        return !entry.isSubentry() && !entry.isLDAPSubentry() && this.getPasswordExpirationTime(entry) != -1L;
    }

    private long getPasswordExpirationTime(Entry entry) {
        AuthenticationPolicy policy;
        block9: {
            policy = null;
            try {
                policy = AuthenticationPolicy.forUser(entry, false);
            }
            catch (DirectoryException de) {
                ErrorLogger.logError(de.getMessageObject());
                if (!DebugLogger.debugEnabled()) break block9;
                TRACER.debugError("Failed to retrieve password policy for user %s: %s", entry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(de));
            }
        }
        if (policy == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugError("No applicable password policy for user %s", entry.getDN().toString());
            }
        } else {
            if (policy.isPasswordPolicy()) {
                PasswordPolicyState pwpState;
                block10: {
                    pwpState = null;
                    try {
                        pwpState = (PasswordPolicyState)policy.createAuthenticationPolicyState(entry);
                    }
                    catch (DirectoryException de) {
                        ErrorLogger.logError(de.getMessageObject());
                        if (!DebugLogger.debugEnabled()) break block10;
                        TRACER.debugError("Failed to retrieve password policy state for user %s: %s", entry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(de));
                    }
                }
                return pwpState.getPasswordExpirationTime();
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Authentication policy %s found for user %s is not a password policy", policy.getDN().toString(), entry.getDN().toString());
            }
        }
        return -1L;
    }
}

