/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.opends.server.extensions.ConnectionSecurityProvider;

public class RedirectingByteChannel
implements ByteChannel {
    private final ByteChannel child;
    private volatile ByteChannel redirect = null;

    public static RedirectingByteChannel getRedirectingByteChannel(ByteChannel bc) {
        return new RedirectingByteChannel(bc);
    }

    private RedirectingByteChannel(ByteChannel child) {
        this.child = child;
    }

    @Override
    public void close() throws IOException {
        ByteChannel tmp = this.redirect;
        if (tmp != null) {
            tmp.close();
        } else {
            this.child.close();
        }
    }

    public final void disable() {
        this.redirect = null;
    }

    @Override
    public boolean isOpen() {
        ByteChannel tmp = this.redirect;
        if (tmp != null) {
            return tmp.isOpen();
        }
        return this.child.isOpen();
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        ByteChannel tmp = this.redirect;
        if (tmp != null) {
            return tmp.read(buffer);
        }
        return this.child.read(buffer);
    }

    public final void redirect(ConnectionSecurityProvider provider) {
        this.redirect = provider.getChannel();
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        ByteChannel tmp = this.redirect;
        if (tmp != null) {
            return tmp.write(buffer);
        }
        return this.child.write(buffer);
    }
}

