/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.MemberList;
import org.opends.server.types.MembershipException;
import org.opends.server.util.Validator;

public class SimpleStaticGroupMemberList
extends MemberList {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN groupDN;
    private Iterator<ByteString> memberDNIterator;
    private ArrayList<ByteString> memberDNs;

    public SimpleStaticGroupMemberList(DN groupDN, Set<ByteString> memberDNs) {
        Validator.ensureNotNull(groupDN, memberDNs);
        this.groupDN = groupDN;
        this.memberDNs = new ArrayList<ByteString>(memberDNs);
        this.memberDNIterator = memberDNs.iterator();
    }

    @Override
    public boolean hasMoreMembers() {
        return this.memberDNIterator.hasNext();
    }

    @Override
    public DN nextMemberDN() throws MembershipException {
        DN dn = null;
        if (this.memberDNIterator.hasNext()) {
            try {
                dn = DN.decode(this.memberDNIterator.next());
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                Message message = ExtensionMessages.ERR_STATICMEMBERS_CANNOT_DECODE_DN.get(String.valueOf(dn), String.valueOf(this.groupDN), String.valueOf(de.getMessageObject()));
                throw new MembershipException(message, true, de);
            }
        }
        return dn;
    }

    @Override
    public Entry nextMemberEntry() throws MembershipException {
        if (this.memberDNIterator.hasNext()) {
            ByteString memberDN = this.memberDNIterator.next();
            try {
                Entry memberEntry = DirectoryConfig.getEntry(DN.decode(memberDN));
                if (memberEntry == null) {
                    Message message = ExtensionMessages.ERR_STATICMEMBERS_NO_SUCH_ENTRY.get(String.valueOf(memberDN), String.valueOf(this.groupDN));
                    throw new MembershipException(message, true);
                }
                return memberEntry;
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                Message message = ExtensionMessages.ERR_STATICMEMBERS_CANNOT_GET_ENTRY.get(String.valueOf(memberDN), String.valueOf(this.groupDN), String.valueOf(de.getMessageObject()));
                throw new MembershipException(message, true, de);
            }
        }
        return null;
    }

    @Override
    public void close() {
    }
}

