/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.Collection;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.std.meta.AccessLogPublisherCfgDefn;
import org.opends.server.admin.std.server.AccessLogPublisherCfg;
import org.opends.server.api.AccessLogPublisher;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.loggers.AbstractLogger;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;

public class AccessLogger
extends AbstractLogger<AccessLogPublisher<AccessLogPublisherCfg>, AccessLogPublisherCfg> {
    private static AbstractLogger.LoggerStorage<AccessLogPublisher<AccessLogPublisherCfg>, AccessLogPublisherCfg> loggerStorage = new AbstractLogger.LoggerStorage();
    private static final AccessLogger instance = new AccessLogger();

    public AccessLogger() {
        super(AccessLogPublisher.class, ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ACCESS_LOGGER_CLASS);
    }

    @Override
    protected ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getJavaClassPropertyDefinition();
    }

    @Override
    protected AbstractLogger.LoggerStorage<AccessLogPublisher<AccessLogPublisherCfg>, AccessLogPublisherCfg> getStorage() {
        return loggerStorage;
    }

    public static AccessLogger getInstance() {
        return instance;
    }

    public static synchronized void addAccessLogPublisher(AccessLogPublisher publisher) {
        loggerStorage.addLogPublisher(publisher);
    }

    public static synchronized boolean removeAccessLogPublisher(AccessLogPublisher<AccessLogPublisherCfg> publisher) {
        return loggerStorage.removeLogPublisher(publisher);
    }

    public static synchronized void removeAllAccessLogPublishers() {
        loggerStorage.removeAllLogPublishers();
    }

    private static Collection<AccessLogPublisher<AccessLogPublisherCfg>> getAccessLogPublishers() {
        return loggerStorage.getLogPublishers();
    }

    public static void logConnect(ClientConnection clientConnection) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logConnect(clientConnection);
        }
    }

    public static void logDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, Message message) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logDisconnect(clientConnection, disconnectReason, message);
        }
    }

    public static void logAbandonRequest(AbandonOperation abandonOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logAbandonRequest(abandonOperation);
        }
    }

    public static void logAbandonResult(AbandonOperation abandonOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logAbandonResult(abandonOperation);
        }
    }

    public static void logAddRequest(AddOperation addOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logAddRequest(addOperation);
        }
    }

    public static void logAddResponse(AddOperation addOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logAddResponse(addOperation);
        }
    }

    public static void logBindRequest(BindOperation bindOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logBindRequest(bindOperation);
        }
    }

    public static void logBindResponse(BindOperation bindOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logBindResponse(bindOperation);
        }
    }

    public static void logCompareRequest(CompareOperation compareOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logCompareRequest(compareOperation);
        }
    }

    public static void logCompareResponse(CompareOperation compareOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logCompareResponse(compareOperation);
        }
    }

    public static void logDeleteRequest(DeleteOperation deleteOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logDeleteRequest(deleteOperation);
        }
    }

    public static void logDeleteResponse(DeleteOperation deleteOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logDeleteResponse(deleteOperation);
        }
    }

    public static void logExtendedRequest(ExtendedOperation extendedOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logExtendedRequest(extendedOperation);
        }
    }

    public static void logExtendedResponse(ExtendedOperation extendedOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logExtendedResponse(extendedOperation);
        }
    }

    public static void logModifyRequest(ModifyOperation modifyOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logModifyRequest(modifyOperation);
        }
    }

    public static void logModifyResponse(ModifyOperation modifyOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logModifyResponse(modifyOperation);
        }
    }

    public static void logModifyDNRequest(ModifyDNOperation modifyDNOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logModifyDNRequest(modifyDNOperation);
        }
    }

    public static void logModifyDNResponse(ModifyDNOperation modifyDNOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logModifyDNResponse(modifyDNOperation);
        }
    }

    public static void logSearchRequest(SearchOperation searchOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logSearchRequest(searchOperation);
        }
    }

    public static void logSearchResultEntry(SearchOperation searchOperation, SearchResultEntry searchEntry) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logSearchResultEntry(searchOperation, searchEntry);
        }
    }

    public static void logSearchResultReference(SearchOperation searchOperation, SearchResultReference searchReference) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logSearchResultReference(searchOperation, searchReference);
        }
    }

    public static void logSearchResultDone(SearchOperation searchOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logSearchResultDone(searchOperation);
        }
    }

    public static void logUnbind(UnbindOperation unbindOperation) {
        for (AccessLogPublisher<AccessLogPublisherCfg> publisher : AccessLogger.getAccessLogPublishers()) {
            publisher.logUnbind(unbindOperation);
        }
    }
}

