/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.ArrayList;
import org.opends.server.api.DirectoryThread;
import org.opends.server.config.ConfigEntry;
import org.opends.server.loggers.ActionType;
import org.opends.server.loggers.GZIPAction;
import org.opends.server.loggers.PostRotationAction;
import org.opends.server.loggers.ZIPAction;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

public class RotationActionThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ArrayList<ActionType> actions;
    private String filename;
    private ConfigEntry configEntry;

    public RotationActionThread(String filename, ArrayList<ActionType> actions, ConfigEntry configEntry) {
        super("Logger Rotation Action Thread");
        this.filename = filename;
        this.actions = actions;
        this.configEntry = configEntry;
    }

    @Override
    public void run() {
        block9: {
            try {
                for (ActionType at : this.actions) {
                    boolean val;
                    PostRotationAction action = null;
                    switch (at) {
                        case GZIP_COMPRESS: {
                            String gzipFile = this.filename + ".gz";
                            action = new GZIPAction(this.filename, gzipFile, true);
                            break;
                        }
                        case ZIP_COMPRESS: {
                            String zipFile = this.filename + ".zip";
                            action = new ZIPAction(this.filename, zipFile, true);
                            break;
                        }
                        case SIGN: {
                            break;
                        }
                        case ENCRYPT: {
                            String encFile = this.filename + ".enc";
                            break;
                        }
                        default: {
                            System.err.println("Invalid post rollover action:" + (Object)((Object)at));
                        }
                    }
                    if (action == null || (val = action.execute())) continue;
                    System.err.println("Post rotation action failed.");
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block9;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }
}

