/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.FileBasedAccessLogPublisherCfgDefn;
import org.opends.server.admin.std.server.FileBasedAccessLogPublisherCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.loggers.AbstractTextAccessLogPublisher;
import org.opends.server.loggers.AsynchronousTextWriter;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.ParallelTextWriter;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.TimeStampNaming;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public final class TextAccessLogPublisher
extends AbstractTextAccessLogPublisher<FileBasedAccessLogPublisherCfg>
implements ConfigurationChangeListener<FileBasedAccessLogPublisherCfg> {
    private static final String CATEGORY_RESPONSE = "RES";
    private static final String CATEGORY_REQUEST = "REQ";
    private TextWriter writer = null;
    private FileBasedAccessLogPublisherCfg cfg = null;
    private boolean isCombinedMode = false;
    private boolean includeControlOIDs = false;
    private String timeStampFormat = "dd/MMM/yyyy:HH:mm:ss Z";

    public static TextAccessLogPublisher getStartupTextAccessPublisher(TextWriter writer, boolean suppressInternal) {
        TextAccessLogPublisher startupPublisher = new TextAccessLogPublisher();
        startupPublisher.writer = writer;
        startupPublisher.buildFilters(suppressInternal);
        return startupPublisher;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedAccessLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            boolean writerAutoFlush;
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            boolean bl = writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            TextWriter currentWriter = this.writer instanceof AsynchronousTextWriter ? ((AsynchronousTextWriter)this.writer).getWrappedWriter() : (this.writer instanceof ParallelTextWriter ? ((ParallelTextWriter)this.writer).getWrappedWriter() : this.writer);
            if (currentWriter instanceof MultifileTextWriter) {
                TextWriter asyncWriter;
                MultifileTextWriter mfWriter = (MultifileTextWriter)currentWriter;
                mfWriter.setNamingPolicy(fnPolicy);
                mfWriter.setFilePermissions(perm);
                mfWriter.setAppend(config.isAppend());
                mfWriter.setAutoFlush(writerAutoFlush);
                mfWriter.setBufferSize((int)config.getBufferSize());
                mfWriter.setInterval(config.getTimeInterval());
                mfWriter.removeAllRetentionPolicies();
                mfWriter.removeAllRotationPolicies();
                for (DN dn : config.getRotationPolicyDNs()) {
                    mfWriter.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
                }
                for (DN dn : config.getRetentionPolicyDNs()) {
                    mfWriter.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
                }
                if (this.writer instanceof AsynchronousTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (AsynchronousTextWriter)this.writer;
                    this.writer = mfWriter;
                    ((AsynchronousTextWriter)asyncWriter).shutdown(false);
                }
                if (this.writer instanceof ParallelTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (ParallelTextWriter)this.writer;
                    this.writer = mfWriter;
                    ((ParallelTextWriter)asyncWriter).shutdown(false);
                }
                if (!(this.writer instanceof AsynchronousTextWriter) && config.isAsynchronous()) {
                    this.writer = new AsynchronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), mfWriter);
                }
                if (!(this.writer instanceof ParallelTextWriter) && config.isAsynchronous()) {
                    this.writer = new ParallelTextWriter("Parallel Text Writer for " + config.dn().toNormalizedString(), config.isAutoFlush(), mfWriter);
                }
                if (this.cfg.isAsynchronous() && config.isAsynchronous() && this.cfg.getQueueSize() != config.getQueueSize()) {
                    adminActionRequired = true;
                }
                if (!config.getLogRecordTimeFormat().equals(this.timeStampFormat)) {
                    TimeThread.removeUserDefinedFormatter(this.timeStampFormat);
                    this.timeStampFormat = config.getLogRecordTimeFormat();
                }
                this.cfg = config;
                this.isCombinedMode = this.cfg.getLogFormat() == FileBasedAccessLogPublisherCfgDefn.LogFormat.COMBINED;
                this.includeControlOIDs = this.cfg.isLogControlOids();
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public void initializeLogPublisher(FileBasedAccessLogPublisherCfg cfg) throws ConfigException, InitializationException {
        File logFile = StaticUtils.getFileForPath(cfg.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(cfg.getLogFilePermissions());
            LogPublisherErrorHandler errorHandler = new LogPublisherErrorHandler(cfg.dn());
            boolean writerAutoFlush = cfg.isAutoFlush() && !cfg.isAsynchronous();
            MultifileTextWriter theWriter = new MultifileTextWriter("Multifile Text Writer for " + cfg.dn().toNormalizedString(), cfg.getTimeInterval(), fnPolicy, perm, errorHandler, "UTF-8", writerAutoFlush, cfg.isAppend(), (int)cfg.getBufferSize());
            for (DN dn : cfg.getRotationPolicyDNs()) {
                theWriter.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
            }
            for (DN dn : cfg.getRetentionPolicyDNs()) {
                theWriter.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
            }
            this.writer = cfg.isAsynchronous() ? (cfg.getQueueSize() > 0 ? new AsynchronousTextWriter("Asyncronous Text Writer for " + cfg.dn().toNormalizedString(), cfg.getQueueSize(), cfg.isAutoFlush(), theWriter) : new ParallelTextWriter("Parallel Text Writer for " + cfg.dn().toNormalizedString(), cfg.isAutoFlush(), theWriter)) : theWriter;
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(cfg.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        catch (IOException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_OPEN_FILE.get(logFile.toString(), cfg.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.initializeFilters(cfg);
        this.cfg = cfg;
        this.isCombinedMode = cfg.getLogFormat() == FileBasedAccessLogPublisherCfgDefn.LogFormat.COMBINED;
        this.includeControlOIDs = cfg.isLogControlOids();
        this.timeStampFormat = cfg.getLogRecordTimeFormat();
        cfg.addFileBasedAccessChangeListener(this);
    }

    @Override
    public boolean isConfigurationAcceptable(FileBasedAccessLogPublisherCfg configuration, List<Message> unacceptableReasons) {
        return this.isFilterConfigurationAcceptable(configuration, unacceptableReasons) && this.isConfigurationChangeAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedAccessLogPublisherCfg config, List<Message> unacceptableReasons) {
        String formatString = config.getLogRecordTimeFormat();
        try {
            new SimpleDateFormat(formatString);
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_INVALID_TIME_FORMAT.get(String.valueOf(formatString));
            unacceptableReasons.add(message);
            return false;
        }
        try {
            FilePermission filePerm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            if (!filePerm.isOwnerWritable()) {
                Message message = ConfigMessages.ERR_CONFIG_LOGGING_INSANE_MODE.get(config.getLogFilePermissions());
                unacceptableReasons.add(message);
                return false;
            }
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_MODE_INVALID.get(config.getLogFilePermissions(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public void logAbandonRequest(AbandonOperation abandonOperation) {
        if (this.isCombinedMode || !this.isRequestLoggable(abandonOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(abandonOperation, "ABANDON", CATEGORY_REQUEST, buffer);
        this.appendAbandonRequest(abandonOperation, buffer);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logAbandonResult(AbandonOperation abandonOperation) {
        if (!this.isResponseLoggable(abandonOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(abandonOperation, "ABANDON", CATEGORY_RESPONSE, buffer);
        if (this.isCombinedMode) {
            this.appendAbandonRequest(abandonOperation, buffer);
        }
        buffer.append(" result=");
        buffer.append(abandonOperation.getResultCode().getIntValue());
        this.appendMessage(buffer, abandonOperation);
        this.logAdditionalLogItems(abandonOperation, buffer);
        this.appendEtime(buffer, abandonOperation);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logAddRequest(AddOperation addOperation) {
        if (this.isCombinedMode || !this.isRequestLoggable(addOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(addOperation, "ADD", CATEGORY_REQUEST, buffer);
        this.appendAddRequest(addOperation, buffer);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logAddResponse(AddOperation addOperation) {
        if (!this.isResponseLoggable(addOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(addOperation, "ADD", CATEGORY_RESPONSE, buffer);
        if (this.isCombinedMode) {
            this.appendAddRequest(addOperation, buffer);
        }
        buffer.append(" result=");
        buffer.append(addOperation.getResultCode().getIntValue());
        this.appendMessage(buffer, addOperation);
        this.logAdditionalLogItems(addOperation, buffer);
        this.appendLabelIfNotNull(buffer, "authzDN", addOperation.getProxiedAuthorizationDN());
        this.appendEtime(buffer, addOperation);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logBindRequest(BindOperation bindOperation) {
        if (this.isCombinedMode || !this.isRequestLoggable(bindOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(bindOperation, "BIND", CATEGORY_REQUEST, buffer);
        this.appendBindRequest(bindOperation, buffer);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logBindResponse(BindOperation bindOperation) {
        AuthenticationInfo authInfo;
        if (!this.isResponseLoggable(bindOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(bindOperation, "BIND", CATEGORY_RESPONSE, buffer);
        if (this.isCombinedMode) {
            this.appendBindRequest(bindOperation, buffer);
        }
        buffer.append(" result=");
        buffer.append(bindOperation.getResultCode().getIntValue());
        this.appendMessage(buffer, bindOperation);
        Message failureMessage = bindOperation.getAuthFailureReason();
        if (failureMessage != null) {
            buffer.append(" authFailureID=");
            buffer.append(failureMessage.getDescriptor().getId());
            this.appendLabel(buffer, "authFailureReason", failureMessage);
            if (bindOperation.getSASLMechanism() != null && bindOperation.getSASLAuthUserEntry() != null) {
                this.appendLabel(buffer, "authDN", bindOperation.getSASLAuthUserEntry().getDN());
            } else {
                this.appendLabel(buffer, "authDN", bindOperation.getRawBindDN());
            }
        }
        this.logAdditionalLogItems(bindOperation, buffer);
        if (bindOperation.getResultCode() == ResultCode.SUCCESS && (authInfo = bindOperation.getAuthenticationInfo()) != null) {
            DN authDN = authInfo.getAuthenticationDN();
            if (authDN != null) {
                this.appendLabel(buffer, "authDN", authDN);
                DN authzDN = authInfo.getAuthorizationDN();
                if (!authDN.equals(authzDN)) {
                    this.appendLabel(buffer, "authzDN", authzDN);
                }
            } else {
                buffer.append(" authDN=\"\"");
            }
        }
        this.appendEtime(buffer, bindOperation);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logCompareRequest(CompareOperation compareOperation) {
        if (this.isCombinedMode || !this.isRequestLoggable(compareOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(compareOperation, "COMPARE", CATEGORY_REQUEST, buffer);
        this.appendCompareRequest(compareOperation, buffer);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logCompareResponse(CompareOperation compareOperation) {
        if (!this.isResponseLoggable(compareOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(compareOperation, "COMPARE", CATEGORY_RESPONSE, buffer);
        if (this.isCombinedMode) {
            this.appendCompareRequest(compareOperation, buffer);
        }
        buffer.append(" result=");
        buffer.append(compareOperation.getResultCode().getIntValue());
        this.appendMessage(buffer, compareOperation);
        this.logAdditionalLogItems(compareOperation, buffer);
        this.appendLabelIfNotNull(buffer, "authzDN", compareOperation.getProxiedAuthorizationDN());
        this.appendEtime(buffer, compareOperation);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logConnect(ClientConnection clientConnection) {
        if (!this.isConnectLoggable(clientConnection)) {
            return;
        }
        long connectionID = clientConnection.getConnectionID();
        StringBuilder buffer = new StringBuilder(100);
        buffer.append('[');
        buffer.append(TimeThread.getUserDefinedTime(this.timeStampFormat));
        buffer.append(']');
        buffer.append(" CONNECT conn=");
        buffer.append(connectionID);
        buffer.append(" from=");
        buffer.append(clientConnection.getClientHostPort());
        buffer.append(" to=");
        buffer.append(clientConnection.getServerHostPort());
        buffer.append(" protocol=");
        buffer.append(clientConnection.getProtocol());
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logDeleteRequest(DeleteOperation deleteOperation) {
        if (this.isCombinedMode || !this.isRequestLoggable(deleteOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(deleteOperation, "DELETE", CATEGORY_REQUEST, buffer);
        this.appendDeleteRequest(deleteOperation, buffer);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logDeleteResponse(DeleteOperation deleteOperation) {
        if (!this.isResponseLoggable(deleteOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(deleteOperation, "DELETE", CATEGORY_RESPONSE, buffer);
        if (this.isCombinedMode) {
            this.appendDeleteRequest(deleteOperation, buffer);
        }
        buffer.append(" result=");
        buffer.append(deleteOperation.getResultCode().getIntValue());
        this.appendMessage(buffer, deleteOperation);
        this.logAdditionalLogItems(deleteOperation, buffer);
        this.appendLabelIfNotNull(buffer, "authzDN", deleteOperation.getProxiedAuthorizationDN());
        this.appendEtime(buffer, deleteOperation);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, Message message) {
        if (!this.isDisconnectLoggable(clientConnection)) {
            return;
        }
        long connectionID = clientConnection.getConnectionID();
        StringBuilder buffer = new StringBuilder(100);
        buffer.append('[');
        buffer.append(TimeThread.getUserDefinedTime(this.timeStampFormat));
        buffer.append(']');
        buffer.append(" DISCONNECT conn=");
        buffer.append(connectionID);
        this.appendLabel(buffer, "reason", (Object)disconnectReason);
        this.appendLabelIfNotNull(buffer, "msg", message);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logExtendedRequest(ExtendedOperation extendedOperation) {
        if (this.isCombinedMode || !this.isRequestLoggable(extendedOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(extendedOperation, "EXTENDED", CATEGORY_REQUEST, buffer);
        this.appendExtendedRequest(extendedOperation, buffer);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logExtendedResponse(ExtendedOperation extendedOperation) {
        String oid;
        if (!this.isResponseLoggable(extendedOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(extendedOperation, "EXTENDED", CATEGORY_RESPONSE, buffer);
        if (this.isCombinedMode) {
            this.appendExtendedRequest(extendedOperation, buffer);
        }
        if ((oid = extendedOperation.getResponseOID()) != null) {
            ExtendedOperationHandler extOpHandler = DirectoryServer.getExtendedOperationHandler(oid);
            if (extOpHandler != null) {
                String name = extOpHandler.getExtendedOperationName();
                this.appendLabelIfNotNull(buffer, "name", name);
            }
            this.appendLabel(buffer, "oid", oid);
        }
        buffer.append(" result=");
        buffer.append(extendedOperation.getResultCode().getIntValue());
        this.appendMessage(buffer, extendedOperation);
        this.logAdditionalLogItems(extendedOperation, buffer);
        this.appendEtime(buffer, extendedOperation);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyDNRequest(ModifyDNOperation modifyDNOperation) {
        if (this.isCombinedMode || !this.isRequestLoggable(modifyDNOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(modifyDNOperation, "MODIFYDN", CATEGORY_REQUEST, buffer);
        this.appendModifyDNRequest(modifyDNOperation, buffer);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyDNResponse(ModifyDNOperation modifyDNOperation) {
        if (!this.isResponseLoggable(modifyDNOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(modifyDNOperation, "MODIFYDN", CATEGORY_RESPONSE, buffer);
        if (this.isCombinedMode) {
            this.appendModifyDNRequest(modifyDNOperation, buffer);
        }
        buffer.append(" result=");
        buffer.append(modifyDNOperation.getResultCode().getIntValue());
        this.appendMessage(buffer, modifyDNOperation);
        this.logAdditionalLogItems(modifyDNOperation, buffer);
        this.appendLabelIfNotNull(buffer, "authzDN", modifyDNOperation.getProxiedAuthorizationDN());
        this.appendEtime(buffer, modifyDNOperation);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyRequest(ModifyOperation modifyOperation) {
        if (this.isCombinedMode || !this.isRequestLoggable(modifyOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(modifyOperation, "MODIFY", CATEGORY_REQUEST, buffer);
        this.appendModifyRequest(modifyOperation, buffer);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyResponse(ModifyOperation modifyOperation) {
        if (!this.isResponseLoggable(modifyOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(modifyOperation, "MODIFY", CATEGORY_RESPONSE, buffer);
        if (this.isCombinedMode) {
            this.appendModifyRequest(modifyOperation, buffer);
        }
        buffer.append(" result=");
        buffer.append(modifyOperation.getResultCode().getIntValue());
        this.appendMessage(buffer, modifyOperation);
        this.logAdditionalLogItems(modifyOperation, buffer);
        this.appendLabelIfNotNull(buffer, "authzDN", modifyOperation.getProxiedAuthorizationDN());
        this.appendEtime(buffer, modifyOperation);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logSearchRequest(SearchOperation searchOperation) {
        if (this.isCombinedMode || !this.isRequestLoggable(searchOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(192);
        this.appendHeader(searchOperation, "SEARCH", CATEGORY_REQUEST, buffer);
        this.appendSearchRequest(searchOperation, buffer);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logSearchResultDone(SearchOperation searchOperation) {
        if (!this.isResponseLoggable(searchOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(128);
        this.appendHeader(searchOperation, "SEARCH", CATEGORY_RESPONSE, buffer);
        if (this.isCombinedMode) {
            this.appendSearchRequest(searchOperation, buffer);
        }
        buffer.append(" result=");
        buffer.append(searchOperation.getResultCode().getIntValue());
        this.appendMessage(buffer, searchOperation);
        buffer.append(" nentries=");
        buffer.append(searchOperation.getEntriesSent());
        this.logAdditionalLogItems(searchOperation, buffer);
        this.appendLabelIfNotNull(buffer, "authzDN", searchOperation.getProxiedAuthorizationDN());
        this.appendEtime(buffer, searchOperation);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logUnbind(UnbindOperation unbindOperation) {
        if (!this.isRequestLoggable(unbindOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(unbindOperation, "UNBIND", CATEGORY_REQUEST, buffer);
        if (unbindOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    protected void close0() {
        this.writer.shutdown();
        TimeThread.removeUserDefinedFormatter(this.timeStampFormat);
        if (this.cfg != null) {
            this.cfg.removeFileBasedAccessChangeListener(this);
        }
    }

    private void appendAbandonRequest(AbandonOperation abandonOperation, StringBuilder buffer) {
        buffer.append(" idToAbandon=");
        buffer.append(abandonOperation.getIDToAbandon());
        this.appendRequestControls(abandonOperation, buffer);
        if (abandonOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
    }

    private void appendAddRequest(AddOperation addOperation, StringBuilder buffer) {
        this.appendLabel(buffer, "dn", addOperation.getRawEntryDN());
        this.appendRequestControls(addOperation, buffer);
        if (addOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
    }

    private void appendBindRequest(BindOperation bindOperation, StringBuilder buffer) {
        String protocolVersion = bindOperation.getProtocolVersion();
        if (protocolVersion != null) {
            buffer.append(" version=");
            buffer.append(protocolVersion);
        }
        switch (bindOperation.getAuthenticationType()) {
            case SIMPLE: {
                buffer.append(" type=SIMPLE");
                break;
            }
            case SASL: {
                buffer.append(" type=SASL mechanism=");
                buffer.append(bindOperation.getSASLMechanism());
                break;
            }
            default: {
                buffer.append(" type=");
                buffer.append((Object)bindOperation.getAuthenticationType());
            }
        }
        this.appendLabel(buffer, "dn", bindOperation.getRawBindDN());
        this.appendRequestControls(bindOperation, buffer);
        if (bindOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
    }

    private void appendCompareRequest(CompareOperation compareOperation, StringBuilder buffer) {
        this.appendLabel(buffer, "dn", compareOperation.getRawEntryDN());
        buffer.append(" attr=");
        buffer.append(compareOperation.getAttributeType().getNameOrOID());
        this.appendRequestControls(compareOperation, buffer);
        if (compareOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
    }

    private void appendDeleteRequest(DeleteOperation deleteOperation, StringBuilder buffer) {
        this.appendLabel(buffer, "dn", deleteOperation.getRawEntryDN());
        this.appendRequestControls(deleteOperation, buffer);
        if (deleteOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
    }

    private void appendExtendedRequest(ExtendedOperation extendedOperation, StringBuilder buffer) {
        String oid = extendedOperation.getRequestOID();
        ExtendedOperationHandler extOpHandler = DirectoryServer.getExtendedOperationHandler(oid);
        if (extOpHandler != null) {
            String name = extOpHandler.getExtendedOperationName();
            this.appendLabelIfNotNull(buffer, "name", name);
        }
        this.appendLabel(buffer, "oid", oid);
        this.appendRequestControls(extendedOperation, buffer);
        if (extendedOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
    }

    private void appendLabel(StringBuilder buffer, String label, Object obj) {
        buffer.append(' ').append(label).append("=\"");
        if (obj != null) {
            buffer.append(obj);
        }
        buffer.append('\"');
    }

    private void appendLabelIfNotNull(StringBuilder buffer, String label, Object obj) {
        if (obj != null) {
            this.appendLabel(buffer, label, obj);
        }
    }

    private void appendMessage(StringBuilder buffer, Operation operation) {
        MessageBuilder msg = operation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            this.appendLabel(buffer, "message", msg);
        }
    }

    private void appendEtime(StringBuilder buffer, Operation operation) {
        buffer.append(" etime=");
        long etime = operation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = operation.getProcessingTime();
        }
        buffer.append(etime);
    }

    private void appendHeader(Operation operation, String opType, String category, StringBuilder buffer) {
        buffer.append('[');
        buffer.append(TimeThread.getUserDefinedTime(this.timeStampFormat));
        buffer.append("] ");
        buffer.append(opType);
        if (!this.isCombinedMode) {
            buffer.append(' ');
            buffer.append(category);
        }
        buffer.append(" conn=");
        buffer.append(operation.getConnectionID());
        buffer.append(" op=");
        buffer.append(operation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(operation.getMessageID());
    }

    private void appendModifyDNRequest(ModifyDNOperation modifyDNOperation, StringBuilder buffer) {
        this.appendLabel(buffer, "dn", modifyDNOperation.getRawEntryDN());
        this.appendLabel(buffer, "newRDN", modifyDNOperation.getRawNewRDN());
        this.appendLabel(buffer, "deleteOldRDN", modifyDNOperation.deleteOldRDN());
        ByteString newSuperior = modifyDNOperation.getRawNewSuperior();
        this.appendLabelIfNotNull(buffer, "newSuperior", newSuperior);
        this.appendRequestControls(modifyDNOperation, buffer);
        if (modifyDNOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
    }

    private void appendModifyRequest(ModifyOperation modifyOperation, StringBuilder buffer) {
        this.appendLabel(buffer, "dn", modifyOperation.getRawEntryDN());
        this.appendRequestControls(modifyOperation, buffer);
        if (modifyOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
    }

    private void appendRequestControls(Operation operation, StringBuilder buffer) {
        if (this.includeControlOIDs && !operation.getRequestControls().isEmpty()) {
            buffer.append(" requestControls=");
            boolean isFirst = true;
            for (Control control : operation.getRequestControls()) {
                if (!isFirst) {
                    buffer.append(",");
                }
                buffer.append(control.getOID());
                isFirst = false;
            }
        }
    }

    private void appendResponseControls(Operation operation, StringBuilder buffer) {
        if (this.includeControlOIDs && !operation.getResponseControls().isEmpty()) {
            buffer.append(" responseControls=");
            boolean isFirst = true;
            for (Control control : operation.getResponseControls()) {
                if (!isFirst) {
                    buffer.append(",");
                }
                buffer.append(control.getOID());
                isFirst = false;
            }
        }
    }

    private void appendSearchRequest(SearchOperation searchOperation, StringBuilder buffer) {
        this.appendLabel(buffer, "base", searchOperation.getRawBaseDN());
        buffer.append(" scope=");
        buffer.append((Object)searchOperation.getScope());
        buffer.append(" filter=\"");
        searchOperation.getRawFilter().toString(buffer);
        Set<String> attrs = searchOperation.getAttributes();
        if (attrs == null || attrs.isEmpty()) {
            buffer.append("\" attrs=\"ALL\"");
        } else {
            buffer.append("\" attrs=\"");
            Iterator<String> iterator = attrs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(",");
                buffer.append(iterator.next());
            }
            buffer.append("\"");
        }
        this.appendRequestControls(searchOperation, buffer);
        if (searchOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
    }

    private void logAdditionalLogItems(Operation operation, StringBuilder builder) {
        this.appendResponseControls(operation, builder);
        for (AdditionalLogItem item : operation.getAdditionalLogItems()) {
            builder.append(' ');
            item.toString(builder);
        }
    }
}

