/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.ArrayList;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.EntryCacheMonitorProviderCfg;
import org.opends.server.api.EntryCache;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.Attribute;

public class EntryCacheMonitorProvider
extends MonitorProvider<EntryCacheMonitorProviderCfg> {
    private String monitorName;
    private String entryCacheName;
    private EntryCache<? extends EntryCacheCfg> entryCache;
    private EntryCacheMonitorProviderCfg monitorConfiguration;

    public EntryCacheMonitorProvider() {
        this.entryCacheName = "Entry Caches";
        this.entryCache = DirectoryServer.getEntryCache();
    }

    public EntryCacheMonitorProvider(String entryCacheName, EntryCache<? extends EntryCacheCfg> entryCache) {
        this.entryCacheName = entryCacheName + " Entry Cache";
        this.entryCache = entryCache;
    }

    @Override
    public void initializeMonitorProvider(EntryCacheMonitorProviderCfg configuration) throws ConfigException {
        this.monitorName = this.entryCacheName;
        if (configuration != null) {
            this.monitorConfiguration = configuration;
        }
        if (this.monitorConfiguration == null) {
            Message message = ConfigMessages.INFO_WARN_CONFIG_ENTRYCACHE_NO_MONITOR_CONFIG_ENTRY.get("cn=Entry Caches,cn=Monitor Providers,cn=config", this.monitorName);
            ErrorLogger.logError(message);
            throw new ConfigException(message);
        }
        if (!this.monitorConfiguration.isEnabled()) {
            Message message = ConfigMessages.INFO_WARN_CONFIG_ENTRYCACHE_MONITOR_CONFIG_DISABLED.get("cn=Entry Caches,cn=Monitor Providers,cn=config", this.monitorName);
            ErrorLogger.logError(message);
            throw new ConfigException(message);
        }
    }

    @Override
    public String getMonitorInstanceName() {
        return this.monitorName;
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (this.entryCache != null && this.monitorConfiguration != null && this.monitorConfiguration.isEnabled()) {
            attrs = this.entryCache.getMonitorData();
        }
        return attrs;
    }
}

