/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.opends.server.admin.std.server.SystemInfoMonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;

public class SystemInfoMonitorProvider
extends MonitorProvider<SystemInfoMonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeMonitorProvider(SystemInfoMonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        return "System Information";
    }

    public ArrayList<Attribute> getMonitorData() {
        List<Object> supportedTlsCiphers;
        List<Object> supportedTlsProtocols;
        RuntimeMXBean rtBean;
        List<String> jvmArguments;
        String instancePath;
        ArrayList<Attribute> attrs;
        block14: {
            attrs = new ArrayList<Attribute>(13);
            attrs.add(this.createAttribute("javaVersion", System.getProperty("java.version")));
            attrs.add(this.createAttribute("javaVendor", System.getProperty("java.vendor")));
            attrs.add(this.createAttribute("jvmVersion", System.getProperty("java.vm.version")));
            attrs.add(this.createAttribute("jvmVendor", System.getProperty("java.vm.vendor")));
            attrs.add(this.createAttribute("javaHome", System.getProperty("java.home")));
            attrs.add(this.createAttribute("classPath", System.getProperty("java.class.path")));
            attrs.add(this.createAttribute("workingDirectory", System.getProperty("user.dir")));
            String osInfo = System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
            attrs.add(this.createAttribute("operatingSystem", osInfo));
            String sunOsArchDataModel = System.getProperty("sun.arch.data.model");
            if (sunOsArchDataModel != null) {
                String jvmArch = sunOsArchDataModel;
                if (!sunOsArchDataModel.toLowerCase().equals("unknown")) {
                    jvmArch = jvmArch + "-bit";
                }
                attrs.add(this.createAttribute("jvmArchitecture", jvmArch));
            } else {
                attrs.add(this.createAttribute("jvmArchitecture", "unknown"));
            }
            try {
                attrs.add(this.createAttribute("systemName", InetAddress.getLocalHost().getCanonicalHostName()));
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block14;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        Runtime runtime = Runtime.getRuntime();
        attrs.add(this.createAttribute("availableCPUs", String.valueOf(runtime.availableProcessors())));
        attrs.add(this.createAttribute("maxMemory", String.valueOf(runtime.maxMemory())));
        attrs.add(this.createAttribute("usedMemory", String.valueOf(runtime.totalMemory())));
        attrs.add(this.createAttribute("freeUsedMemory", String.valueOf(runtime.freeMemory())));
        String installPath = DirectoryServer.getServerRoot();
        if (installPath != null) {
            attrs.add(this.createAttribute("installPath", installPath));
        }
        if ((instancePath = DirectoryServer.getInstanceRoot()) != null) {
            attrs.add(this.createAttribute("instancePath", instancePath));
        }
        if ((jvmArguments = (rtBean = ManagementFactory.getRuntimeMXBean()).getInputArguments()) != null && !jvmArguments.isEmpty()) {
            StringBuilder argList = new StringBuilder();
            for (String jvmArg : jvmArguments) {
                if (argList.length() > 0) {
                    argList.append(" ");
                }
                argList.append("\"");
                argList.append(jvmArg);
                argList.append("\"");
            }
            attrs.add(this.createAttribute("jvmArguments", argList.toString()));
        }
        try {
            SSLContext context = SSLContext.getDefault();
            SSLParameters parameters = context.getSupportedSSLParameters();
            supportedTlsProtocols = Arrays.asList(parameters.getProtocols());
            supportedTlsCiphers = Arrays.asList(parameters.getCipherSuites());
        }
        catch (Exception e) {
            supportedTlsProtocols = Collections.emptyList();
            supportedTlsCiphers = Collections.emptyList();
        }
        AttributeType supportedTLSProtocolsAttrType = DirectoryServer.getDefaultAttributeType("supportedTLSProtocols");
        AttributeBuilder builder = new AttributeBuilder(supportedTLSProtocolsAttrType);
        for (String string : supportedTlsProtocols) {
            builder.add(string);
        }
        attrs.add(builder.toAttribute());
        AttributeType supportedTLSCiphersAttrType = DirectoryServer.getDefaultAttributeType("supportedTLSCiphers");
        builder = new AttributeBuilder(supportedTLSCiphersAttrType);
        for (String string : supportedTlsCiphers) {
            builder.add(string);
        }
        attrs.add(builder.toAttribute());
        return attrs;
    }

    private Attribute createAttribute(String name, String value) {
        AttributeType attrType = DirectoryServer.getDefaultAttributeType(name);
        AttributeBuilder builder = new AttributeBuilder(attrType);
        builder.add(AttributeValues.create(attrType, value));
        return builder.toAttribute();
    }
}

