/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.AttributeCleanupPluginCfg;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.InitializationException;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreParseAddOperation;
import org.opends.server.types.operation.PreParseModifyOperation;
import org.opends.server.util.StaticUtils;

public class AttributeCleanupPlugin
extends DirectoryServerPlugin<AttributeCleanupPluginCfg>
implements ConfigurationChangeListener<AttributeCleanupPluginCfg> {
    private AttributeCleanupPluginCfg config;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Map<String, String> attributesToRename;
    private Set<String> attributesToRemove;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock sharedLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock exclusiveLock = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(AttributeCleanupPluginCfg config) {
        this.exclusiveLock.lock();
        try {
            this.config = config;
            this.attributesToRename = new HashMap<String, String>();
            for (String mapping : config.getRenameInboundAttributes()) {
                int colonPos = mapping.lastIndexOf(":");
                String fromAttr = mapping.substring(0, colonPos).trim();
                String toAttr = mapping.substring(colonPos + 1).trim();
                this.attributesToRename.put(StaticUtils.toLowerCase(fromAttr), StaticUtils.toLowerCase(toAttr));
            }
            this.attributesToRemove = new HashSet<String>();
            for (String attr : config.getRemoveInboundAttributes()) {
                this.attributesToRemove.add(StaticUtils.toLowerCase(attr.trim()));
            }
            ConfigChangeResult configChangeResult = new ConfigChangeResult(ResultCode.SUCCESS, false);
            return configChangeResult;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginResult.PreParse doPreParse(PreParseAddOperation addOperation) {
        this.sharedLock.lock();
        try {
            this.processInboundRemove(addOperation);
            this.processInboundRename(addOperation);
            PluginResult.PreParse preParse = PluginResult.PreParse.continueOperationProcessing();
            return preParse;
        }
        finally {
            this.sharedLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginResult.PreParse doPreParse(PreParseModifyOperation modifyOperation) {
        this.sharedLock.lock();
        try {
            this.processInboundRemove(modifyOperation);
            this.processInboundRename(modifyOperation);
            if (modifyOperation.getRawModifications().isEmpty()) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("The AttributeCleanupPlugin has eliminated all modifications. The processing should be stopped.");
                }
                PluginResult.PreParse preParse = PluginResult.PreParse.stopProcessing(ResultCode.SUCCESS, null);
                return preParse;
            }
            PluginResult.PreParse preParse = PluginResult.PreParse.continueOperationProcessing();
            return preParse;
        }
        finally {
            this.sharedLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizePlugin() {
        this.exclusiveLock.lock();
        try {
            this.config.removeAttributeCleanupChangeListener(this);
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    @Override
    public void initializePlugin(Set<PluginType> pluginTypes, AttributeCleanupPluginCfg configuration) throws ConfigException, InitializationException {
        block4: for (PluginType t : pluginTypes) {
            switch (t) {
                case PRE_PARSE_ADD: {
                    continue block4;
                }
                case PRE_PARSE_MODIFY: {
                    continue block4;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_ATTR_CLEANUP_INITIALIZE_PLUGIN.get(String.valueOf((Object)t));
            throw new ConfigException(message);
        }
        LinkedList<Message> messages = new LinkedList<Message>();
        if (!this.isConfigurationChangeAcceptable(configuration, (List<Message>)messages)) {
            throw new ConfigException((Message)messages.get(0));
        }
        configuration.addAttributeCleanupChangeListener(this);
        this.applyConfigurationChange(configuration);
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        AttributeCleanupPluginCfg cfg = (AttributeCleanupPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AttributeCleanupPluginCfg config, List<Message> messages) {
        boolean isValid = true;
        HashSet<String> fromAttrs = new HashSet<String>();
        for (String attr : config.getRenameInboundAttributes()) {
            String nfromAttr;
            String toAttrType;
            int colonPos = attr.lastIndexOf(":");
            String fromAttr = attr.substring(0, colonPos).trim();
            String toAttr = attr.substring(colonPos + 1).trim();
            int semicolonPos = toAttr.indexOf(";");
            String string = toAttrType = semicolonPos < 0 && semicolonPos < toAttr.length() - 1 ? toAttr : toAttr.substring(semicolonPos + 1);
            if (DirectoryServer.getAttributeType(StaticUtils.toLowerCase(toAttrType)) == null) {
                messages.add(PluginMessages.ERR_PLUGIN_ATTR_CLEANUP_ATTRIBUTE_MISSING.get(toAttr));
                isValid = false;
            }
            if (fromAttrs.contains(nfromAttr = StaticUtils.toLowerCase(fromAttr))) {
                messages.add(PluginMessages.ERR_PLUGIN_ATTR_CLEANUP_DUPLICATE_VALUE.get(fromAttr));
                isValid = false;
            } else {
                fromAttrs.add(nfromAttr);
            }
            if (!nfromAttr.equals(StaticUtils.toLowerCase(toAttr))) continue;
            messages.add(PluginMessages.ERR_PLUGIN_ATTR_CLEANUP_EQUAL_VALUES.get(fromAttr, toAttr));
            isValid = false;
        }
        return isValid;
    }

    private void processInboundRemove(PreParseAddOperation addOperation) {
        LinkedList<RawAttribute> inAttrs = new LinkedList<RawAttribute>(addOperation.getRawAttributes());
        ListIterator iterator = inAttrs.listIterator();
        while (iterator.hasNext()) {
            RawAttribute rawAttr = (RawAttribute)iterator.next();
            String attrName = StaticUtils.toLowerCase(rawAttr.getAttributeType().trim());
            if (!this.attributesToRemove.contains(attrName)) continue;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("AttributeCleanupPlugin removing '%s'", rawAttr.getAttributeType());
            }
            iterator.remove();
        }
        addOperation.setRawAttributes(inAttrs);
    }

    private void processInboundRemove(PreParseModifyOperation modifyOperation) {
        LinkedList<RawModification> rawMods = new LinkedList<RawModification>(modifyOperation.getRawModifications());
        ListIterator iterator = rawMods.listIterator();
        while (iterator.hasNext()) {
            RawModification rawMod = (RawModification)iterator.next();
            RawAttribute rawAttr = rawMod.getAttribute();
            String attrName = StaticUtils.toLowerCase(rawAttr.getAttributeType().trim());
            if (!this.attributesToRemove.contains(attrName)) continue;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("AttributeCleanupPlugin removing '%s'", rawAttr.getAttributeType());
            }
            iterator.remove();
        }
        modifyOperation.setRawModifications(rawMods);
    }

    private void processInboundRename(PreParseAddOperation addOperation) {
        LinkedList<RawAttribute> inAttrs = new LinkedList<RawAttribute>(addOperation.getRawAttributes());
        ListIterator iterator = inAttrs.listIterator();
        while (iterator.hasNext()) {
            RawAttribute rawAttr = (RawAttribute)iterator.next();
            String fromName = StaticUtils.toLowerCase(rawAttr.getAttributeType().trim());
            String toName = this.attributesToRename.get(fromName);
            if (toName == null) continue;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("AttributeCleanupPlugin renaming '%s' to '%s'", rawAttr.getAttributeType(), toName);
            }
            rawAttr.setAttributeType(toName);
        }
        addOperation.setRawAttributes(inAttrs);
    }

    private void processInboundRename(PreParseModifyOperation modifyOperation) {
        LinkedList<RawModification> rawMods = new LinkedList<RawModification>(modifyOperation.getRawModifications());
        ListIterator iterator = rawMods.listIterator();
        while (iterator.hasNext()) {
            RawModification rawMod = (RawModification)iterator.next();
            RawAttribute rawAttr = rawMod.getAttribute();
            String fromName = StaticUtils.toLowerCase(rawAttr.getAttributeType().trim());
            String toName = this.attributesToRename.get(fromName);
            if (toName == null) continue;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("AttributeCleanupPlugin renaming '%s' to '%s'", rawAttr.getAttributeType(), toName);
            }
            rawAttr.setAttributeType(toName);
        }
        modifyOperation.setRawModifications(rawMods);
    }
}

