/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.plugins.profiler.ProfileStack;
import org.opends.server.plugins.profiler.ProfileStackFrame;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class ProfileViewer
implements TreeSelectionListener {
    private HashMap<ProfileStackFrame, ProfileStackFrame> rootFrames = new HashMap();
    private HashMap<String, HashMap<ProfileStack, Long>> stacksByMethod = new HashMap();
    private JEditorPane frameInfoPane;
    private JTree profileTree;
    private long totalDuration = 0L;
    private long totalIntervals = 0L;

    public static void main(String[] args) {
        Message message;
        BooleanArgument useGUI = null;
        StringArgument fileNames = null;
        Message toolDescription = PluginMessages.INFO_PROFILEVIEWER_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser("org.opends.server.plugins.profiler.ProfileViewer", toolDescription, false);
        try {
            fileNames = new StringArgument("filenames", Character.valueOf('f'), "fileName", true, true, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, PluginMessages.INFO_PROFILEVIEWER_DESCRIPTION_FILENAMES.get());
            argParser.addArgument(fileNames);
            useGUI = new BooleanArgument("usegui", Character.valueOf('g'), "useGUI", PluginMessages.INFO_PROFILEVIEWER_DESCRIPTION_USE_GUI.get());
            argParser.addArgument(useGUI);
            BooleanArgument displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", PluginMessages.INFO_PROFILEVIEWER_DESCRIPTION_USAGE.get());
            argParser.addArgument(displayUsage);
            argParser.setUsageArgument(displayUsage);
        }
        catch (ArgumentException ae) {
            message = PluginMessages.ERR_PROFILEVIEWER_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            System.err.println(message);
            System.exit(1);
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            message = PluginMessages.ERR_PROFILEVIEWER_ERROR_PARSING_ARGS.get(ae.getMessage());
            System.err.println(message);
            System.err.println(argParser.getUsage());
            System.exit(1);
        }
        if (argParser.usageOrVersionDisplayed()) {
            System.exit(0);
        }
        ProfileViewer viewer = new ProfileViewer();
        for (String filename : fileNames.getValues()) {
            try {
                viewer.processDataFile(filename);
            }
            catch (Exception e) {
                Message message2 = PluginMessages.ERR_PROFILEVIEWER_CANNOT_PROCESS_DATA_FILE.get(filename, StaticUtils.stackTraceToSingleLineString(e));
                System.err.println(message2);
            }
        }
        if (useGUI.isPresent()) {
            viewer.displayGUI();
        } else {
            viewer.printProfileData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataFile(String filename) throws IOException, ASN1Exception {
        ASN1Reader reader = ASN1.getReader(new FileInputStream(filename));
        try {
            reader.readStartSequence();
            this.totalIntervals += reader.readInteger();
            long startTime = reader.readInteger();
            long stopTime = reader.readInteger();
            this.totalDuration += stopTime - startTime;
            reader.readEndSequence();
            while (reader.hasNextElement()) {
                String classAndMethod;
                HashMap<ProfileStack, Long> stackMap;
                ProfileStack stack = ProfileStack.decode(reader);
                long count = reader.readInteger();
                int pos = stack.getNumFrames() - 1;
                if (pos < 0) continue;
                String[] classNames = stack.getClassNames();
                String[] methodNames = stack.getMethodNames();
                int[] lineNumbers = stack.getLineNumbers();
                ProfileStackFrame frame = new ProfileStackFrame(classNames[pos], methodNames[pos]);
                ProfileStackFrame existingFrame = this.rootFrames.get(frame);
                if (existingFrame == null) {
                    existingFrame = frame;
                }
                if ((stackMap = this.stacksByMethod.get(classAndMethod = classNames[pos] + "." + methodNames[pos])) == null) {
                    stackMap = new HashMap();
                    this.stacksByMethod.put(classAndMethod, stackMap);
                }
                stackMap.put(stack, count);
                existingFrame.updateLineNumberCount(lineNumbers[pos], count);
                this.rootFrames.put(existingFrame, existingFrame);
                existingFrame.recurseSubFrames(stack, pos - 1, count, this.stacksByMethod);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public ProfileStackFrame[] getRootFrames() {
        Object[] frames = new ProfileStackFrame[]{};
        frames = this.rootFrames.values().toArray(frames);
        Arrays.sort(frames);
        return frames;
    }

    public long getTotalIntervals() {
        return this.totalIntervals;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public void printProfileData() {
        System.out.println("Total Intervals:     " + this.totalIntervals);
        System.out.println("Total Duration:      " + this.totalDuration);
        System.out.println();
        System.out.println();
        for (ProfileStackFrame frame : this.getRootFrames()) {
            ProfileViewer.printFrame(frame, 0);
        }
    }

    private static void printFrame(ProfileStackFrame frame, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.print(frame.getTotalCount());
        System.out.print("\t");
        System.out.print(frame.getClassName());
        System.out.print(".");
        System.out.println(frame.getMethodName());
        if (frame.hasSubFrames()) {
            for (ProfileStackFrame f : frame.getSubordinateFrames()) {
                ProfileViewer.printFrame(f, indent + 1);
            }
        }
    }

    public void displayGUI() {
        JFrame appWindow = new JFrame("Directory Server Profile Data");
        appWindow.setDefaultCloseOperation(3);
        JSplitPane splitPane = new JSplitPane(0);
        Container contentPane = appWindow.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setFont(new Font("Monospaced", 0, 12));
        String blankHTML = "<HTML><BODY><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR></BODY></HTML>";
        this.frameInfoPane = new JEditorPane("text/html", blankHTML);
        splitPane.setBottomComponent(new JScrollPane(this.frameInfoPane));
        String label = "Profile Data:  " + this.totalIntervals + " sample intervals " + "captured over " + this.totalDuration + " milliseconds";
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(label, true);
        ProfileStackFrame[] theRootFrames = this.getRootFrames();
        if (theRootFrames.length == 0) {
            System.err.println("ERROR:  No data available for viewing.");
            return;
        }
        for (ProfileStackFrame frame : this.getRootFrames()) {
            boolean hasChildren = frame.hasSubFrames();
            DefaultMutableTreeNode frameNode = new DefaultMutableTreeNode(frame, hasChildren);
            this.recurseTreeNodes(frame, frameNode);
            rootNode.add(frameNode);
        }
        this.profileTree = new JTree(new DefaultTreeModel(rootNode, true));
        this.profileTree.setFont(new Font("Monospaced", 0, 12));
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.profileTree.setSelectionModel(selectionModel);
        this.profileTree.addTreeSelectionListener(this);
        this.profileTree.setSelectionPath(new TreePath(rootNode.getFirstChild()));
        this.valueChanged(null);
        splitPane.setTopComponent(new JScrollPane(this.profileTree));
        splitPane.setResizeWeight(0.5);
        splitPane.setOneTouchExpandable(true);
        contentPane.add((Component)splitPane, "Center");
        appWindow.pack();
        appWindow.setVisible(true);
    }

    private void recurseTreeNodes(ProfileStackFrame parentFrame, DefaultMutableTreeNode parentNode) {
        ProfileStackFrame[] subFrames = parentFrame.getSubordinateFrames();
        if (subFrames.length == 0) {
            return;
        }
        for (ProfileStackFrame subFrame : subFrames) {
            boolean hasChildren = parentFrame.hasSubFrames();
            DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(subFrame, hasChildren);
            if (hasChildren) {
                this.recurseTreeNodes(subFrame, subNode);
            }
            parentNode.add(subNode);
        }
    }

    private String formatCount(long count, int length) {
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(count);
        while (buffer.length() < length) {
            buffer.insert(0, ' ');
        }
        return buffer.toString();
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        try {
            TreePath path = this.profileTree.getSelectionPath();
            if (path == null) {
                this.frameInfoPane.setText("");
                return;
            }
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (selectedNode == null) {
                this.frameInfoPane.setText("");
                return;
            }
            Object selectedObject = selectedNode.getUserObject();
            if (!(selectedObject instanceof ProfileStackFrame)) {
                this.frameInfoPane.setText("");
                return;
            }
            ProfileStackFrame frame = (ProfileStackFrame)selectedObject;
            StringBuilder html = new StringBuilder();
            html.append("<HTML><BODY><PRE>");
            html.append("Information for stack frame <B>");
            html.append(frame.getClassName());
            html.append(".");
            html.append(frame.getHTMLSafeMethodName());
            html.append("</B><BR><BR>Occurrences by Source Line Number:<BR>");
            HashMap<Integer, Long> lineNumbers = frame.getLineNumbers();
            for (Integer lineNumber : lineNumbers.keySet()) {
                html.append("     ");
                long count = lineNumbers.get(lineNumber);
                if (lineNumber == -2) {
                    html.append("&lt;native&gt;");
                } else if (lineNumber == -1) {
                    html.append("&lt;unknown&gt;");
                } else {
                    html.append("Line ");
                    html.append(lineNumber);
                }
                html.append(":  ");
                html.append(count);
                if (count == 1L) {
                    html.append(" occurrence<BR>");
                    continue;
                }
                html.append(" occurrences<BR>");
            }
            html.append("<BR><BR>");
            html.append("<HR>Stack Traces Including this Method:");
            String classAndMethod = frame.getClassName() + "." + frame.getMethodName();
            HashMap<ProfileStack, Long> stacks = this.stacksByMethod.get(classAndMethod);
            for (ProfileStack stack : stacks.keySet()) {
                html.append("<BR><BR>");
                html.append(stacks.get(stack));
                html.append(" occurrence(s):");
                this.appendHTMLStack(stack, html, classAndMethod);
            }
            html.append("</PRE></BODY></HTML>");
            this.frameInfoPane.setText(html.toString());
            this.frameInfoPane.setSelectionStart(0);
            this.frameInfoPane.setSelectionEnd(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.frameInfoPane.setText("");
        }
    }

    private void appendHTMLStack(ProfileStack stack, StringBuilder html, String highlightClassAndMethod) {
        int numFrames = stack.getNumFrames();
        for (int i = numFrames - 1; i >= 0; --i) {
            html.append("<BR>     ");
            String className = stack.getClassName(i);
            String methodName = stack.getMethodName(i);
            int lineNumber = stack.getLineNumber(i);
            String safeMethod = methodName.equals("<init>") ? "&lt;init&gt;" : methodName;
            String classAndMethod = className + "." + methodName;
            if (classAndMethod.equals(highlightClassAndMethod)) {
                html.append("<B>");
                html.append(className);
                html.append(".");
                html.append(safeMethod);
                html.append(":");
                if (lineNumber == -2) {
                    html.append("&lt;native&gt;");
                } else if (lineNumber == -1) {
                    html.append("&lt;unknown&gt;");
                } else {
                    html.append(lineNumber);
                }
                html.append("</B>");
                continue;
            }
            html.append(className);
            html.append(".");
            html.append(safeMethod);
            html.append(":");
            if (lineNumber == -2) {
                html.append("&lt;native&gt;");
                continue;
            }
            if (lineNumber == -1) {
                html.append("&lt;unknown&gt;");
                continue;
            }
            html.append(lineNumber);
        }
    }
}

