/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.JMXConnectionHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.jmx.RmiConnector;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.HostPort;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public final class JmxConnectionHandler
extends ConnectionHandler<JMXConnectionHandlerCfg>
implements ServerShutdownListener,
ConfigurationChangeListener<JMXConnectionHandlerCfg> {
    private static final String WILDCARD_ADDRESS = "0.0.0.0";
    public static final String TRUST_MANAGER_ARRAY_KEY = "org.opends.server.protocol.jmx.ssl.trust.manager.array";
    private static final String CLASS_NAME = "org.opends.server.protocols.jmx.JMXConnectionHandler";
    private final List<ClientConnection> connectionList;
    private JMXConnectionHandlerCfg currentConfig;
    private RmiConnector rmiConnector;
    private String connectionHandlerName;
    private String protocol;
    private final List<HostPort> listeners = new LinkedList<HostPort>();

    public JmxConnectionHandler() {
        super("JMX Connection Handler Thread");
        this.connectionList = new CopyOnWriteArrayList<ClientConnection>();
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(JMXConnectionHandlerCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        ArrayList<Message> messages = new ArrayList<Message>();
        boolean rmiConnectorRestart = false;
        boolean portChanged = false;
        if (this.currentConfig.getListenPort() != config.getListenPort()) {
            rmiConnectorRestart = true;
            portChanged = true;
        }
        if (this.currentConfig.isUseSSL() != config.isUseSSL()) {
            rmiConnectorRestart = true;
        }
        if (this.currentConfig.getSSLCertNickname() != null && !this.currentConfig.getSSLCertNickname().equals(config.getSSLCertNickname()) || config.getSSLCertNickname() != null && !config.getSSLCertNickname().equals(this.currentConfig.getSSLCertNickname())) {
            rmiConnectorRestart = true;
        }
        this.currentConfig = config;
        if (rmiConnectorRestart) {
            this.protocol = config.isUseSSL() ? "JMX+SSL" : "JMX";
            this.listeners.clear();
            this.listeners.add(new HostPort(config.getListenPort()));
            this.rmiConnector.finalizeConnectionHandler(portChanged);
            try {
                this.rmiConnector.initialize();
            }
            catch (RuntimeException e) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(Message.raw(e.getMessage(), new Object[0]));
            }
        }
        if (portChanged) {
            String key = this.protocol + "_port";
            String value = String.valueOf(config.getListenPort());
            System.clearProperty(key);
            System.setProperty(key, value);
        }
        return new ConfigChangeResult(resultCode, false, messages);
    }

    @Override
    public void finalizeConnectionHandler(Message finalizeReason) {
        this.currentConfig.removeJMXChangeListener(this);
        this.rmiConnector.finalizeConnectionHandler(true);
    }

    @Override
    public Collection<ClientConnection> getClientConnections() {
        return this.connectionList;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.currentConfig.dn();
    }

    public DN getKeyManagerProviderDN() {
        return this.currentConfig.getKeyManagerProviderDN();
    }

    public int getListenPort() {
        return this.currentConfig.getListenPort();
    }

    public RmiConnector getRMIConnector() {
        return this.rmiConnector;
    }

    @Override
    public String getShutdownListenerName() {
        return this.connectionHandlerName;
    }

    public String getSSLServerCertNickname() {
        return this.currentConfig.getSSLCertNickname();
    }

    @Override
    public void initializeConnectionHandler(JMXConnectionHandlerCfg config) throws ConfigException, InitializationException {
        this.currentConfig = config;
        try {
            if (StaticUtils.isAddressInUse(new InetSocketAddress(config.getListenPort()).getAddress(), config.getListenPort(), true)) {
                throw new IOException(ProtocolMessages.ERR_CONNHANDLER_ADDRESS_INUSE.get().toString());
            }
        }
        catch (Exception e) {
            Message message = ProtocolMessages.ERR_CONNHANDLER_CANNOT_BIND.get("JMX", String.valueOf(config.dn()), WILDCARD_ADDRESS, config.getListenPort(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            throw new InitializationException(message);
        }
        this.protocol = config.isUseSSL() ? "JMX+SSL" : "JMX";
        this.listeners.clear();
        this.listeners.add(new HostPort(WILDCARD_ADDRESS, config.getListenPort()));
        this.connectionHandlerName = "JMX Connection Handler " + config.getListenPort();
        System.setProperty(this.protocol + "_port", String.valueOf(config.getListenPort()));
        this.rmiConnector = new RmiConnector(DirectoryServer.getJMXMBeanServer(), this);
        config.addJMXChangeListener(this);
    }

    @Override
    public String getConnectionHandlerName() {
        return this.connectionHandlerName;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public Collection<HostPort> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean isConfigurationAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        JMXConnectionHandlerCfg config = (JMXConnectionHandlerCfg)configuration;
        if (this.currentConfig == null || !this.currentConfig.isEnabled() && config.isEnabled() || this.currentConfig.getListenPort() != config.getListenPort()) {
            try {
                if (StaticUtils.isAddressInUse(new InetSocketAddress(config.getListenPort()).getAddress(), config.getListenPort(), true)) {
                    throw new IOException(ProtocolMessages.ERR_CONNHANDLER_ADDRESS_INUSE.get().toString());
                }
            }
            catch (Exception e) {
                Message message = ProtocolMessages.ERR_CONNHANDLER_CANNOT_BIND.get("JMX", String.valueOf(config.dn()), WILDCARD_ADDRESS, config.getListenPort(), StaticUtils.getExceptionMessage(e));
                unacceptableReasons.add(message);
                return false;
            }
        }
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(JMXConnectionHandlerCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    public boolean isUseSSL() {
        return this.currentConfig.isUseSSL();
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.rmiConnector.finalizeConnectionHandler(true);
    }

    public void registerClientConnection(ClientConnection connection) {
        this.connectionList.add(connection);
    }

    public void unregisterClientConnection(ClientConnection connection) {
        this.connectionList.remove(connection);
    }

    @Override
    public void run() {
        try {
            this.rmiConnector.initialize();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.connectionHandlerName);
    }
}

