/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.util.ServerConstants;

public class AbandonRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int idToAbandon;

    public AbandonRequestProtocolOp(int idToAbandon) {
        this.idToAbandon = idToAbandon;
    }

    public int getIDToAbandon() {
        return this.idToAbandon;
    }

    @Override
    public byte getType() {
        return 80;
    }

    @Override
    public String getProtocolOpName() {
        return "Abandon Request";
    }

    @Override
    public void write(ASN1Writer stream) throws IOException {
        stream.writeInteger((byte)80, this.idToAbandon);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("AbandonRequest(idToAbandon=");
        buffer.append(this.idToAbandon);
        buffer.append(")");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Abandon Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  ID to Abandon:  ");
        buffer.append(this.idToAbandon);
        buffer.append(ServerConstants.EOL);
    }
}

