/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OperationType;

public class LDAPStatistics
extends MonitorProvider<MonitorProviderCfg> {
    private AtomicLong abandonRequests = new AtomicLong(0L);
    private AtomicLong addRequests = new AtomicLong(0L);
    private AtomicLong bindRequests = new AtomicLong(0L);
    private AtomicLong addResponses = new AtomicLong(0L);
    private AtomicLong bindResponses = new AtomicLong(0L);
    private AtomicLong bytesRead = new AtomicLong(0L);
    private AtomicLong bytesWritten = new AtomicLong(0L);
    private AtomicLong compareRequests = new AtomicLong(0L);
    private AtomicLong compareResponses = new AtomicLong(0L);
    private AtomicLong connectionsClosed = new AtomicLong(0L);
    private AtomicLong connectionsEstablished = new AtomicLong(0L);
    private AtomicLong deleteRequests = new AtomicLong(0L);
    private AtomicLong deleteResponses = new AtomicLong(0L);
    private AtomicLong extendedRequests = new AtomicLong(0L);
    private AtomicLong extendedResponses = new AtomicLong(0L);
    private AtomicLong messagesRead = new AtomicLong(0L);
    private AtomicLong messagesWritten = new AtomicLong(0L);
    private AtomicLong modifyRequests = new AtomicLong(0L);
    private AtomicLong modifyResponses = new AtomicLong(0L);
    private AtomicLong modifyDNRequests = new AtomicLong(0L);
    private AtomicLong modifyDNResponses = new AtomicLong(0L);
    private AtomicLong operationsAbandoned = new AtomicLong(0L);
    private AtomicLong operationsCompleted = new AtomicLong(0L);
    private AtomicLong operationsInitiated = new AtomicLong(0L);
    private AtomicLong searchRequests = new AtomicLong(0L);
    private AtomicLong searchOneRequests = new AtomicLong(0L);
    private AtomicLong searchSubRequests = new AtomicLong(0L);
    private AtomicLong searchResultEntries = new AtomicLong(0L);
    private AtomicLong searchResultReferences = new AtomicLong(0L);
    private AtomicLong searchResultsDone = new AtomicLong(0L);
    private AtomicLong unbindRequests = new AtomicLong(0L);
    private final String instanceName;
    private AtomicLong addOperationCount = new AtomicLong(0L);
    private AtomicLong addOperationTime = new AtomicLong(0L);
    private AtomicLong searchOperationCount = new AtomicLong(0L);
    private AtomicLong searchOperationTime = new AtomicLong(0L);
    private AtomicLong delOperationCount = new AtomicLong(0L);
    private AtomicLong delOperationTime = new AtomicLong(0L);
    private AtomicLong bindOperationCount = new AtomicLong(0L);
    private AtomicLong bindOperationTime = new AtomicLong(0L);
    private AtomicLong unbindOperationCount = new AtomicLong(0L);
    private AtomicLong unbindOperationTime = new AtomicLong(0L);
    private AtomicLong compOperationCount = new AtomicLong(0L);
    private AtomicLong compOperationTime = new AtomicLong(0L);
    private AtomicLong modOperationCount = new AtomicLong(0L);
    private AtomicLong modOperationTime = new AtomicLong(0L);
    private AtomicLong moddnOperationCount = new AtomicLong(0L);
    private AtomicLong moddnOperationTime = new AtomicLong(0L);
    private AtomicLong abandonOperationCount = new AtomicLong(0L);
    private AtomicLong abandonOperationTime = new AtomicLong(0L);
    private AtomicLong extOperationCount = new AtomicLong(0L);
    private AtomicLong extOperationTime = new AtomicLong(0L);

    public LDAPStatistics(String instanceName) {
        this.instanceName = instanceName;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException {
        Message message = ProtocolMessages.ERR_LDAP_STATS_INVALID_MONITOR_INITIALIZATION.get(String.valueOf(configuration.dn()));
        throw new ConfigException(message);
    }

    @Override
    public String getMonitorInstanceName() {
        return this.instanceName;
    }

    @Override
    public ObjectClass getMonitorObjectClass() {
        return DirectoryConfig.getObjectClass("ds-connectionhandler-statistics-monitor-entry", true);
    }

    @Override
    public List<Attribute> getMonitorData() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        long tmpAbandonRequests = this.abandonRequests.get();
        long tmpAddRequests = this.addRequests.get();
        long tmpAddResponses = this.addResponses.get();
        long tmpBindRequests = this.bindRequests.get();
        long tmpBindResponses = this.bindResponses.get();
        long tmpBytesRead = this.bytesRead.get();
        long tmpBytesWritten = this.bytesWritten.get();
        long tmpCompareRequests = this.compareRequests.get();
        long tmpCompareResponses = this.compareResponses.get();
        long tmpConnectionsClosed = this.connectionsClosed.get();
        long tmpConnectionsEstablished = this.connectionsEstablished.get();
        long tmpDeleteRequests = this.deleteRequests.get();
        long tmpDeleteResponses = this.deleteResponses.get();
        long tmpExtendedRequests = this.extendedRequests.get();
        long tmpExtendedResponses = this.extendedResponses.get();
        long tmpMessagesRead = this.messagesRead.get();
        long tmpMessagesWritten = this.messagesWritten.get();
        long tmpModifyRequests = this.modifyRequests.get();
        long tmpModifyResponses = this.modifyResponses.get();
        long tmpModifyDNRequests = this.modifyDNRequests.get();
        long tmpModifyDNResponses = this.modifyDNResponses.get();
        long tmpOperationsAbandoned = this.operationsAbandoned.get();
        long tmpOperationsCompleted = this.operationsCompleted.get();
        long tmpOperationsInitiated = this.operationsInitiated.get();
        long tmpSearchRequests = this.searchRequests.get();
        long tmpSearchOneRequests = this.searchOneRequests.get();
        long tmpSearchSubRequests = this.searchSubRequests.get();
        long tmpSearchEntries = this.searchResultEntries.get();
        long tmpSearchReferences = this.searchResultReferences.get();
        long tmpSearchResultsDone = this.searchResultsDone.get();
        long tmpUnbindRequests = this.unbindRequests.get();
        long tmpAddOperationCount = this.addOperationCount.get();
        long tmpAddOperationTime = this.addOperationTime.get();
        long tmpSearchOperationCount = this.searchOperationCount.get();
        long tmpSearchOperationTime = this.searchOperationTime.get();
        long tmpDelOperationCount = this.delOperationCount.get();
        long tmpDelOperationTime = this.delOperationTime.get();
        long tmpBindOperationCount = this.bindOperationCount.get();
        long tmpBindOperationTime = this.bindOperationTime.get();
        long tmpUnbindOperationCount = this.unbindOperationCount.get();
        long tmpUnbindOperationTime = this.unbindOperationTime.get();
        long tmpCompOperationCount = this.compOperationCount.get();
        long tmpCompOperationTime = this.compOperationTime.get();
        long tmpModOperationCount = this.modOperationCount.get();
        long tmpModOperationTime = this.modOperationTime.get();
        long tmpModdnOperationCount = this.moddnOperationCount.get();
        long tmpModdnOperationTime = this.moddnOperationTime.get();
        long tmpAbandonOperationCount = this.abandonOperationCount.get();
        long tmpAbandonOperationTime = this.abandonOperationTime.get();
        long tmpExtOperationCount = this.extOperationCount.get();
        long tmpExtOperationTime = this.extOperationTime.get();
        attrs.add(this.createAttribute("connectionsEstablished", String.valueOf(tmpConnectionsEstablished)));
        attrs.add(this.createAttribute("connectionsClosed", String.valueOf(tmpConnectionsClosed)));
        attrs.add(this.createAttribute("bytesRead", String.valueOf(tmpBytesRead)));
        attrs.add(this.createAttribute("bytesWritten", String.valueOf(tmpBytesWritten)));
        attrs.add(this.createAttribute("ldapMessagesRead", String.valueOf(tmpMessagesRead)));
        attrs.add(this.createAttribute("ldapMessagesWritten", String.valueOf(tmpMessagesWritten)));
        attrs.add(this.createAttribute("operationsAbandoned", String.valueOf(tmpOperationsAbandoned)));
        attrs.add(this.createAttribute("operationsInitiated", String.valueOf(tmpOperationsInitiated)));
        attrs.add(this.createAttribute("operationsCompleted", String.valueOf(tmpOperationsCompleted)));
        attrs.add(this.createAttribute("abandonRequests", String.valueOf(tmpAbandonRequests)));
        attrs.add(this.createAttribute("addRequests", String.valueOf(tmpAddRequests)));
        attrs.add(this.createAttribute("addResponses", String.valueOf(tmpAddResponses)));
        attrs.add(this.createAttribute("bindRequests", String.valueOf(tmpBindRequests)));
        attrs.add(this.createAttribute("bindResponses", String.valueOf(tmpBindResponses)));
        attrs.add(this.createAttribute("compareRequests", String.valueOf(tmpCompareRequests)));
        attrs.add(this.createAttribute("compareResponses", String.valueOf(tmpCompareResponses)));
        attrs.add(this.createAttribute("deleteRequests", String.valueOf(tmpDeleteRequests)));
        attrs.add(this.createAttribute("deleteResponses", String.valueOf(tmpDeleteResponses)));
        attrs.add(this.createAttribute("extendedRequests", String.valueOf(tmpExtendedRequests)));
        attrs.add(this.createAttribute("extendedResponses", String.valueOf(tmpExtendedResponses)));
        attrs.add(this.createAttribute("modifyRequests", String.valueOf(tmpModifyRequests)));
        attrs.add(this.createAttribute("modifyResponses", String.valueOf(tmpModifyResponses)));
        attrs.add(this.createAttribute("modifyDNRequests", String.valueOf(tmpModifyDNRequests)));
        attrs.add(this.createAttribute("modifyDNResponses", String.valueOf(tmpModifyDNResponses)));
        attrs.add(this.createAttribute("searchRequests", String.valueOf(tmpSearchRequests)));
        attrs.add(this.createAttribute("searchOneRequests", String.valueOf(tmpSearchOneRequests)));
        attrs.add(this.createAttribute("searchSubRequests", String.valueOf(tmpSearchSubRequests)));
        attrs.add(this.createAttribute("searchResultEntries", String.valueOf(tmpSearchEntries)));
        attrs.add(this.createAttribute("searchResultReferences", String.valueOf(tmpSearchReferences)));
        attrs.add(this.createAttribute("searchResultsDone", String.valueOf(tmpSearchResultsDone)));
        attrs.add(this.createAttribute("unbindRequests", String.valueOf(tmpUnbindRequests)));
        attrs.add(this.createAttribute("ds-mon-add-operations-total-count", String.valueOf(tmpAddOperationCount)));
        attrs.add(this.createAttribute("ds-mon-resident-time-add-operations-total-time", String.valueOf(tmpAddOperationTime)));
        attrs.add(this.createAttribute("ds-mon-search-operations-total-count", String.valueOf(tmpSearchOperationCount)));
        attrs.add(this.createAttribute("ds-mon-resident-time-search-operations-total-time", String.valueOf(tmpSearchOperationTime)));
        attrs.add(this.createAttribute("ds-mon-bind-operations-total-count", String.valueOf(tmpBindOperationCount)));
        attrs.add(this.createAttribute("ds-mon-resident-time-bind-operations-total-time", String.valueOf(tmpBindOperationTime)));
        attrs.add(this.createAttribute("ds-mon-unbind-operations-total-count", String.valueOf(tmpUnbindOperationCount)));
        attrs.add(this.createAttribute("ds-mon-resident-time-unbind-operations-total-time", String.valueOf(tmpUnbindOperationTime)));
        attrs.add(this.createAttribute("ds-mon-compare-operations-total-count", String.valueOf(tmpCompOperationCount)));
        attrs.add(this.createAttribute("ds-mon-resident-time-compare-operations-total-time", String.valueOf(tmpCompOperationTime)));
        attrs.add(this.createAttribute("ds-mon-delete-operations-total-count", String.valueOf(tmpDelOperationCount)));
        attrs.add(this.createAttribute("ds-mon-resident-time-delete-operations-total-time", String.valueOf(tmpDelOperationTime)));
        attrs.add(this.createAttribute("ds-mon-mod-operations-total-count", String.valueOf(tmpModOperationCount)));
        attrs.add(this.createAttribute("ds-mon-resident-time-mod-operations-total-time", String.valueOf(tmpModOperationTime)));
        attrs.add(this.createAttribute("ds-mon-moddn-operations-total-count", String.valueOf(tmpModdnOperationCount)));
        attrs.add(this.createAttribute("ds-mon-resident-time-moddn-operations-total-time", String.valueOf(tmpModdnOperationTime)));
        attrs.add(this.createAttribute("ds-mon-abandon-operations-total-count", String.valueOf(tmpAbandonOperationCount)));
        attrs.add(this.createAttribute("ds-mon-resident-time-abandon-operations-total-time", String.valueOf(tmpAbandonOperationTime)));
        attrs.add(this.createAttribute("ds-mon-extended-operations-total-count", String.valueOf(tmpExtOperationCount)));
        attrs.add(this.createAttribute("ds-mon-resident-time-extended-operations-total-time", String.valueOf(tmpExtOperationTime)));
        return attrs;
    }

    public void clearStatistics() {
        this.abandonRequests.set(0L);
        this.addRequests.set(0L);
        this.addResponses.set(0L);
        this.bindRequests.set(0L);
        this.bindResponses.set(0L);
        this.bytesRead.set(0L);
        this.bytesWritten.set(0L);
        this.compareRequests.set(0L);
        this.compareResponses.set(0L);
        this.connectionsClosed.set(0L);
        this.connectionsEstablished.set(0L);
        this.deleteRequests.set(0L);
        this.deleteResponses.set(0L);
        this.extendedRequests.set(0L);
        this.extendedResponses.set(0L);
        this.messagesRead.set(0L);
        this.messagesWritten.set(0L);
        this.modifyRequests.set(0L);
        this.modifyResponses.set(0L);
        this.modifyDNRequests.set(0L);
        this.modifyDNResponses.set(0L);
        this.operationsAbandoned.set(0L);
        this.operationsCompleted.set(0L);
        this.operationsInitiated.set(0L);
        this.searchRequests.set(0L);
        this.searchOneRequests.set(0L);
        this.searchSubRequests.set(0L);
        this.searchResultEntries.set(0L);
        this.searchResultReferences.set(0L);
        this.searchResultsDone.set(0L);
        this.unbindRequests.set(0L);
        this.addOperationCount.set(0L);
        this.addOperationTime.set(0L);
        this.searchOperationCount.set(0L);
        this.searchOperationTime.set(0L);
        this.delOperationCount.set(0L);
        this.delOperationTime.set(0L);
        this.bindOperationCount.set(0L);
        this.bindOperationTime.set(0L);
        this.unbindOperationCount.set(0L);
        this.unbindOperationTime.set(0L);
        this.compOperationCount.set(0L);
        this.compOperationTime.set(0L);
        this.modOperationCount.set(0L);
        this.modOperationTime.set(0L);
        this.moddnOperationCount.set(0L);
        this.moddnOperationTime.set(0L);
        this.abandonOperationCount.set(0L);
        this.abandonOperationTime.set(0L);
        this.extOperationCount.set(0L);
        this.extOperationTime.set(0L);
    }

    public void updateConnect() {
        this.connectionsEstablished.getAndIncrement();
    }

    public void updateDisconnect() {
        this.connectionsClosed.getAndIncrement();
    }

    public void updateBytesRead(int bytesRead) {
        this.bytesRead.getAndAdd(bytesRead);
    }

    public void updateBytesWritten(int bytesWritten) {
        this.bytesWritten.getAndAdd(bytesWritten);
    }

    public void updateMessageRead(LDAPMessage message) {
        this.messagesRead.getAndIncrement();
        this.operationsInitiated.getAndIncrement();
        block0 : switch (message.getProtocolOp().getType()) {
            case 80: {
                this.abandonRequests.getAndIncrement();
                break;
            }
            case 104: {
                this.addRequests.getAndIncrement();
                break;
            }
            case 96: {
                this.bindRequests.getAndIncrement();
                break;
            }
            case 110: {
                this.compareRequests.getAndIncrement();
                break;
            }
            case 74: {
                this.deleteRequests.getAndIncrement();
                break;
            }
            case 119: {
                this.extendedRequests.getAndIncrement();
                break;
            }
            case 102: {
                this.modifyRequests.getAndIncrement();
                break;
            }
            case 108: {
                this.modifyDNRequests.getAndIncrement();
                break;
            }
            case 99: {
                this.searchRequests.getAndIncrement();
                SearchRequestProtocolOp s = (SearchRequestProtocolOp)message.getProtocolOp();
                switch (s.getScope()) {
                    case BASE_OBJECT: {
                        break block0;
                    }
                    case SINGLE_LEVEL: {
                        this.searchOneRequests.getAndIncrement();
                        break block0;
                    }
                    case WHOLE_SUBTREE: {
                        this.searchSubRequests.getAndIncrement();
                        break block0;
                    }
                }
                break;
            }
            case 66: {
                this.unbindRequests.getAndIncrement();
            }
        }
    }

    public void updateMessageWritten(LDAPMessage message) {
        this.messagesWritten.getAndIncrement();
        switch (message.getProtocolOp().getType()) {
            case 105: {
                this.addResponses.getAndIncrement();
                this.operationsCompleted.getAndIncrement();
                break;
            }
            case 97: {
                this.bindResponses.getAndIncrement();
                this.operationsCompleted.getAndIncrement();
                break;
            }
            case 111: {
                this.compareResponses.getAndIncrement();
                this.operationsCompleted.getAndIncrement();
                break;
            }
            case 107: {
                this.deleteResponses.getAndIncrement();
                this.operationsCompleted.getAndIncrement();
                break;
            }
            case 120: {
                this.extendedResponses.getAndIncrement();
                if (message.getMessageID() <= 0) break;
                this.operationsCompleted.getAndIncrement();
                break;
            }
            case 103: {
                this.modifyResponses.getAndIncrement();
                this.operationsCompleted.getAndIncrement();
                break;
            }
            case 109: {
                this.modifyDNResponses.getAndIncrement();
                this.operationsCompleted.getAndIncrement();
                break;
            }
            case 100: {
                this.searchResultEntries.getAndIncrement();
                break;
            }
            case 115: {
                this.searchResultReferences.getAndIncrement();
                break;
            }
            case 101: {
                this.searchResultsDone.getAndIncrement();
                this.operationsCompleted.getAndIncrement();
            }
        }
    }

    public void updateAbandonedOperation() {
        this.operationsAbandoned.getAndIncrement();
    }

    protected Attribute createAttribute(String name, String value) {
        AttributeType attrType = DirectoryServer.getAttributeType(name.toLowerCase());
        AttributeBuilder builder = new AttributeBuilder(attrType, name);
        builder.add(AttributeValues.create(attrType, value));
        return builder.toAttribute();
    }

    public long getConnectionsEstablished() {
        return this.connectionsEstablished.get();
    }

    public long getConnectionsClosed() {
        return this.connectionsClosed.get();
    }

    public long getBytesRead() {
        return this.bytesRead.get();
    }

    public long getBytesWritten() {
        return this.bytesWritten.get();
    }

    public long getMessagesRead() {
        return this.messagesRead.get();
    }

    public long getMessagesWritten() {
        return this.messagesWritten.get();
    }

    public long getOperationsInitiated() {
        return this.operationsInitiated.get();
    }

    public long getOperationsCompleted() {
        return this.operationsCompleted.get();
    }

    public long getOperationsAbandoned() {
        return this.operationsAbandoned.get();
    }

    public long getAbandonRequests() {
        return this.abandonRequests.get();
    }

    public long getAddRequests() {
        return this.addRequests.get();
    }

    public long getAddResponses() {
        return this.addResponses.get();
    }

    public long getBindRequests() {
        return this.bindRequests.get();
    }

    public long getBindResponses() {
        return this.bindResponses.get();
    }

    public long getCompareRequests() {
        return this.compareRequests.get();
    }

    public long getCompareResponses() {
        return this.compareResponses.get();
    }

    public long getDeleteRequests() {
        return this.deleteRequests.get();
    }

    public long getDeleteResponses() {
        return this.deleteResponses.get();
    }

    public long getExtendedRequests() {
        return this.extendedRequests.get();
    }

    public long getExtendedResponses() {
        return this.extendedResponses.get();
    }

    public long getModifyRequests() {
        return this.modifyRequests.get();
    }

    public long getModifyResponses() {
        return this.modifyResponses.get();
    }

    public long getModifyDNRequests() {
        return this.modifyDNRequests.get();
    }

    public long getModifyDNResponses() {
        return this.modifyDNResponses.get();
    }

    public long getSearchRequests() {
        return this.searchRequests.get();
    }

    public long getSearchOneRequests() {
        return this.searchOneRequests.get();
    }

    public long getSearchSubRequests() {
        return this.searchSubRequests.get();
    }

    public long getSearchResultEntries() {
        return this.searchResultEntries.get();
    }

    public long getSearchResultReferences() {
        return this.searchResultReferences.get();
    }

    public long getSearchResultsDone() {
        return this.searchResultsDone.get();
    }

    public long getUnbindRequests() {
        return this.unbindRequests.get();
    }

    public void updateOperationMonitoringData(OperationType type, long time) {
        if (type.equals((Object)OperationType.ADD)) {
            this.addOperationCount.getAndIncrement();
            this.addOperationTime.getAndAdd(time);
        } else if (type.equals((Object)OperationType.SEARCH)) {
            this.searchOperationCount.getAndIncrement();
            this.searchOperationTime.getAndAdd(time);
        } else if (type.equals((Object)OperationType.ABANDON)) {
            this.abandonOperationCount.getAndIncrement();
            this.abandonOperationTime.getAndAdd(time);
        } else if (type.equals((Object)OperationType.BIND)) {
            this.bindOperationCount.getAndIncrement();
            this.bindOperationTime.getAndAdd(time);
        } else if (type.equals((Object)OperationType.UNBIND)) {
            this.unbindOperationCount.getAndIncrement();
            this.unbindOperationTime.getAndAdd(time);
        } else if (type.equals((Object)OperationType.COMPARE)) {
            this.compOperationCount.getAndIncrement();
            this.compOperationTime.getAndAdd(time);
        } else if (type.equals((Object)OperationType.DELETE)) {
            this.delOperationCount.getAndIncrement();
            this.delOperationTime.getAndAdd(time);
        } else if (type.equals((Object)OperationType.EXTENDED)) {
            this.extOperationCount.getAndIncrement();
            this.extOperationTime.getAndAdd(time);
        } else if (type.equals((Object)OperationType.MODIFY)) {
            this.modOperationCount.getAndIncrement();
            this.modOperationTime.getAndAdd(time);
        } else if (type.equals((Object)OperationType.MODIFY_DN)) {
            this.moddnOperationCount.getAndIncrement();
            this.moddnOperationTime.getAndAdd(time);
        }
    }
}

