/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.plugin.HistoricalAttributeValue;
import org.opends.server.replication.plugin.LDAPReplicationDomain;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;

public class PersistentServerState {
    private final DN baseDn;
    private final InternalClientConnection conn = InternalClientConnection.getRootConnection();
    private final int serverId;
    private final ServerState state;
    protected static final String REPLICATION_STATE = "ds-sync-state";

    public PersistentServerState(DN baseDn, int serverId) {
        this.baseDn = baseDn;
        this.serverId = serverId;
        this.state = new ServerState();
        this.loadState();
    }

    public PersistentServerState(DN baseDn, int serverId, ServerState state) {
        this.baseDn = baseDn;
        this.serverId = serverId;
        this.state = state;
        this.loadState();
    }

    public boolean cover(ChangeNumber covered) {
        return this.state.cover(covered);
    }

    public boolean update(ChangeNumber changeNumber) {
        return this.state.update(changeNumber);
    }

    public void save() {
        if (this.state.isSaved()) {
            return;
        }
        this.state.setSaved(true);
        ResultCode resultCode = this.updateStateEntry();
        if (resultCode != ResultCode.SUCCESS) {
            this.state.setSaved(false);
        }
    }

    public void loadState() {
        SearchResultEntry stateEntry = this.searchBaseEntry();
        if (stateEntry == null) {
            stateEntry = this.searchConfigEntry();
        }
        if (stateEntry != null) {
            this.updateStateFromEntry(stateEntry);
        }
        this.checkAndUpdateServerState();
    }

    private SearchResultEntry searchBaseEntry() {
        try {
            LinkedList<SearchResultEntry> result;
            SearchFilter filter = SearchFilter.createFilterFromString("objectclass=*");
            LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
            attributes.add(REPLICATION_STATE);
            InternalSearchOperation search = this.conn.processSearch(this.baseDn, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, attributes);
            if (search.getResultCode() != ResultCode.SUCCESS && search.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
                Message message = ReplicationMessages.ERR_ERROR_SEARCHING_RUV.get(search.getResultCode().getResultCodeName(), search.toString(), search.getErrorMessage(), this.baseDn.toString());
                ErrorLogger.logError(message);
                return null;
            }
            SearchResultEntry stateEntry = null;
            if (search.getResultCode() == ResultCode.SUCCESS && !(result = search.getSearchEntries()).isEmpty()) {
                stateEntry = result.getFirst();
            }
            return stateEntry;
        }
        catch (DirectoryException e) {
            return null;
        }
    }

    private SearchResultEntry searchConfigEntry() {
        try {
            LinkedList<SearchResultEntry> resultEntries;
            SearchFilter filter = SearchFilter.createFilterFromString("(&(objectclass=ds-cfg-replication-domain)(ds-cfg-base-dn=" + this.baseDn + "))");
            LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
            attributes.add(REPLICATION_STATE);
            InternalSearchOperation op = this.conn.processSearch(DN.decode("cn=config"), SearchScope.SUBORDINATE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 1, 0, false, filter, attributes);
            if (op.getResultCode() == ResultCode.SUCCESS && !(resultEntries = op.getSearchEntries()).isEmpty()) {
                return resultEntries.getFirst();
            }
            return null;
        }
        catch (DirectoryException e) {
            return null;
        }
    }

    private void updateStateFromEntry(SearchResultEntry resultEntry) {
        AttributeType synchronizationStateType = DirectoryServer.getAttributeType(REPLICATION_STATE);
        List<Attribute> attrs = resultEntry.getAttribute(synchronizationStateType);
        if (attrs != null) {
            Attribute attr = attrs.get(0);
            for (AttributeValue value : attr) {
                ChangeNumber changeNumber = new ChangeNumber(value.toString());
                this.update(changeNumber);
            }
        }
    }

    private ResultCode updateStateEntry() {
        SearchResultEntry configEntry;
        ResultCode result = this.runUpdateStateEntry(this.baseDn);
        if (result == ResultCode.NO_SUCH_OBJECT && (configEntry = this.searchConfigEntry()) != null) {
            DN configDN = configEntry.getDN();
            result = this.runUpdateStateEntry(configDN);
        }
        return result;
    }

    private ResultCode runUpdateStateEntry(DN serverStateEntryDN) {
        ArrayList<ByteString> values = this.state.toASN1ArrayList();
        LDAPAttribute attr = new LDAPAttribute(REPLICATION_STATE, values);
        LDAPModification mod = new LDAPModification(ModificationType.REPLACE, attr);
        ArrayList<RawModification> mods = new ArrayList<RawModification>(1);
        mods.add(mod);
        ModifyOperationBasis op = new ModifyOperationBasis((ClientConnection)this.conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), ByteString.valueOf(serverStateEntryDN.toString()), mods);
        op.setInternalOperation(true);
        op.setSynchronizationOperation(true);
        op.setDontSynchronize(true);
        op.run();
        if (op.getResultCode() != ResultCode.SUCCESS) {
            Message message = ReplicationMessages.DEBUG_ERROR_UPDATING_RUV.get(op.getResultCode().getResultCodeName().toString(), op.toString(), op.getErrorMessage().toString(), this.baseDn.toString());
            ErrorLogger.logError(message);
        }
        return op.getResultCode();
    }

    public void clearInMemory() {
        this.state.clear();
        this.state.setSaved(false);
    }

    public void clear() {
        this.clearInMemory();
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkAndUpdateServerState() {
        AttributeType histType = DirectoryServer.getAttributeType("ds-sync-hist");
        PersistentServerState persistentServerState = this;
        synchronized (persistentServerState) {
            InternalSearchOperation op;
            ChangeNumber serverStateMaxCn = this.state.getMaxChangeNumber(this.serverId);
            if (serverStateMaxCn == null) {
                return;
            }
            try {
                op = LDAPReplicationDomain.searchForChangedEntries(this.baseDn, serverStateMaxCn, null);
            }
            catch (Exception e) {
                return;
            }
            if (op.getResultCode() != ResultCode.SUCCESS) {
                Message message = ReplicationMessages.ERR_CANNOT_RECOVER_CHANGES.get(this.baseDn.toNormalizedString());
                ErrorLogger.logError(message);
            } else {
                ChangeNumber dbMaxCn = serverStateMaxCn;
                for (SearchResultEntry resEntry : op.getSearchEntries()) {
                    for (AttributeValue attrValue : resEntry.getAttribute(histType).get(0)) {
                        HistoricalAttributeValue histVal = new HistoricalAttributeValue(attrValue.toString());
                        ChangeNumber cn = histVal.getCn();
                        if (cn == null || cn.getServerId() != this.serverId || ChangeNumber.compare(dbMaxCn, cn) >= 0) continue;
                        dbMaxCn = cn;
                    }
                }
                if (ChangeNumber.compare(dbMaxCn, serverStateMaxCn) > 0) {
                    this.update(dbMaxCn);
                    Message message = ReplicationMessages.NOTE_SERVER_STATE_RECOVERY.get(this.baseDn.toNormalizedString(), dbMaxCn.toString());
                    ErrorLogger.logError(message);
                }
            }
        }
    }

    public ChangeNumber getMaxChangeNumber(int serverID) {
        return this.state.getMaxChangeNumber(serverID);
    }
}

