/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.plugin.LDAPReplicationDomain;
import org.opends.server.replication.plugin.UpdateToReplay;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.util.StaticUtils;

public class ReplayThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final BlockingQueue<UpdateToReplay> updateToReplayQueue;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private static int count = 0;

    public ReplayThread(BlockingQueue<UpdateToReplay> updateToReplayQueue) {
        super("Replica replay thread " + count++);
        this.updateToReplayQueue = updateToReplayQueue;
    }

    public void shutdown() {
        this.shutdown.set(true);
    }

    @Override
    public void run() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication Replay thread starting.");
        }
        while (!this.shutdown.get()) {
            try {
                UpdateToReplay updateToreplay;
                while (!this.shutdown.get() && (updateToreplay = this.updateToReplayQueue.poll(1L, TimeUnit.SECONDS)) != null) {
                    LDAPUpdateMsg updateMsg = updateToreplay.getUpdateMessage();
                    LDAPReplicationDomain domain = updateToreplay.getReplicationDomain();
                    domain.replay(updateMsg, this.shutdown);
                }
            }
            catch (Exception e) {
                Message message = ReplicationMessages.ERR_EXCEPTION_REPLAYING_REPLICATION_MESSAGE.get(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication Replay thread stopping.");
        }
    }
}

