/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.HeartbeatMsg;
import org.opends.server.replication.protocol.Session;
import org.opends.server.types.DebugLogLevel;

public class HeartbeatThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static volatile boolean heartbeatsDisabled = false;
    private final Session session;
    private final long heartbeatInterval;
    private volatile boolean shutdown = false;
    private final Object shutdownLock = new Object();

    public HeartbeatThread(String threadName, Session session, long heartbeatInterval) {
        super(threadName);
        this.session = session;
        this.heartbeatInterval = heartbeatInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Heartbeat thread is starting, interval is %d", this.heartbeatInterval);
            }
            HeartbeatMsg heartbeatMessage = new HeartbeatMsg();
            while (!this.shutdown) {
                long sleepTime;
                long now = System.currentTimeMillis();
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Heartbeat thread awoke at %d, last message was sent at %d", now, this.session.getLastPublishTime());
                }
                if (now > this.session.getLastPublishTime() + this.heartbeatInterval && !heartbeatsDisabled) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose("Heartbeat sent at %d", now);
                    }
                    this.session.publish(heartbeatMessage);
                }
                if ((sleepTime = this.session.getLastPublishTime() + this.heartbeatInterval - now) <= 0L) {
                    sleepTime = this.heartbeatInterval;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Heartbeat thread sleeping for %d", sleepTime);
                }
                Object object = this.shutdownLock;
                synchronized (object) {
                    if (!this.shutdown) {
                        try {
                            this.shutdownLock.wait(sleepTime);
                        }
                        catch (InterruptedException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            this.shutdown = true;
                        }
                    }
                }
            }
            return;
        }
        catch (IOException e) {
            if (!DebugLogger.debugEnabled()) return;
            TRACER.debugInfo("Heartbeat thread could not send a heartbeat.");
            return;
        }
        finally {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Heartbeat thread is exiting.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
            this.shutdownLock.notifyAll();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Going to notify Heartbeat thread.");
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning from Heartbeat shutdown.");
        }
    }

    public static void setHeartbeatsDisabled(boolean heartbeatsDisabled) {
        HeartbeatThread.heartbeatsDisabled = heartbeatsDisabled;
    }
}

