/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ModifyCommonMsg;
import org.opends.server.replication.protocol.ModifyDnContext;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.Operation;
import org.opends.server.types.RDN;
import org.opends.server.types.operation.PostOperationModifyDNOperation;

public class ModifyDNMsg
extends ModifyCommonMsg {
    private String newRDN;
    private String newSuperior;
    private boolean deleteOldRdn;
    private String newSuperiorEntryUUID;

    public ModifyDNMsg(PostOperationModifyDNOperation operation) {
        super((OperationContext)operation.getAttachment("replicationContext"), operation.getRawEntryDN().toString());
        this.encodedMods = this.encodeMods(operation.getModifications());
        ModifyDnContext ctx = (ModifyDnContext)operation.getAttachment("replicationContext");
        this.newSuperiorEntryUUID = ctx.getNewSuperiorEntryUUID();
        this.deleteOldRdn = operation.deleteOldRDN();
        this.newSuperior = operation.getRawNewSuperior() != null ? operation.getRawNewSuperior().toString() : null;
        this.newRDN = operation.getRawNewRDN().toString();
    }

    public ModifyDNMsg(String dn, ChangeNumber changeNumber, String entryUUID, String newSuperiorEntryUUID, boolean deleteOldRdn, String newSuperior, String newRDN) {
        super(new ModifyDnContext(changeNumber, entryUUID, newSuperiorEntryUUID), dn);
        this.newSuperiorEntryUUID = newSuperiorEntryUUID;
        this.deleteOldRdn = deleteOldRdn;
        this.newSuperior = newSuperior;
        this.newRDN = newRDN;
    }

    public ModifyDNMsg(String dn, ChangeNumber changeNumber, String entryUUID, String newSuperiorEntryUUID, boolean deleteOldRdn, String newSuperior, String newRDN, List<Modification> mods) {
        this(dn, changeNumber, entryUUID, newSuperiorEntryUUID, deleteOldRdn, newSuperior, newRDN);
        this.encodedMods = this.encodeMods(mods);
    }

    public ModifyDNMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        byte[] allowedPduTypes = new byte[]{25, 4};
        int pos = this.decodeHeader(allowedPduTypes, in);
        if (this.protocolVersion <= 3) {
            this.decodeBody_V123(in, pos);
        } else {
            this.decodeBody_V4(in, pos);
        }
        if (this.protocolVersion == ProtocolVersion.getCurrentVersion()) {
            this.bytes = in;
        }
    }

    @Override
    public Operation createOperation(InternalClientConnection connection, String newDn) throws LDAPException, ASN1Exception {
        ModifyDNOperationBasis moddn = new ModifyDNOperationBasis((ClientConnection)connection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, ByteString.valueOf(newDn), ByteString.valueOf(this.newRDN), this.deleteOldRdn, this.newSuperior == null ? null : ByteString.valueOf(this.newSuperior));
        for (Modification mod : this.decodeMods(this.encodedMods)) {
            moddn.addModification(mod);
        }
        ModifyDnContext ctx = new ModifyDnContext(this.getChangeNumber(), this.getEntryUUID(), this.newSuperiorEntryUUID);
        moddn.setAttachment("replicationContext", ctx);
        return moddn;
    }

    @Override
    public byte[] getBytes_V1() throws UnsupportedEncodingException {
        byte[] byteNewRdn = this.newRDN.getBytes("UTF-8");
        byte[] byteNewSuperior = null;
        byte[] byteNewSuperiorId = null;
        int bodyLength = byteNewRdn.length + 1 + 1;
        if (this.newSuperior != null) {
            byteNewSuperior = this.newSuperior.getBytes("UTF-8");
            bodyLength += byteNewSuperior.length + 1;
        } else {
            ++bodyLength;
        }
        if (this.newSuperiorEntryUUID != null) {
            byteNewSuperiorId = this.newSuperiorEntryUUID.getBytes("UTF-8");
            bodyLength += byteNewSuperiorId.length + 1;
        } else {
            ++bodyLength;
        }
        byte[] encodedMsg = this.encodeHeader_V1((byte)4, bodyLength);
        int pos = encodedMsg.length - bodyLength;
        pos = ModifyDNMsg.addByteArray(byteNewRdn, encodedMsg, pos);
        if (this.newSuperior != null) {
            pos = ModifyDNMsg.addByteArray(byteNewSuperior, encodedMsg, pos);
        } else {
            encodedMsg[pos++] = 0;
        }
        if (this.newSuperiorEntryUUID != null) {
            pos = ModifyDNMsg.addByteArray(byteNewSuperiorId, encodedMsg, pos);
        } else {
            encodedMsg[pos++] = 0;
        }
        encodedMsg[pos++] = this.deleteOldRdn ? (byte)1 : 0;
        return encodedMsg;
    }

    @Override
    public byte[] getBytes_V23() throws UnsupportedEncodingException {
        byte[] byteNewRdn = this.newRDN.getBytes("UTF-8");
        byte[] byteNewSuperior = null;
        byte[] byteNewSuperiorId = null;
        int length = byteNewRdn.length + 1 + 1;
        if (this.newSuperior != null) {
            byteNewSuperior = this.newSuperior.getBytes("UTF-8");
            length += byteNewSuperior.length + 1;
        } else {
            ++length;
        }
        if (this.newSuperiorEntryUUID != null) {
            byteNewSuperiorId = this.newSuperiorEntryUUID.getBytes("UTF-8");
            length += byteNewSuperiorId.length + 1;
        } else {
            ++length;
        }
        byte[] encodedMsg = this.encodeHeader((byte)25, length += this.encodedMods.length + 1, (short)3);
        int pos = encodedMsg.length - length;
        pos = ModifyDNMsg.addByteArray(byteNewRdn, encodedMsg, pos);
        if (this.newSuperior != null) {
            pos = ModifyDNMsg.addByteArray(byteNewSuperior, encodedMsg, pos);
        } else {
            encodedMsg[pos++] = 0;
        }
        if (this.newSuperiorEntryUUID != null) {
            pos = ModifyDNMsg.addByteArray(byteNewSuperiorId, encodedMsg, pos);
        } else {
            encodedMsg[pos++] = 0;
        }
        encodedMsg[pos++] = this.deleteOldRdn ? (byte)1 : 0;
        if (this.encodedMods.length > 0) {
            pos = encodedMsg.length - (this.encodedMods.length + 1);
            ModifyDNMsg.addByteArray(this.encodedMods, encodedMsg, pos);
        } else {
            encodedMsg[pos++] = 0;
        }
        return encodedMsg;
    }

    @Override
    public byte[] getBytes_V45(short reqProtocolVersion) throws UnsupportedEncodingException {
        byte[] byteNewSuperior = null;
        byte[] byteNewSuperiorId = null;
        byte[] byteNewRdn = this.newRDN.getBytes("UTF-8");
        int bodyLength = byteNewRdn.length + 1 + 1;
        if (this.newSuperior != null) {
            byteNewSuperior = this.newSuperior.getBytes("UTF-8");
            bodyLength += byteNewSuperior.length + 1;
        } else {
            ++bodyLength;
        }
        if (this.newSuperiorEntryUUID != null) {
            byteNewSuperiorId = this.newSuperiorEntryUUID.getBytes("UTF-8");
            bodyLength += byteNewSuperiorId.length + 1;
        } else {
            ++bodyLength;
        }
        byte[] byteModsLen = String.valueOf(this.encodedMods.length).getBytes("UTF-8");
        bodyLength += byteModsLen.length + 1;
        bodyLength += this.encodedMods.length + 1;
        byte[] byteEntryAttrLen = String.valueOf(this.encodedEclIncludes.length).getBytes("UTF-8");
        bodyLength += byteEntryAttrLen.length + 1;
        byte[] encodedMsg = this.encodeHeader((byte)25, bodyLength += this.encodedEclIncludes.length + 1, reqProtocolVersion);
        int pos = encodedMsg.length - bodyLength;
        pos = ModifyDNMsg.addByteArray(byteNewRdn, encodedMsg, pos);
        if (this.newSuperior != null) {
            pos = ModifyDNMsg.addByteArray(byteNewSuperior, encodedMsg, pos);
        } else {
            encodedMsg[pos++] = 0;
        }
        if (this.newSuperiorEntryUUID != null) {
            pos = ModifyDNMsg.addByteArray(byteNewSuperiorId, encodedMsg, pos);
        } else {
            encodedMsg[pos++] = 0;
        }
        encodedMsg[pos++] = this.deleteOldRdn ? (byte)1 : 0;
        pos = ModifyDNMsg.addByteArray(byteModsLen, encodedMsg, pos);
        pos = ModifyDNMsg.addByteArray(this.encodedMods, encodedMsg, pos);
        pos = ModifyDNMsg.addByteArray(byteEntryAttrLen, encodedMsg, pos);
        pos = ModifyDNMsg.addByteArray(this.encodedEclIncludes, encodedMsg, pos);
        return encodedMsg;
    }

    private void decodeBody_V123(byte[] in, int pos) throws DataFormatException, UnsupportedEncodingException {
        int length = ModifyDNMsg.getNextLength(in, pos);
        this.newRDN = new String(in, pos, length, "UTF-8");
        this.newSuperior = (length = ModifyDNMsg.getNextLength(in, pos += length + 1)) != 0 ? new String(in, pos, length, "UTF-8") : null;
        pos += length + 1;
        length = ModifyDNMsg.getNextLength(in, pos);
        this.newSuperiorEntryUUID = length != 0 ? new String(in, pos, length, "UTF-8") : null;
        this.deleteOldRdn = in[pos += length + 1] != 0;
        if (in[0] == 25 && (length = in.length - ++pos - 1) > 0) {
            this.encodedMods = new byte[length];
            try {
                System.arraycopy(in, pos, this.encodedMods, 0, length);
            }
            catch (IndexOutOfBoundsException e) {
                throw new DataFormatException(e.getMessage());
            }
            catch (ArrayStoreException e) {
                throw new DataFormatException(e.getMessage());
            }
            catch (NullPointerException e) {
                throw new DataFormatException(e.getMessage());
            }
        }
    }

    private void decodeBody_V4(byte[] in, int pos) throws DataFormatException, UnsupportedEncodingException {
        int length = ModifyDNMsg.getNextLength(in, pos);
        this.newRDN = new String(in, pos, length, "UTF-8");
        this.newSuperior = (length = ModifyDNMsg.getNextLength(in, pos += length + 1)) != 0 ? new String(in, pos, length, "UTF-8") : null;
        pos += length + 1;
        length = ModifyDNMsg.getNextLength(in, pos);
        this.newSuperiorEntryUUID = length != 0 ? new String(in, pos, length, "UTF-8") : null;
        this.deleteOldRdn = in[pos += length + 1] != 0;
        length = ModifyDNMsg.getNextLength(in, ++pos);
        int modsLen = Integer.valueOf(new String(in, pos, length, "UTF-8"));
        pos += length + 1;
        this.encodedMods = new byte[modsLen];
        try {
            System.arraycopy(in, pos, this.encodedMods, 0, modsLen);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
        length = ModifyDNMsg.getNextLength(in, pos += modsLen + 1);
        int eclAttrLen = Integer.valueOf(new String(in, pos, length, "UTF-8"));
        pos += length + 1;
        this.encodedEclIncludes = new byte[eclAttrLen];
        try {
            System.arraycopy(in, pos, this.encodedEclIncludes, 0, eclAttrLen);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public String toString() {
        if (this.protocolVersion == 1) {
            return "ModifyDNMsg content:  protocolVersion: " + this.protocolVersion + " dn: " + this.dn + " changeNumber: " + this.changeNumber + " uniqueId: " + this.entryUUID + " assuredFlag: " + this.assuredFlag + " newRDN: " + this.newRDN + " newSuperior: " + this.newSuperior + " deleteOldRdn: " + this.deleteOldRdn;
        }
        if (this.protocolVersion >= 2) {
            return "ModifyDNMsg content:  protocolVersion: " + this.protocolVersion + " dn: " + this.dn + " changeNumber: " + this.changeNumber + " uniqueId: " + this.entryUUID + " newRDN: " + this.newRDN + " newSuperior: " + this.newSuperior + " deleteOldRdn: " + this.deleteOldRdn + " assuredFlag: " + this.assuredFlag + " assuredMode: " + (Object)((Object)this.assuredMode) + " safeDataLevel: " + this.safeDataLevel;
        }
        return "!!! Unknown version: " + this.protocolVersion + "!!!";
    }

    public void setNewSuperior(String string) {
        this.newSuperior = string;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public String getNewSuperiorEntryUUID() {
        return this.newSuperiorEntryUUID;
    }

    public boolean deleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void setNewSuperiorEntryUUID(String newSup) {
        this.newSuperiorEntryUUID = newSup;
    }

    public void setDeleteOldRdn(boolean delete) {
        this.deleteOldRdn = delete;
    }

    public boolean getDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public String getNewRDN() {
        return this.newRDN;
    }

    public void setNewRDN(String newRDN) {
        this.newRDN = newRDN;
    }

    private DN computeNewDN() throws DirectoryException {
        if (this.newSuperior == null) {
            DN parentDn = DN.decode(this.getDn()).getParent();
            return parentDn.concat(RDN.decode(this.newRDN));
        }
        String newStringDN = this.newRDN + "," + this.newSuperior;
        return DN.decode(newStringDN);
    }

    public boolean newDNIsParent(DN targetDn) {
        try {
            DN newDN = this.computeNewDN();
            return newDN.isAncestorOf(targetDn);
        }
        catch (DirectoryException e) {
            return false;
        }
    }

    public boolean newDNIsEqual(DN targetDN) {
        try {
            DN newDN = this.computeNewDN();
            return newDN.equals(targetDN);
        }
        catch (DirectoryException e) {
            return false;
        }
    }

    public boolean newParentIsEqual(DN targetDN) {
        try {
            DN newSuperiorDN = DN.decode(this.newSuperior);
            return newSuperiorDN.equals(targetDN);
        }
        catch (DirectoryException e) {
            return false;
        }
    }

    @Override
    public int size() {
        return this.encodedMods.length + this.newRDN.length() + this.encodedEclIncludes.length + this.headerSize();
    }
}

