/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ReplicationMsg;

public class StartECLSessionMsg
extends ReplicationMsg {
    public static final short REQUEST_TYPE_FROM_COOKIE = 0;
    public static final short REQUEST_TYPE_FROM_DRAFT_CHANGE_NUMBER = 1;
    public static final short REQUEST_TYPE_EQUALS_REPL_CHANGE_NUMBER = 2;
    public static final short PERSISTENT = 0;
    public static final short NON_PERSISTENT = 1;
    public static final short PERSISTENT_CHANGES_ONLY = 2;
    private short eclRequestType;
    private String crossDomainServerState = "";
    private int firstDraftChangeNumber = -1;
    private int lastDraftChangeNumber = -1;
    private ChangeNumber changeNumber;
    private short isPersistent = 1;
    private String operationId = "";
    private ArrayList<String> excludedServiceIDs = new ArrayList();

    public StartECLSessionMsg(byte[] in) throws DataFormatException {
        try {
            String excludedDNsString;
            int pos = 0;
            if (in.length < 1 || in[pos++] != 31) {
                throw new DataFormatException("Input is not a valid " + this.getClass().getCanonicalName());
            }
            int length = StartECLSessionMsg.getNextLength(in, pos);
            this.eclRequestType = Short.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = StartECLSessionMsg.getNextLength(in, pos);
            this.firstDraftChangeNumber = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = StartECLSessionMsg.getNextLength(in, pos);
            this.lastDraftChangeNumber = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = StartECLSessionMsg.getNextLength(in, pos);
            String changenumberStr = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            this.changeNumber = new ChangeNumber(changenumberStr);
            length = StartECLSessionMsg.getNextLength(in, pos);
            this.isPersistent = Short.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = StartECLSessionMsg.getNextLength(in, pos);
            this.crossDomainServerState = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = StartECLSessionMsg.getNextLength(in, pos);
            this.operationId = new String(in, pos, length, "UTF-8");
            if ((excludedDNsString = new String(in, pos += length + 1, length = StartECLSessionMsg.getNextLength(in, pos), "UTF-8")).length() > 0) {
                String[] excludedDNsStr = excludedDNsString.split(";");
                Collections.addAll(this.excludedServiceIDs, excludedDNsStr);
            }
            pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
        catch (IllegalArgumentException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public StartECLSessionMsg() {
        this.eclRequestType = 0;
        this.crossDomainServerState = "";
        this.firstDraftChangeNumber = -1;
        this.lastDraftChangeNumber = -1;
        this.changeNumber = new ChangeNumber(0L, 0, 0);
        this.isPersistent = 1;
        this.operationId = "-1";
        this.excludedServiceIDs = new ArrayList();
    }

    @Override
    public byte[] getBytes(short protocolVersion) {
        String excludedSIDsString = "";
        for (String excludedServiceID : this.excludedServiceIDs) {
            excludedSIDsString = excludedSIDsString.concat(excludedServiceID + ";");
        }
        try {
            byte[] byteMode = Short.toString(this.eclRequestType).getBytes("UTF-8");
            byte[] byteSequenceNumber = String.valueOf(this.firstDraftChangeNumber).getBytes("UTF-8");
            byte[] byteStopSequenceNumber = String.valueOf(this.lastDraftChangeNumber).getBytes("UTF-8");
            byte[] byteChangeNumber = this.changeNumber.toString().getBytes("UTF-8");
            byte[] bytePsearch = Short.toString(this.isPersistent).getBytes();
            byte[] byteGeneralizedState = String.valueOf(this.crossDomainServerState).getBytes("UTF-8");
            byte[] byteOperationId = String.valueOf(this.operationId).getBytes("UTF-8");
            byte[] byteExcludedDNs = String.valueOf(excludedSIDsString).getBytes("UTF-8");
            int length = byteMode.length + 1 + byteSequenceNumber.length + 1 + byteStopSequenceNumber.length + 1 + byteChangeNumber.length + 1 + bytePsearch.length + 1 + byteGeneralizedState.length + 1 + byteOperationId.length + 1 + byteExcludedDNs.length + 1 + 1;
            byte[] resultByteArray = new byte[length];
            int pos = 0;
            resultByteArray[pos++] = 31;
            pos = StartECLSessionMsg.addByteArray(byteMode, resultByteArray, pos);
            pos = StartECLSessionMsg.addByteArray(byteSequenceNumber, resultByteArray, pos);
            pos = StartECLSessionMsg.addByteArray(byteStopSequenceNumber, resultByteArray, pos);
            pos = StartECLSessionMsg.addByteArray(byteChangeNumber, resultByteArray, pos);
            pos = StartECLSessionMsg.addByteArray(bytePsearch, resultByteArray, pos);
            pos = StartECLSessionMsg.addByteArray(byteGeneralizedState, resultByteArray, pos);
            pos = StartECLSessionMsg.addByteArray(byteOperationId, resultByteArray, pos);
            pos = StartECLSessionMsg.addByteArray(byteExcludedDNs, resultByteArray, pos);
            return resultByteArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + " [" + " requestType=" + this.eclRequestType + " persistentSearch=" + this.isPersistent + " changeNumber=" + this.changeNumber + " firstDraftChangeNumber=" + this.firstDraftChangeNumber + " lastDraftChangeNumber=" + this.lastDraftChangeNumber + " generalizedState=" + this.crossDomainServerState + " operationId=" + this.operationId + " excludedDNs=" + this.excludedServiceIDs + "]";
    }

    public int getFirstDraftChangeNumber() {
        return this.firstDraftChangeNumber;
    }

    public int getLastDraftChangeNumber() {
        return this.lastDraftChangeNumber;
    }

    public void setFirstDraftChangeNumber(int firstDraftChangeNumber) {
        this.firstDraftChangeNumber = firstDraftChangeNumber;
    }

    public void setLastDraftChangeNumber(int lastDraftChangeNumber) {
        this.lastDraftChangeNumber = lastDraftChangeNumber;
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public void setChangeNumber(ChangeNumber changeNumber) {
        this.changeNumber = changeNumber;
    }

    public short getECLRequestType() {
        return this.eclRequestType;
    }

    public void setECLRequestType(short eclRequestType) {
        this.eclRequestType = eclRequestType;
    }

    public short isPersistent() {
        return this.isPersistent;
    }

    public void setPersistent(short isPersistent) {
        this.isPersistent = isPersistent;
    }

    public String getCrossDomainServerState() {
        return this.crossDomainServerState;
    }

    public void setCrossDomainServerState(String crossDomainServerState) {
        this.crossDomainServerState = crossDomainServerState;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public ArrayList<String> getExcludedServiceIDs() {
        return this.excludedServiceIDs;
    }

    public void setExcludedDNs(ArrayList<String> excludedServiceIDs) {
        this.excludedServiceIDs = excludedServiceIDs;
    }
}

