/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ReplicationMsg;

public class TopologyMsg
extends ReplicationMsg {
    private final List<DSInfo> dsList;
    private final List<RSInfo> rsList;

    public TopologyMsg(byte[] in, short version) throws DataFormatException {
        try {
            byte nRsInfo;
            long generationId;
            byte nDsInfo;
            if (in.length < 1 || in[0] != 26) {
                throw new DataFormatException("Input is not a valid " + this.getClass().getCanonicalName());
            }
            int pos = 1;
            ArrayList<DSInfo> dsList = new ArrayList<DSInfo>(Math.max(0, nDsInfo));
            for (nDsInfo = in[pos++]; nDsInfo > 0 && pos < in.length; nDsInfo = (byte)(nDsInfo - 1)) {
                byte nRead;
                String dsUrl;
                int length = TopologyMsg.getNextLength(in, pos);
                String serverIdString = new String(in, pos, length, "UTF-8");
                int dsId = Integer.valueOf(serverIdString);
                pos += length + 1;
                if (version >= 6) {
                    length = TopologyMsg.getNextLength(in, pos);
                    dsUrl = new String(in, pos, length, "UTF-8");
                    pos += length + 1;
                } else {
                    dsUrl = "";
                }
                length = TopologyMsg.getNextLength(in, pos);
                serverIdString = new String(in, pos, length, "UTF-8");
                int rsId = Integer.valueOf(serverIdString);
                pos += length + 1;
                length = TopologyMsg.getNextLength(in, pos);
                generationId = Long.valueOf(new String(in, pos, length, "UTF-8"));
                pos += length + 1;
                ServerStatus status = ServerStatus.valueOf(in[pos++]);
                boolean assuredFlag = in[pos++] == 1;
                AssuredMode assuredMode = AssuredMode.valueOf(in[pos++]);
                byte safeDataLevel = in[pos++];
                byte groupId = in[pos++];
                ArrayList<String> refUrls = new ArrayList<String>();
                byte nUrls = in[pos++];
                for (nRead = 0; nRead != nUrls && pos < in.length; pos += length + 1, nRead = (byte)(nRead + 1)) {
                    length = TopologyMsg.getNextLength(in, pos);
                    String url = new String(in, pos, length, "UTF-8");
                    refUrls.add(url);
                }
                HashSet<String> attrs = new HashSet<String>();
                HashSet<String> delattrs = new HashSet<String>();
                short protocolVersion = -1;
                if (version >= 4) {
                    String attr;
                    byte nAttrs = in[pos++];
                    for (nRead = 0; nRead != nAttrs && pos < in.length; pos += length + 1, nRead = (byte)(nRead + 1)) {
                        length = TopologyMsg.getNextLength(in, pos);
                        attr = new String(in, pos, length, "UTF-8");
                        attrs.add(attr);
                    }
                    if (version >= 5) {
                        nAttrs = in[pos++];
                        for (nRead = 0; nRead != nAttrs && pos < in.length; pos += length + 1, nRead = (byte)(nRead + 1)) {
                            length = TopologyMsg.getNextLength(in, pos);
                            attr = new String(in, pos, length, "UTF-8");
                            delattrs.add(attr);
                        }
                    } else {
                        delattrs.addAll(attrs);
                    }
                    protocolVersion = in[pos++];
                }
                DSInfo dsInfo = new DSInfo(dsId, dsUrl, rsId, generationId, status, assuredFlag, assuredMode, safeDataLevel, groupId, refUrls, attrs, delattrs, protocolVersion);
                dsList.add(dsInfo);
            }
            ArrayList<RSInfo> rsList = new ArrayList<RSInfo>(Math.max(0, nRsInfo));
            for (nRsInfo = in[pos++]; nRsInfo > 0 && pos < in.length; nRsInfo = (byte)(nRsInfo - 1)) {
                int length = TopologyMsg.getNextLength(in, pos);
                String serverIdString = new String(in, pos, length, "UTF-8");
                int id = Integer.valueOf(serverIdString);
                pos += length + 1;
                length = TopologyMsg.getNextLength(in, pos);
                generationId = Long.valueOf(new String(in, pos, length, "UTF-8"));
                pos += length + 1;
                byte groupId = in[pos++];
                int weight = 1;
                String serverUrl = null;
                if (version >= 4) {
                    length = TopologyMsg.getNextLength(in, pos);
                    serverUrl = new String(in, pos, length, "UTF-8");
                    pos += length + 1;
                    length = TopologyMsg.getNextLength(in, pos);
                    weight = Integer.valueOf(new String(in, pos, length, "UTF-8"));
                    pos += length + 1;
                }
                RSInfo rsInfo = new RSInfo(id, serverUrl, generationId, groupId, weight);
                rsList.add(rsInfo);
            }
            this.dsList = Collections.unmodifiableList(dsList);
            this.rsList = Collections.unmodifiableList(rsList);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public TopologyMsg(List<DSInfo> dsList, List<RSInfo> rsList) {
        this.dsList = dsList == null || dsList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<DSInfo>(dsList));
        this.rsList = rsList == null || rsList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<RSInfo>(rsList));
    }

    @Override
    public byte[] getBytes(short version) throws UnsupportedEncodingException {
        try {
            byte[] byteServerId;
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            oStream.write(26);
            oStream.write((byte)this.dsList.size());
            for (DSInfo dsInfo : this.dsList) {
                byteServerId = String.valueOf(dsInfo.getDsId()).getBytes("UTF-8");
                oStream.write(byteServerId);
                oStream.write(0);
                if (version >= 6) {
                    oStream.write(dsInfo.getDsUrl().getBytes("UTF-8"));
                    oStream.write(0);
                }
                byteServerId = String.valueOf(dsInfo.getRsId()).getBytes("UTF-8");
                oStream.write(byteServerId);
                oStream.write(0);
                oStream.write(String.valueOf(dsInfo.getGenerationId()).getBytes("UTF-8"));
                oStream.write(0);
                oStream.write(dsInfo.getStatus().getValue());
                oStream.write(dsInfo.isAssured() ? 1 : 0);
                oStream.write(dsInfo.getAssuredMode().getValue());
                oStream.write(dsInfo.getSafeDataLevel());
                oStream.write(dsInfo.getGroupId());
                List<String> refUrls = dsInfo.getRefUrls();
                oStream.write(refUrls.size());
                for (String url : refUrls) {
                    oStream.write(url.getBytes("UTF-8"));
                    oStream.write(0);
                }
                if (version < 4) continue;
                Set<String> attrs = dsInfo.getEclIncludes();
                oStream.write(attrs.size());
                for (String attr : attrs) {
                    oStream.write(attr.getBytes("UTF-8"));
                    oStream.write(0);
                }
                if (version >= 5) {
                    Set<String> delattrs = dsInfo.getEclIncludesForDeletes();
                    oStream.write(delattrs.size());
                    for (String attr : delattrs) {
                        oStream.write(attr.getBytes("UTF-8"));
                        oStream.write(0);
                    }
                }
                oStream.write(dsInfo.getProtocolVersion());
            }
            oStream.write((byte)this.rsList.size());
            for (RSInfo rsInfo : this.rsList) {
                byteServerId = String.valueOf(rsInfo.getId()).getBytes("UTF-8");
                oStream.write(byteServerId);
                oStream.write(0);
                oStream.write(String.valueOf(rsInfo.getGenerationId()).getBytes("UTF-8"));
                oStream.write(0);
                oStream.write(rsInfo.getGroupId());
                if (version < 4) continue;
                oStream.write(rsInfo.getServerUrl().getBytes("UTF-8"));
                oStream.write(0);
                oStream.write(String.valueOf(rsInfo.getWeight()).getBytes("UTF-8"));
                oStream.write(0);
            }
            return oStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String dsStr = "";
        for (DSInfo dsInfo : this.dsList) {
            dsStr = dsStr + dsInfo.toString() + "\n----------------------------\n";
        }
        String rsStr = "";
        for (RSInfo rsInfo : this.rsList) {
            rsStr = rsStr + rsInfo.toString() + "\n----------------------------\n";
        }
        return "TopologyMsg content: \n----------------------------\nCONNECTED DS SERVERS:\n--------------------\n" + dsStr + "CONNECTED RS SERVERS:" + "\n--------------------\n" + rsStr + (rsStr.equals("") ? "----------------------------\n" : "");
    }

    public List<DSInfo> getDsList() {
        return this.dsList;
    }

    public List<RSInfo> getRsList() {
        return this.rsList;
    }
}

