/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.server.DraftCNData;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationDraftCNKey;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

public class DraftCNDB {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Database db = null;
    private ReplicationDbEnv dbenv = null;
    private ReplicationServer replicationServer;
    private ReentrantReadWriteLock dbCloseLock;

    public DraftCNDB(ReplicationServer replicationServer, ReplicationDbEnv dbenv) throws DatabaseException {
        this.dbenv = dbenv;
        this.replicationServer = replicationServer;
        this.db = dbenv.getOrCreateDraftCNDb();
        this.dbCloseLock = new ReentrantReadWriteLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(int draftCN, String value, String domainBaseDN, ChangeNumber changeNumber) {
        try {
            ReplicationDraftCNKey key = new ReplicationDraftCNKey(draftCN);
            DraftCNData data = new DraftCNData(value, domainBaseDN, changeNumber);
            Transaction txn = null;
            this.dbCloseLock.readLock().lock();
            try {
                if (this.isDBClosed()) {
                    return;
                }
                txn = this.dbenv.beginTransaction();
                this.db.put(txn, (DatabaseEntry)key, (DatabaseEntry)data);
                txn.commit(Durability.COMMIT_WRITE_NO_SYNC);
            }
            finally {
                if (txn != null) {
                    try {
                        txn.abort();
                    }
                    catch (Exception exception) {}
                }
                this.dbCloseLock.readLock().unlock();
            }
        }
        catch (DatabaseException e) {
            this.replicationServer.handleUnexpectedDatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.dbCloseLock.writeLock().lock();
            try {
                this.db.close();
                this.db = null;
            }
            finally {
                this.dbCloseLock.writeLock().unlock();
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.NOTE_EXCEPTION_CLOSING_DATABASE.get(this.toString()));
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
        }
    }

    public DraftCNDBCursor openReadCursor(int draftCN) throws DatabaseException, Exception {
        return new DraftCNDBCursor(draftCN);
    }

    public DraftCNDBCursor openDeleteCursor() throws DatabaseException, Exception {
        return new DraftCNDBCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLockedCursor(Cursor cursor) {
        try {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.dbCloseLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readFirstDraftCN() {
        try {
            this.dbCloseLock.readLock().lock();
            Cursor cursor = null;
            try {
                DatabaseEntry entry;
                DatabaseEntry key;
                if (this.isDBClosed()) {
                    int n = 0;
                    this.closeLockedCursor(cursor);
                    return n;
                }
                cursor = this.db.openCursor(null, null);
                OperationStatus status = cursor.getFirst(key = new DatabaseEntry(), entry = new DatabaseEntry(), LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) {
                    int n = 0;
                    this.closeLockedCursor(cursor);
                    return n;
                }
                int n = new Integer(StaticUtils.decodeUTF8(key.getData()));
                this.closeLockedCursor(cursor);
                return n;
            }
            catch (Throwable throwable) {
                this.closeLockedCursor(cursor);
                throw throwable;
            }
        }
        catch (DatabaseException e) {
            this.replicationServer.handleUnexpectedDatabaseException(e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        this.dbCloseLock.readLock().lock();
        try {
            if (this.isDBClosed()) {
                long l = 0L;
                return l;
            }
            long l = this.db.count();
            return l;
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
        }
        finally {
            this.dbCloseLock.readLock().unlock();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readLastDraftCN() {
        try {
            this.dbCloseLock.readLock().lock();
            Cursor cursor = null;
            try {
                DatabaseEntry entry;
                DatabaseEntry key;
                if (this.isDBClosed()) {
                    int n = 0;
                    this.closeLockedCursor(cursor);
                    return n;
                }
                cursor = this.db.openCursor(null, null);
                OperationStatus status = cursor.getLast(key = new DatabaseEntry(), entry = new DatabaseEntry(), LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) {
                    int n = 0;
                    this.closeLockedCursor(cursor);
                    return n;
                }
                int n = new Integer(StaticUtils.decodeUTF8(key.getData()));
                this.closeLockedCursor(cursor);
                return n;
            }
            catch (Throwable throwable) {
                this.closeLockedCursor(cursor);
                throw throwable;
            }
        }
        catch (DatabaseException e) {
            this.replicationServer.handleUnexpectedDatabaseException(e);
            return 0;
        }
    }

    public String toString() {
        return "DraftCNDB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception, DatabaseException {
        this.dbCloseLock.writeLock().lock();
        try {
            if (this.isDBClosed()) {
                return;
            }
            String dbName = this.db.getDatabaseName();
            this.db.close();
            this.db = null;
            this.dbenv.clearDb(dbName);
            this.db = this.dbenv.getOrCreateDraftCNDb();
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_ERROR_CLEARING_DB.get(this.toString(), e.getMessage() + " " + StaticUtils.stackTraceToSingleLineString(e)));
            ErrorLogger.logError(mb.toMessage());
        }
        finally {
            this.dbCloseLock.writeLock().unlock();
        }
    }

    private boolean isDBClosed() {
        return this.db == null;
    }

    public class DraftCNDBCursor {
        private final Cursor cursor;
        private final Transaction txn;
        private final DatabaseEntry key;
        private final DatabaseEntry entry;
        private DraftCNData seqnumData = null;
        private boolean isClosed = false;

        private DraftCNDBCursor(int startingDraftCN) throws Exception {
            Transaction localTxn = null;
            Cursor localCursor = null;
            this.key = new ReplicationDraftCNKey(startingDraftCN);
            this.entry = new DatabaseEntry();
            DraftCNDB.this.dbCloseLock.readLock().lock();
            try {
                if (DraftCNDB.this.isDBClosed()) {
                    this.isClosed = true;
                    this.txn = null;
                    this.cursor = null;
                    return;
                }
                localCursor = DraftCNDB.this.db.openCursor(localTxn, null);
                if (startingDraftCN >= 0) {
                    if (localCursor.getSearchKey(this.key, this.entry, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                        if (localCursor.getSearchKeyRange(this.key, this.entry, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            throw new Exception("ChangeLog Draft Change Number " + startingDraftCN + " is not available");
                        }
                        if (localCursor.getPrev(this.key, this.entry, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            localCursor.close();
                            localCursor = DraftCNDB.this.db.openCursor(localTxn, null);
                        } else {
                            this.seqnumData = new DraftCNData(this.entry.getData());
                        }
                    } else {
                        this.seqnumData = new DraftCNData(this.entry.getData());
                    }
                }
                this.txn = localTxn;
                this.cursor = localCursor;
            }
            catch (Exception e) {
                DraftCNDB.this.closeLockedCursor(localCursor);
                throw e;
            }
        }

        private DraftCNDBCursor() throws Exception {
            Transaction localTxn = null;
            Cursor localCursor = null;
            this.key = new DatabaseEntry();
            this.entry = new DatabaseEntry();
            DraftCNDB.this.dbCloseLock.readLock().lock();
            try {
                if (DraftCNDB.this.isDBClosed()) {
                    this.isClosed = true;
                    this.txn = null;
                    this.cursor = null;
                    return;
                }
                localTxn = DraftCNDB.this.dbenv.beginTransaction();
                localCursor = DraftCNDB.this.db.openCursor(localTxn, null);
                this.txn = localTxn;
                this.cursor = localCursor;
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                try {
                    DraftCNDB.this.closeLockedCursor(localCursor);
                }
                catch (DatabaseException ignored) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ignored);
                }
                if (localTxn != null) {
                    try {
                        localTxn.abort();
                    }
                    catch (DatabaseException ignored) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ignored);
                    }
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            DraftCNDBCursor draftCNDBCursor = this;
            synchronized (draftCNDBCursor) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            DraftCNDB.this.closeLockedCursor(this.cursor);
            if (this.txn != null) {
                try {
                    this.txn.commit();
                }
                catch (DatabaseException e) {
                    DraftCNDB.this.replicationServer.handleUnexpectedDatabaseException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            DraftCNDBCursor draftCNDBCursor = this;
            synchronized (draftCNDBCursor) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            DraftCNDB.this.closeLockedCursor(this.cursor);
            if (this.txn != null) {
                try {
                    this.txn.abort();
                }
                catch (DatabaseException e) {
                    DraftCNDB.this.replicationServer.handleUnexpectedDatabaseException(e);
                }
            }
        }

        public String currentValue() {
            if (this.isClosed) {
                return null;
            }
            try {
                if (this.seqnumData != null) {
                    return this.seqnumData.getValue();
                }
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return null;
        }

        public String currentServiceID() {
            if (this.isClosed) {
                return null;
            }
            try {
                if (this.seqnumData != null) {
                    return this.seqnumData.getServiceID();
                }
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return null;
        }

        public int currentKey() {
            if (this.isClosed) {
                return -1;
            }
            try {
                String str = StaticUtils.decodeUTF8(this.key.getData());
                return Integer.valueOf(str);
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                return -1;
            }
        }

        public ChangeNumber currentChangeNumber() {
            if (this.isClosed) {
                return null;
            }
            try {
                if (this.seqnumData != null) {
                    return this.seqnumData.getChangeNumber();
                }
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return null;
        }

        public boolean next() throws DatabaseException {
            if (this.isClosed) {
                return false;
            }
            OperationStatus status = this.cursor.getNext(this.key, this.entry, LockMode.DEFAULT);
            if (status != OperationStatus.SUCCESS) {
                this.seqnumData = null;
                return false;
            }
            try {
                this.seqnumData = new DraftCNData(this.entry.getData());
            }
            catch (Exception e) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return true;
        }

        public void delete() throws DatabaseException {
            if (this.isClosed) {
                throw new IllegalStateException("DraftCNDB already closed");
            }
            this.cursor.delete();
        }

        public DatabaseEntry getKey() {
            if (this.isClosed) {
                return null;
            }
            return this.key;
        }
    }
}

