/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.MultiDomainServerState;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.server.DraftCNDB;
import org.opends.server.replication.server.DraftCNDbIterator;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class DraftCNDbHandler
implements Runnable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    static int NO_KEY = 0;
    private DraftCNDB db;
    private int firstkey = NO_KEY;
    private int lastkey = NO_KEY;
    private DbMonitorProvider dbMonitor = new DbMonitorProvider();
    private boolean shutdown = false;
    private boolean trimDone = false;
    private DirectoryThread thread;
    private long trimAge;
    private ReplicationServer replicationServer;
    private ReentrantLock lock = new ReentrantLock();

    public DraftCNDbHandler(ReplicationServer replicationServer, ReplicationDbEnv dbenv) throws DatabaseException {
        this.replicationServer = replicationServer;
        this.trimAge = replicationServer.getTrimAge();
        this.db = new DraftCNDB(replicationServer, dbenv);
        this.firstkey = this.db.readFirstDraftCN();
        this.lastkey = this.db.readLastDraftCN();
        this.thread = new DirectoryThread(this, "Replication DraftCN db ");
        this.thread.start();
        DirectoryServer.deregisterMonitorProvider(this.dbMonitor);
        DirectoryServer.registerMonitorProvider(this.dbMonitor);
    }

    public synchronized void add(int key, String value, String serviceID, ChangeNumber cn) {
        this.db.addEntry(key, value, serviceID, cn);
        this.lastkey = key;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In DraftCNDbhandler.add, added:  key=" + key + " value=" + value + " serviceID=" + serviceID + " cn=" + cn);
        }
    }

    public int getFirstKey() {
        return this.db.readFirstDraftCN();
    }

    public int getLastKey() {
        return this.db.readLastDraftCN();
    }

    public long count() {
        return this.db.count();
    }

    public DraftCNDB.DraftCNDBCursor getReadCursor(int key) {
        try {
            return this.db.openReadCursor(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void releaseReadCursor(DraftCNDB.DraftCNDBCursor cursor) {
        try {
            cursor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DraftCNDbIterator generateIterator(int startDraftCN) throws DatabaseException, Exception {
        return new DraftCNDbIterator(this.db, startDraftCN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        DraftCNDbHandler draftCNDbHandler = this;
        synchronized (draftCNDbHandler) {
            this.notifyAll();
        }
        draftCNDbHandler = this;
        synchronized (draftCNDbHandler) {
            while (!this.trimDone) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
        }
        this.db.shutdown();
        DirectoryServer.deregisterMonitorProvider(this.dbMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DraftCNDbHandler draftCNDbHandler;
        while (!this.shutdown) {
            try {
                this.trim();
                draftCNDbHandler = this;
                synchronized (draftCNDbHandler) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (Exception end) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_EXCEPTION_CHANGELOG_TRIM_FLUSH.get());
                mb.append(StaticUtils.stackTraceToSingleLineString(end));
                ErrorLogger.logError(mb.toMessage());
                if (this.replicationServer == null) break;
                this.replicationServer.shutdown();
                break;
            }
        }
        draftCNDbHandler = this;
        synchronized (draftCNDbHandler) {
            this.trimDone = true;
            this.notifyAll();
        }
    }

    public void trim() throws DatabaseException, Exception {
        if (this.trimAge == 0L) {
            return;
        }
        this.clear(null);
    }

    public void clear(String baseDNToClear) throws DatabaseException, Exception {
        if (this.count() == 0L) {
            return;
        }
        ChangeNumber crossDomainEligibleCN = this.replicationServer.getEligibleCN();
        for (int i = 0; i < 100; ++i) {
            DraftCNDB.DraftCNDBCursor cursor = this.db.openDeleteCursor();
            try {
                for (int j = 0; j < 50; ++j) {
                    ServerState cnVector;
                    int currentKey;
                    ServerState startState;
                    ChangeNumber cn;
                    block15: {
                        if (!cursor.next()) {
                            cursor.close();
                            return;
                        }
                        int draftCN = cursor.currentKey();
                        if (draftCN != this.firstkey) {
                            this.firstkey = draftCN;
                        }
                        if (draftCN == this.lastkey) {
                            cursor.close();
                            return;
                        }
                        cn = cursor.currentChangeNumber();
                        String baseDN = cursor.currentServiceID();
                        if (baseDNToClear != null && baseDNToClear.equalsIgnoreCase(baseDN)) {
                            cursor.delete();
                            continue;
                        }
                        ReplicationServerDomain domain = this.replicationServer.getReplicationServerDomain(baseDN, false);
                        if (domain == null) {
                            cursor.delete();
                            continue;
                        }
                        startState = domain.getStartState();
                        domain.getEligibleState(crossDomainEligibleCN);
                        ChangeNumber fcn = startState.getMaxChangeNumber(cn.getServerId());
                        currentKey = cursor.currentKey();
                        if (cn.older(fcn).booleanValue()) {
                            cursor.delete();
                            continue;
                        }
                        try {
                            Map<String, ServerState> cnStartStates = MultiDomainServerState.splitGenStateToServerStates(cursor.currentValue());
                            cnVector = cnStartStates.get(baseDN);
                            if (!DebugLogger.debugEnabled()) break block15;
                            TRACER.debugInfo("DraftCNDBHandler:clear() - ChangeVector:" + cnVector.toString() + " -- StartState:" + startState.toString());
                        }
                        catch (Exception e) {
                            assert (false);
                            cursor.delete();
                            continue;
                        }
                    }
                    if (cnVector == null || cnVector.getMaxChangeNumber(cn.getServerId()) != null && !cnVector.cover(startState)) {
                        cursor.delete();
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugInfo("DraftCNDBHandler:clear() - deleted " + cn.toString() + "Not covering startState");
                        continue;
                    }
                    this.firstkey = currentKey;
                    cursor.close();
                    return;
                }
                cursor.close();
                continue;
            }
            catch (Exception e) {
                cursor.abort();
                this.shutdown = true;
                throw e;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.firstkey + " " + this.lastkey;
    }

    public void setPurgeDelay(long delay) {
        this.trimAge = delay;
    }

    public void clear() throws DatabaseException, Exception {
        this.db.clear();
        this.firstkey = this.db.readFirstDraftCN();
        this.lastkey = this.db.readLastDraftCN();
    }

    public boolean hasLock() {
        return this.lock.getHoldCount() > 0;
    }

    public void lock() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    public void release() {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(int key) {
        String value = null;
        DraftCNDB.DraftCNDBCursor draftCNDBCursor = null;
        try {
            draftCNDBCursor = this.db.openReadCursor(key);
            value = draftCNDBCursor.currentValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In DraftCNDbHandler.getValue, read:  key=" + key + " value returned is null" + " first=" + this.db.readFirstDraftCN() + " last=" + this.db.readLastDraftCN() + " count=" + this.db.count() + " exception" + e + " " + e.getMessage());
            }
            String string = null;
            return string;
        }
        finally {
            if (draftCNDBCursor != null) {
                draftCNDBCursor.close();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeNumber getChangeNumber(int key) {
        ChangeNumber cn = null;
        DraftCNDB.DraftCNDBCursor draftCNDBCursor = null;
        try {
            draftCNDBCursor = this.db.openReadCursor(key);
            cn = draftCNDBCursor.currentChangeNumber();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In DraftCNDbHandler.getChangeNumber, read:  key=" + key + " changeNumber returned is null" + " first=" + this.db.readFirstDraftCN() + " last=" + this.db.readLastDraftCN() + " count=" + this.db.count() + " exception" + e + " " + e.getMessage());
            }
            ChangeNumber changeNumber = null;
            return changeNumber;
        }
        finally {
            if (draftCNDBCursor != null) {
                draftCNDBCursor.close();
            }
        }
        return cn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceID(int key) {
        String sid = null;
        DraftCNDB.DraftCNDBCursor draftCNDBCursor = null;
        try {
            draftCNDBCursor = this.db.openReadCursor(key);
            sid = draftCNDBCursor.currentServiceID();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In DraftCNDbHandler.getServiceID, read:  key=" + key + " serviceID returned is null" + " first=" + this.db.readFirstDraftCN() + " last=" + this.db.readLastDraftCN() + " count=" + this.db.count() + " exception" + e + " " + e.getMessage());
            }
            String string = null;
            return string;
        }
        finally {
            if (draftCNDBCursor != null) {
                draftCNDBCursor.close();
            }
        }
        return sid;
    }

    private class DbMonitorProvider
    extends MonitorProvider<MonitorProviderCfg> {
        private DbMonitorProvider() {
        }

        public ArrayList<Attribute> getMonitorData() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(Attributes.create("first-draft-changenumber", Integer.toString(DraftCNDbHandler.this.db.readFirstDraftCN())));
            attributes.add(Attributes.create("last-draft-changenumber", Integer.toString(DraftCNDbHandler.this.db.readLastDraftCN())));
            attributes.add(Attributes.create("count", Long.toString(DraftCNDbHandler.this.count())));
            return attributes;
        }

        @Override
        public String getMonitorInstanceName() {
            return "Draft Changelog";
        }

        @Override
        public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        }
    }
}

