/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.zip.DataFormatException;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.MultiDomainServerState;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.ECLUpdateMsg;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.replication.protocol.NotSupportedOldVersionPDUException;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerStartDSMsg;
import org.opends.server.replication.protocol.ReplServerStartMsg;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ServerStartECLMsg;
import org.opends.server.replication.protocol.Session;
import org.opends.server.replication.protocol.StartECLSessionMsg;
import org.opends.server.replication.protocol.StartMsg;
import org.opends.server.replication.protocol.StopMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.DraftCNDbHandler;
import org.opends.server.replication.server.DraftCNDbIterator;
import org.opends.server.replication.server.ECLServerWriter;
import org.opends.server.replication.server.MessageHandler;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.replication.server.ServerReader;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public final class ECLServerHandler
extends ServerHandler {
    String operationId;
    private DraftCNDbIterator draftCNDbIter = null;
    boolean draftCompat = false;
    public int lastDraftCN = 0;
    public boolean isEndOfDraftCNReached = false;
    public short isPersistent;
    public int searchPhase = INIT_PHASE;
    public String startCookie;
    public MultiDomainServerState previousCookie = new MultiDomainServerState();
    public ArrayList<String> excludedServiceIDs = new ArrayList();
    public ChangeNumber eligibleCN = null;
    DomainContext[] domainCtxts = new DomainContext[0];
    static int UNDEFINED_PHASE = 0;
    static int INIT_PHASE = 1;
    static int PERSISTENT_PHASE = 2;

    public String dumpState() {
        return this.getClass().getCanonicalName() + "[" + "[draftCompat=" + this.draftCompat + "] [persistent=" + this.isPersistent + "] [lastDraftCN=" + this.lastDraftCN + "] [isEndOfDraftCNReached=" + this.isEndOfDraftCNReached + "] [searchPhase=" + this.searchPhase + "] [startCookie=" + this.startCookie + "] [previousCookie=" + this.previousCookie + "]]";
    }

    private String clDomCtxtsToString(String msg) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(msg);
        buffer.append("\n");
        for (DomainContext domainCtxt : this.domainCtxts) {
            domainCtxt.toString(buffer);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public boolean processStartFromRemote(ServerStartECLMsg inECLStartMsg) throws DirectoryException {
        try {
            this.session.setProtocolVersion(ProtocolVersion.getCompatibleVersion(inECLStartMsg.getVersion()));
            this.serverURL = inECLStartMsg.getServerURL();
            this.setInitialServerState(inECLStartMsg.getServerState());
            this.setSendWindowSize(inECLStartMsg.getWindowSize());
            if (this.getProtocolVersion() > 1) {
                this.groupId = inECLStartMsg.getGroupId();
            }
        }
        catch (Exception e) {
            Message message = Message.raw(e.getLocalizedMessage(), new Object[0]);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        return inECLStartMsg.getSSLEncryption();
    }

    private StartMsg sendStartToRemote() throws IOException {
        StartMsg startMsg = this.getProtocolVersion() < 4 ? new ReplServerStartMsg(this.replicationServerId, this.replicationServerURL, this.getServiceId(), this.maxRcvWindow, this.replicationServerDomain.getDbServerState(), this.localGenerationId, this.sslEncryption, this.getLocalGroupId(), this.replicationServerDomain.getReplicationServer().getDegradedStatusThreshold()) : new ReplServerStartDSMsg(this.replicationServerId, this.replicationServerURL, this.getServiceId(), this.maxRcvWindow, new ServerState(), this.localGenerationId, this.sslEncryption, this.getLocalGroupId(), 0, this.replicationServer.getWeight(), 0);
        this.send(startMsg);
        return startMsg;
    }

    public ECLServerHandler(Session session, int queueSize, String replicationServerURL, int replicationServerId, ReplicationServer replicationServer, int rcvWindowSize) {
        super(session, queueSize, replicationServerURL, replicationServerId, replicationServer, rcvWindowSize);
        try {
            this.setServiceIdAndDomain("cn=changelog", true);
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
    }

    public ECLServerHandler(String replicationServerURL, int replicationServerId, ReplicationServer replicationServer, StartECLSessionMsg startECLSessionMsg) throws DirectoryException {
        super(null, 1, replicationServerURL, replicationServerId, replicationServer, 0);
        try {
            this.setServiceIdAndDomain("cn=changelog", true);
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        this.initialize(startECLSessionMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFromRemoteServer(ServerStartECLMsg inECLStartMsg) {
        try {
            StartECLSessionMsg inStartECLSessionMsg;
            boolean sessionInitiatorSSLEncryption = this.processStartFromRemote(inECLStartMsg);
            if (this.replicationServerDomain != null) {
                this.lockDomain(true);
            }
            this.localGenerationId = -1L;
            StartMsg outStartMsg = this.sendStartToRemote();
            this.logStartHandshakeRCVandSND(inECLStartMsg, outStartMsg);
            if (!sessionInitiatorSSLEncryption) {
                this.session.stopEncryption();
            }
            if ((inStartECLSessionMsg = this.waitAndProcessStartSessionECLFromRemoteServer()) == null) {
                this.logStopReceived();
                this.abortStart(null);
                return;
            }
            this.logStartECLSessionHandshake(inStartECLSessionMsg);
            this.initialize(inStartECLSessionMsg);
        }
        catch (DirectoryException de) {
            this.abortStart(de.getMessageObject());
        }
        catch (Exception e) {
            this.abortStart(Message.raw(e.getLocalizedMessage(), new Object[0]));
        }
        finally {
            if (this.replicationServerDomain != null && this.replicationServerDomain.hasLock()) {
                this.replicationServerDomain.release();
            }
        }
    }

    private StartECLSessionMsg waitAndProcessStartSessionECLFromRemoteServer() throws DirectoryException, IOException, ClassNotFoundException, DataFormatException, NotSupportedOldVersionPDUException {
        ReplicationMsg msg = this.session.receive();
        if (msg instanceof StopMsg) {
            return null;
        }
        if (!(msg instanceof StartECLSessionMsg)) {
            Message message = Message.raw("Protocol error: StartECLSessionMsg required." + msg + " received.", new Object[0]);
            this.abortStart(message);
            return null;
        }
        return (StartECLSessionMsg)msg;
    }

    public void initializeCLSearchFromGenState(String crossDomainStartState) throws DirectoryException {
        this.initializeCLDomCtxts(crossDomainStartState, false);
    }

    public void initializeCLSearchFromDraftCN(int startDraftCN) throws DirectoryException {
        try {
            String crossDomainStartState;
            this.draftCompat = true;
            DraftCNDbHandler draftCNDb = this.replicationServer.getDraftCNDbHandler();
            if (startDraftCN <= 1) {
                if (draftCNDb.count() == 0L) {
                    this.isEndOfDraftCNReached = true;
                    crossDomainStartState = null;
                } else {
                    crossDomainStartState = draftCNDb.getValue(draftCNDb.getFirstKey());
                    this.draftCNDbIter = draftCNDb.generateIterator(draftCNDb.getFirstKey());
                }
            } else {
                crossDomainStartState = draftCNDb.getValue(startDraftCN);
                if (crossDomainStartState != null) {
                    this.draftCNDbIter = draftCNDb.generateIterator(startDraftCN);
                } else {
                    int[] limits = this.replicationServer.getECLDraftCNLimits(this.eligibleCN, this.excludedServiceIDs);
                    if (startDraftCN < limits[0]) {
                        crossDomainStartState = draftCNDb.getValue(limits[0]);
                        if (crossDomainStartState != null) {
                            this.draftCNDbIter = draftCNDb.generateIterator(limits[0]);
                        } else {
                            this.isEndOfDraftCNReached = true;
                            crossDomainStartState = null;
                        }
                    } else if (startDraftCN <= limits[1]) {
                        if (draftCNDb.count() == 0L) {
                            this.isEndOfDraftCNReached = true;
                            crossDomainStartState = null;
                        } else {
                            crossDomainStartState = draftCNDb.getValue(draftCNDb.getLastKey());
                            this.draftCNDbIter = draftCNDb.generateIterator(draftCNDb.getLastKey());
                        }
                    } else {
                        throw new DirectoryException(ResultCode.SUCCESS, Message.raw("", new Object[0]));
                    }
                }
            }
            this.draftCompat = true;
            this.initializeCLDomCtxts(crossDomainStartState, true);
        }
        catch (DirectoryException de) {
            TRACER.debugCaught(DebugLogLevel.ERROR, de);
            if (this.draftCNDbIter != null) {
                this.draftCNDbIter.releaseCursor();
            }
            throw de;
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            if (this.draftCNDbIter != null) {
                this.draftCNDbIter.releaseCursor();
            }
            throw new DirectoryException(ResultCode.OPERATIONS_ERROR, Message.raw(Category.SYNC, Severity.FATAL_ERROR, e.getLocalizedMessage(), new Object[0]));
        }
    }

    public void initializeCLDomCtxts(String providedCookie, boolean allowUnknownDomains) throws DirectoryException {
        Map<Object, Object> startStatesFromProvidedCookie = new HashMap();
        ReplicationServer rs = this.replicationServer;
        if (providedCookie != null && providedCookie.length() != 0) {
            startStatesFromProvidedCookie = MultiDomainServerState.splitGenStateToServerStates(providedCookie);
        }
        try {
            Iterator<ReplicationServerDomain> rsdi = rs.getDomainIterator();
            HashSet<DomainContext> tmpSet = new HashSet<DomainContext>();
            String missingDomains = "";
            if (rsdi != null) {
                while (rsdi.hasNext()) {
                    ReplicationServerDomain rsd = rsdi.next();
                    if (rsd == this.replicationServerDomain) continue;
                    if (this.excludedServiceIDs.contains(rsd.getBaseDn())) {
                        if (!allowUnknownDomains) continue;
                        startStatesFromProvidedCookie.remove(rsd.getBaseDn());
                        continue;
                    }
                    if (rsd.getDbServerState().isEmpty()) continue;
                    DomainContext domainContext = new DomainContext();
                    domainContext.active = true;
                    domainContext.rsd = rsd;
                    domainContext.domainLatestTrimDate = rsd.getLatestDomainTrimDate();
                    if (this.isPersistent == 2) {
                        domainContext.startState = rsd.getEligibleState(this.eligibleCN);
                        startStatesFromProvidedCookie.remove(rsd.getBaseDn());
                    } else {
                        domainContext.startState = (ServerState)startStatesFromProvidedCookie.remove(rsd.getBaseDn());
                        if (providedCookie == null || providedCookie.length() == 0 || allowUnknownDomains) {
                            if (domainContext.startState == null) {
                                ChangeNumber latestTrimCN = new ChangeNumber(domainContext.domainLatestTrimDate, 0, 0);
                                domainContext.startState = rsd.getStartState().duplicateOnlyOlderThan(latestTrimCN);
                            }
                        } else {
                            if (domainContext.startState == null) {
                                missingDomains = missingDomains + rsd.getBaseDn() + ":;";
                                continue;
                            }
                            if (!domainContext.startState.isEmpty()) {
                                boolean cookieTooOld = false;
                                for (int aServerId : rsd.getStartState()) {
                                    ChangeNumber dbOldestChange = rsd.getStartState().getMaxChangeNumber(aServerId);
                                    ChangeNumber providedChange = domainContext.startState.getMaxChangeNumber(aServerId);
                                    if (providedChange == null || !providedChange.older(dbOldestChange).booleanValue()) continue;
                                    cookieTooOld = true;
                                }
                                if (cookieTooOld) {
                                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, ReplicationMessages.ERR_RESYNC_REQUIRED_TOO_OLD_DOMAIN_IN_PROVIDED_COOKIE.get(domainContext.rsd.getBaseDn()));
                                }
                            }
                        }
                        domainContext.stopState = rsd.getEligibleState(this.eligibleCN);
                    }
                    domainContext.currentState = new ServerState();
                    MessageHandler mh = new MessageHandler(this.maxQueueSize, this.replicationServerURL, this.replicationServerId, this.replicationServer);
                    mh.setInitialServerState(domainContext.startState);
                    mh.setServiceIdAndDomain(rsd.getBaseDn(), false);
                    rsd.registerHandler(mh);
                    domainContext.mh = mh;
                    this.previousCookie.update(domainContext.rsd.getBaseDn(), domainContext.startState);
                    tmpSet.add(domainContext);
                }
            }
            if (missingDomains.length() > 0) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, ReplicationMessages.ERR_RESYNC_REQUIRED_MISSING_DOMAIN_IN_PROVIDED_COOKIE.get(missingDomains, "<" + providedCookie + missingDomains + ">"));
            }
            this.domainCtxts = tmpSet.toArray(new DomainContext[tmpSet.size()]);
            if (!startStatesFromProvidedCookie.isEmpty() && allowUnknownDomains) {
                for (String string : startStatesFromProvidedCookie.keySet()) {
                    if (rs.getReplicationServerDomain(string, false) != null) continue;
                    startStatesFromProvidedCookie.remove(string);
                }
            }
            if (!startStatesFromProvidedCookie.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (DomainContext domainCtxt : this.domainCtxts) {
                    sb.append(domainCtxt.rsd.getBaseDn()).append(":").append(domainCtxt.startState).append(";");
                }
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, ReplicationMessages.ERR_RESYNC_REQUIRED_UNKNOWN_DOMAIN_IN_PROVIDED_COOKIE.get(startStatesFromProvidedCookie.toString(), sb.toString()));
            }
            this.startCookie = providedCookie;
            for (DomainContext domainCtxt : this.domainCtxts) {
                domainCtxt.getNextEligibleMessageForDomain(this.operationId);
                if (domainCtxt.nextMsg != null) continue;
                domainCtxt.active = false;
            }
        }
        catch (DirectoryException de) {
            throw de;
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            throw new DirectoryException(ResultCode.OPERATIONS_ERROR, Message.raw(Category.SYNC, Severity.INFORMATION, "Exception raised: " + e, new Object[0]), e);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(" initializeCLDomCtxts ends with  " + this.dumpState());
        }
    }

    private void registerIntoDomain() {
        if (this.replicationServerDomain != null) {
            this.replicationServerDomain.registerHandler(this);
        }
    }

    @Override
    public void shutdown() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this + " shutdown()" + this.draftCNDbIter);
        }
        if (this.draftCNDbIter != null) {
            this.draftCNDbIter.releaseCursor();
            this.draftCNDbIter = null;
        }
        for (DomainContext domainCtxt : this.domainCtxts) {
            if (!domainCtxt.unRegisterHandler()) {
                ErrorLogger.logError(Message.raw(Category.SYNC, Severity.NOTICE, this + " shutdown() - error when unregistering handler " + domainCtxt.mh, new Object[0]));
            }
            domainCtxt.stopServer();
        }
        super.shutdown();
        this.domainCtxts = null;
    }

    @Override
    protected void shutdownWriter() {
        this.shutdownWriter = true;
        if (this.writer != null) {
            ECLServerWriter eclWriter = (ECLServerWriter)this.writer;
            eclWriter.shutdownWriter();
        }
    }

    @Override
    public String getMonitorInstanceName() {
        String str = this.serverURL + " " + String.valueOf(this.serverId);
        return "Connected External Changelog Server " + str + "cn=changelog";
    }

    @Override
    public ArrayList<Attribute> getMonitorData() {
        List attributes = super.getMonitorData();
        ((ArrayList)attributes).add(Attributes.create("External-Changelog-Server", this.serverURL));
        return attributes;
    }

    public String toString() {
        String localString = "External changelog Server ";
        localString = this.serverId != 0 ? localString + this.serverId + " " + this.serverURL + " " + this.getServiceId() + " " + this.getOperationId() : localString + this.getClass().getCanonicalName() + " " + this.operationId;
        return localString;
    }

    @Override
    public ServerStatus getStatus() {
        return ServerStatus.NORMAL_STATUS;
    }

    @Override
    public boolean isDataServer() {
        return true;
    }

    public void initialize(StartECLSessionMsg startECLSessionMsg) throws DirectoryException {
        this.operationId = startECLSessionMsg.getOperationId();
        this.isPersistent = startECLSessionMsg.isPersistent();
        this.lastDraftCN = startECLSessionMsg.getLastDraftChangeNumber();
        this.searchPhase = INIT_PHASE;
        try {
            this.previousCookie = new MultiDomainServerState(startECLSessionMsg.getCrossDomainServerState());
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, ReplicationMessages.ERR_INVALID_COOKIE_SYNTAX.get());
        }
        this.excludedServiceIDs = startECLSessionMsg.getExcludedServiceIDs();
        this.replicationServer.disableEligibility(this.excludedServiceIDs);
        this.eligibleCN = this.replicationServer.getEligibleCN();
        if (startECLSessionMsg.getECLRequestType() == 0) {
            this.initializeCLSearchFromGenState(startECLSessionMsg.getCrossDomainServerState());
        } else if (startECLSessionMsg.getECLRequestType() == 1) {
            this.initializeCLSearchFromDraftCN(startECLSessionMsg.getFirstDraftChangeNumber());
        }
        if (this.session != null) {
            try {
                this.session.setSoTimeout(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sendWindow = new Semaphore(this.sendWindowSize);
            this.reader = new ServerReader(this.session, this);
            this.reader.start();
            if (this.writer == null) {
                this.writer = new ECLServerWriter(this.session, this, this.replicationServerDomain);
                this.writer.start();
            }
            ((ECLServerWriter)this.writer).resumeWriter();
        }
        if (this.isPersistent == 2) {
            this.closeInitPhase();
        }
        this.registerIntoDomain();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this.getClass().getCanonicalName() + " " + this.operationId + " initialized: " + " " + this.dumpState() + " " + " " + this.clDomCtxtsToString(""));
        }
    }

    public ECLUpdateMsg takeECLUpdate() throws DirectoryException {
        boolean interrupted = true;
        ECLUpdateMsg msg = this.getNextECLUpdate();
        if (this.session == null) {
            return msg;
        }
        boolean acquired = false;
        do {
            try {
                acquired = this.sendWindow.tryAcquire(500L, TimeUnit.MILLISECONDS);
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((interrupted || !acquired) && !this.shutdownWriter);
        if (msg != null) {
            this.incrementOutCount();
        }
        return msg;
    }

    @Override
    protected UpdateMsg getNextMessage(boolean synchronous) {
        UpdateMsg msg = null;
        try {
            ECLUpdateMsg eclMsg = this.getNextECLUpdate();
            if (eclMsg != null) {
                msg = eclMsg.getUpdateMsg();
            }
        }
        catch (DirectoryException de) {
            TRACER.debugCaught(DebugLogLevel.ERROR, de);
        }
        return msg;
    }

    public ECLUpdateMsg getNextECLUpdate() throws DirectoryException {
        ECLUpdateMsg oldestChange = null;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In cn=changelog" + this + " getNextECLUpdate starts: " + this.dumpState());
        }
        try {
            int iDom;
            boolean continueLooping = true;
            while (continueLooping && this.searchPhase == INIT_PHASE) {
                block26: {
                    if (this.searchPhase != INIT_PHASE) continue;
                    continueLooping = false;
                    iDom = this.getOldestChangeFromDomainCtxts();
                    if (iDom == -1) {
                        this.closeInitPhase();
                        return null;
                    }
                    oldestChange = new ECLUpdateMsg((LDAPUpdateMsg)this.domainCtxts[iDom].nextMsg, null, this.domainCtxts[iDom].rsd.getBaseDn(), 0);
                    this.domainCtxts[iDom].nextMsg = null;
                    if (this.draftCompat) {
                        DraftCNDbHandler draftCNDb = this.replicationServer.getDraftCNDbHandler();
                        ChangeNumber cnFromChangelogDb = oldestChange.getUpdateMsg().getChangeNumber();
                        String dnFromChangelogDb = this.domainCtxts[iDom].rsd.getBaseDn();
                        while (!this.isEndOfDraftCNReached) {
                            ChangeNumber cnFromDraftCNDb = this.draftCNDbIter.getChangeNumber();
                            String dnFromDraftCNDb = this.draftCNDbIter.getServiceID();
                            int areCNEqual = cnFromChangelogDb.compareTo(cnFromDraftCNDb);
                            int areDNEqual = dnFromChangelogDb.compareTo(dnFromDraftCNDb);
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("getNextECLUpdate generating draftCN  comparing the 2 db DNs :" + dnFromChangelogDb + "?=" + cnFromChangelogDb + " timestamps:" + new Date(cnFromChangelogDb.getTime()) + " ?older" + new Date(cnFromDraftCNDb.getTime()));
                            }
                            if (areDNEqual == 0 && areCNEqual == 0) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugInfo("getNextECLUpdate generating draftCN  assigning draftCN=" + this.draftCNDbIter.getDraftCN() + " to change=" + oldestChange);
                                }
                                oldestChange.setDraftChangeNumber(this.draftCNDbIter.getDraftCN());
                                break block26;
                            }
                            if (cnFromDraftCNDb.older(cnFromChangelogDb).booleanValue()) {
                                try {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugInfo("getNextECLUpdate generating draftCN  will skip " + cnFromDraftCNDb + " and read next change from the DraftCNDb.");
                                    }
                                    boolean bl = this.isEndOfDraftCNReached = !this.draftCNDbIter.next();
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugInfo("getNextECLUpdate generating draftCN  has skiped to  sn=" + this.draftCNDbIter.getDraftCN() + " cn=" + this.draftCNDbIter.getChangeNumber() + " End of draftCNDb ?" + this.isEndOfDraftCNReached);
                                    }
                                    if (!this.isEndOfDraftCNReached) continue;
                                    oldestChange.setDraftChangeNumber(this.replicationServer.getNewDraftCN());
                                    draftCNDb.add(oldestChange.getDraftChangeNumber(), this.previousCookie.toString(), oldestChange.getServiceId(), oldestChange.getUpdateMsg().getChangeNumber());
                                    break block26;
                                }
                                catch (Exception exception) {
                                    continue;
                                }
                            }
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("getNextECLUpdate: will skip " + cnFromChangelogDb + " and read next from the regular changelog.");
                            }
                            continueLooping = true;
                            break block26;
                        }
                        oldestChange.setDraftChangeNumber(this.replicationServer.getNewDraftCN());
                        draftCNDb.add(oldestChange.getDraftChangeNumber(), this.previousCookie.toString(), this.domainCtxts[iDom].rsd.getBaseDn(), oldestChange.getUpdateMsg().getChangeNumber());
                    }
                }
                this.domainCtxts[iDom].currentState.update(oldestChange.getUpdateMsg().getChangeNumber());
                if (this.domainCtxts[iDom].currentState.cover(this.domainCtxts[iDom].stopState)) {
                    this.domainCtxts[iDom].active = false;
                }
                if (this.draftCompat && this.lastDraftCN > 0 && oldestChange.getDraftChangeNumber() > this.lastDraftCN) {
                    this.domainCtxts[iDom].active = false;
                }
                if (!this.domainCtxts[iDom].active) continue;
                this.domainCtxts[iDom].getNextEligibleMessageForDomain(this.operationId);
            }
            if (this.searchPhase == PERSISTENT_PHASE) {
                if (DebugLogger.debugEnabled()) {
                    this.clDomCtxtsToString("In getNextECLUpdate (persistent): looking for the generalized oldest change");
                }
                for (DomainContext domainCtxt : this.domainCtxts) {
                    domainCtxt.getNextEligibleMessageForDomain(this.operationId);
                }
                iDom = this.getOldestChangeFromDomainCtxts();
                if (iDom != -1) {
                    String suffix = this.domainCtxts[iDom].rsd.getBaseDn();
                    oldestChange = new ECLUpdateMsg((LDAPUpdateMsg)this.domainCtxts[iDom].nextMsg, null, suffix, 0);
                    this.domainCtxts[iDom].nextMsg = null;
                    this.domainCtxts[iDom].currentState.update(oldestChange.getUpdateMsg().getChangeNumber());
                    if (this.draftCompat) {
                        DraftCNDbHandler draftCNDb = this.replicationServer.getDraftCNDbHandler();
                        oldestChange.setDraftChangeNumber(this.replicationServer.getNewDraftCN());
                        draftCNDb.add(oldestChange.getDraftChangeNumber(), this.previousCookie.toString(), this.domainCtxts[iDom].rsd.getBaseDn(), oldestChange.getUpdateMsg().getChangeNumber());
                    }
                }
            }
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            throw new DirectoryException(ResultCode.OPERATIONS_ERROR, Message.raw(Category.SYNC, Severity.INFORMATION, "Exception raised: ", new Object[0]), e);
        }
        if (oldestChange != null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("getNextECLUpdate updates previousCookie:" + oldestChange.getUpdateMsg().getChangeNumber());
            }
            this.previousCookie.update(oldestChange.getServiceId(), oldestChange.getUpdateMsg().getChangeNumber());
            oldestChange.setCookie(this.previousCookie);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("getNextECLUpdate returns result oldest change =" + oldestChange);
            }
        }
        return oldestChange;
    }

    private void closeInitPhase() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In cn=changelog," + this + " closeInitPhase(): " + this.dumpState());
        }
        for (DomainContext domainCtxt : this.domainCtxts) {
            domainCtxt.active = true;
        }
        if (this.isPersistent != 1) {
            this.searchPhase = PERSISTENT_PHASE;
            if (this.writer == null) {
                this.writer = new ECLServerWriter(this.session, this, this.replicationServerDomain);
                this.writer.start();
            }
        } else {
            this.searchPhase = UNDEFINED_PHASE;
        }
        if (this.draftCNDbIter != null) {
            this.draftCNDbIter.releaseCursor();
            this.draftCNDbIter = null;
        }
    }

    private int getOldestChangeFromDomainCtxts() {
        int oldest = -1;
        for (int i = 0; i < this.domainCtxts.length; ++i) {
            if (!this.domainCtxts[i].active || this.domainCtxts[i].nextMsg == null || oldest != -1 && this.domainCtxts[i].nextMsg.compareTo(this.domainCtxts[oldest].nextMsg) >= 0) continue;
            oldest = i;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In cn=changelog," + this + " getOldestChangeFromDomainCtxts() returns " + (oldest != -1 ? this.domainCtxts[oldest].nextMsg : "-1"));
        }
        return oldest;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public short isPersistent() {
        return this.isPersistent;
    }

    public int getSearchPhase() {
        return this.searchPhase;
    }

    public void refreshEligibleCN() {
        this.eligibleCN = this.replicationServer.getEligibleCN();
    }

    private class DomainContext {
        ReplicationServerDomain rsd;
        boolean active;
        MessageHandler mh;
        private UpdateMsg nextMsg;
        private UpdateMsg nextNonEligibleMsg;
        ServerState startState;
        ServerState currentState;
        ServerState stopState;
        long domainLatestTrimDate;

        private DomainContext() {
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer);
            return buffer.toString();
        }

        public void toString(StringBuilder buffer) {
            buffer.append("[ [active=").append(this.active).append("] [rsd=").append(this.rsd).append("] [nextMsg=").append(this.nextMsg).append("(").append(this.nextMsg != null ? new Date(this.nextMsg.getChangeNumber().getTime()).toString() : "").append(")] [nextNonEligibleMsg=").append(this.nextNonEligibleMsg).append("] [startState=").append(this.startState).append("] [stopState=").append(this.stopState).append("] [currentState=").append(this.currentState).append("]]");
        }

        private void getNextEligibleMessageForDomain(String opid) {
            if (DebugLogger.debugEnabled()) {
                MessageHandler.TRACER.debugInfo(" In ECLServerHandler, for " + this.mh.getServiceId() + " getNextEligibleMessageForDomain(" + opid + ") " + "ctxt=" + this.toString());
            }
            assert (this.nextMsg == null);
            try {
                if (this.nextNonEligibleMsg != null) {
                    boolean hasBecomeEligible;
                    boolean bl = hasBecomeEligible = this.nextNonEligibleMsg.getChangeNumber().getTime() <= ECLServerHandler.this.eligibleCN.getTime();
                    if (DebugLogger.debugEnabled()) {
                        MessageHandler.TRACER.debugInfo(" In ECLServerHandler, for " + this.mh.getServiceId() + " getNextEligibleMessageForDomain(" + opid + ") " + " stored nonEligibleMsg " + this.nextNonEligibleMsg + " has now become eligible regarding " + " the eligibleCN (" + ECLServerHandler.this.eligibleCN + " ):" + hasBecomeEligible);
                    }
                    if (hasBecomeEligible) {
                        this.nextMsg = this.nextNonEligibleMsg;
                        this.nextNonEligibleMsg = null;
                    }
                } else {
                    UpdateMsg newMsg;
                    while ((newMsg = this.mh.getNextMessage(false)) != null && newMsg.getChangeNumber().getTime() < this.domainLatestTrimDate) {
                    }
                    if (DebugLogger.debugEnabled()) {
                        MessageHandler.TRACER.debugInfo(" In ECLServerHandler, for " + this.mh.getServiceId() + " getNextEligibleMessageForDomain(" + opid + ") " + " got new message : " + " serviceId=[" + this.mh.getServiceId() + "] [newMsg=" + newMsg + "]" + ECLServerHandler.this.dumpState());
                    }
                    if (newMsg != null) {
                        boolean isEligible;
                        boolean bl = isEligible = newMsg.getChangeNumber().getTime() <= ECLServerHandler.this.eligibleCN.getTime();
                        if (DebugLogger.debugEnabled()) {
                            MessageHandler.TRACER.debugInfo(" In ECLServerHandler, for " + this.mh.getServiceId() + " getNextEligibleMessageForDomain(" + opid + ") " + "newMsg isEligible=" + isEligible + " since " + "newMsg=[" + newMsg.getChangeNumber() + " " + new Date(newMsg.getChangeNumber().getTime()).toString() + "] eligibleCN=[" + ECLServerHandler.this.eligibleCN + " " + new Date(ECLServerHandler.this.eligibleCN.getTime()).toString() + "]" + ECLServerHandler.this.dumpState());
                        }
                        if (isEligible) {
                            this.nextMsg = newMsg;
                        } else {
                            this.nextNonEligibleMsg = newMsg;
                        }
                    }
                }
            }
            catch (Exception e) {
                MessageHandler.TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }

        private boolean unRegisterHandler() {
            return this.rsd.unRegisterHandler(this.mh);
        }

        private void stopServer() {
            this.rsd.stopServer(this.mh);
        }
    }
}

