/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.server.MonitorData;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ReplicationServerHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.Attributes;
import org.opends.server.types.InitializationException;

public class LightweightServerHandler
extends MonitorProvider<MonitorProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ReplicationServerHandler replServerHandler;
    private ReplicationServerDomain rsDomain;
    private int replicationServerId = -1;
    private int serverId = -1;
    private String serverUrl = null;
    private long generationId = -1L;
    private byte groupId = (byte)-1;
    private ServerStatus status = ServerStatus.INVALID_STATUS;
    private List<String> refUrls = new ArrayList<String>();
    private boolean assuredFlag = false;
    private AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    private byte safeDataLevel = (byte)-1;
    private short protocolVersion = (short)-1;
    private Set<String> eclInclude = new HashSet<String>();
    private Set<String> eclIncludeForDeletes = new HashSet<String>();

    public LightweightServerHandler(ReplicationServerHandler replServerHandler, int replicationServerId, int serverId, String serverUrl, long generationId, byte groupId, ServerStatus status, List<String> refUrls, boolean assuredFlag, AssuredMode assuredMode, byte safeDataLevel, Set<String> eclInclude, Set<String> eclIncludeForDeletes, short protocolVersion) {
        this.replServerHandler = replServerHandler;
        this.rsDomain = replServerHandler.getDomain();
        this.replicationServerId = replicationServerId;
        this.serverId = serverId;
        this.serverUrl = serverUrl;
        this.generationId = generationId;
        this.groupId = groupId;
        this.status = status;
        this.refUrls = refUrls;
        this.assuredFlag = assuredFlag;
        this.assuredMode = assuredMode;
        this.safeDataLevel = safeDataLevel;
        this.eclInclude = eclInclude;
        this.eclIncludeForDeletes = eclIncludeForDeletes;
        this.protocolVersion = protocolVersion;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + replServerHandler.getDomain().getReplicationServer().getMonitorInstanceName() + " LWSH for remote server " + this.serverId + " connected to:" + this.replServerHandler.getMonitorInstanceName() + " ()");
        }
    }

    public DSInfo toDSInfo() {
        return new DSInfo(this.serverId, this.serverUrl, this.replicationServerId, this.generationId, this.status, this.assuredFlag, this.assuredMode, this.safeDataLevel, this.groupId, this.refUrls, this.eclInclude, this.eclIncludeForDeletes, this.protocolVersion);
    }

    public int getServerId() {
        return this.serverId;
    }

    public void startHandler() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replServerHandler.getDomain().getReplicationServer().getMonitorInstanceName() + " LWSH for remote server " + this.serverId + " connected to:" + this.replServerHandler.getMonitorInstanceName() + " start");
        }
        DirectoryServer.deregisterMonitorProvider(this);
        DirectoryServer.registerMonitorProvider(this);
    }

    public void stopHandler() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("In " + this.replServerHandler.getDomain().getReplicationServer().getMonitorInstanceName() + " LWSH for remote server " + this.serverId + " connected to:" + this.replServerHandler.getMonitorInstanceName() + " stop");
        }
        DirectoryServer.deregisterMonitorProvider(this);
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        return "Connected directory server DS(" + this.serverId + ") " + this.serverUrl + ",cn=" + this.replServerHandler.getMonitorInstanceName();
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(Attributes.create("server-id", String.valueOf(this.serverId)));
        attributes.add(Attributes.create("domain-name", this.rsDomain.getBaseDn()));
        attributes.add(Attributes.create("connected-to", this.replServerHandler.getMonitorInstanceName()));
        MonitorData md = this.rsDomain.getDomainMonitorData();
        ServerState remoteState = md.getLDAPServerState(this.serverId);
        if (remoteState == null) {
            remoteState = new ServerState();
        }
        AttributeBuilder builder = new AttributeBuilder("server-state");
        for (String str : remoteState.toStringSet()) {
            builder.add(str);
        }
        if (builder.size() == 0) {
            builder.add("unknown");
        }
        attributes.add(builder.toAttribute());
        Long approxFirstMissingDate = md.getApproxFirstMissingDate(this.serverId);
        if (approxFirstMissingDate != null && approxFirstMissingDate > 0L) {
            Date date = new Date(approxFirstMissingDate);
            attributes.add(Attributes.create("approx-older-change-not-synchronized", date.toString()));
            attributes.add(Attributes.create("approx-older-change-not-synchronized-millis", String.valueOf(approxFirstMissingDate)));
        }
        long missingChanges = md.getMissingChanges(this.serverId);
        attributes.add(Attributes.create("missing-changes", String.valueOf(missingChanges)));
        long delay = md.getApproxDelay(this.serverId);
        attributes.add(Attributes.create("approximate-delay", String.valueOf(delay)));
        return attributes;
    }
}

