/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.UpdateMsg;

public class NotAssuredUpdateMsg
extends UpdateMsg {
    private UpdateMsg realUpdateMsg = null;
    private byte[] realUpdateMsgNotAssuredBytesV1 = null;
    private byte[] realUpdateMsgNotAssuredBytesVLatest = null;

    NotAssuredUpdateMsg(UpdateMsg updateMsg) throws UnsupportedEncodingException {
        this.realUpdateMsg = updateMsg;
        if (this.realUpdateMsg instanceof LDAPUpdateMsg) {
            int pos;
            byte[] origBytes = this.realUpdateMsg.getBytes((short)1);
            byte[] bytes = new byte[origBytes.length];
            System.arraycopy(origBytes, 0, bytes, 0, origBytes.length);
            int maxLen = bytes.length;
            int nZeroFound = 0;
            boolean found = false;
            for (pos = 1; pos < maxLen; ++pos) {
                if (bytes[pos] != 0 || ++nZeroFound != 2) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new UnsupportedEncodingException("Could not find end of change number.");
            }
            if (++pos >= maxLen) {
                throw new UnsupportedEncodingException("Reached end of packet.");
            }
            bytes[pos] = 0;
            this.realUpdateMsgNotAssuredBytesV1 = bytes;
            origBytes = this.realUpdateMsg.getBytes(ProtocolVersion.getCurrentVersion());
            bytes = new byte[origBytes.length];
            System.arraycopy(origBytes, 0, bytes, 0, origBytes.length);
            maxLen = bytes.length;
            nZeroFound = 0;
            found = false;
            for (pos = 2; pos < maxLen; ++pos) {
                if (bytes[pos] != 0 || ++nZeroFound != 3) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new UnsupportedEncodingException("Could not find end of change number.");
            }
            if (++pos >= maxLen) {
                throw new UnsupportedEncodingException("Reached end of packet.");
            }
            bytes[pos] = 0;
            this.realUpdateMsgNotAssuredBytesVLatest = bytes;
        } else {
            int pos;
            byte[] origBytes = this.realUpdateMsg.getBytes(ProtocolVersion.getCurrentVersion());
            byte[] bytes = new byte[origBytes.length];
            System.arraycopy(origBytes, 0, bytes, 0, origBytes.length);
            int maxLen = bytes.length;
            int nZeroFound = 0;
            boolean found = false;
            for (pos = 2; pos < maxLen; ++pos) {
                if (bytes[pos] != 0 || ++nZeroFound != 1) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new UnsupportedEncodingException("Could not find end of change number.");
            }
            if (++pos >= maxLen) {
                throw new UnsupportedEncodingException("Reached end of packet.");
            }
            bytes[pos] = 0;
            this.realUpdateMsgNotAssuredBytesVLatest = bytes;
        }
    }

    @Override
    public ChangeNumber getChangeNumber() {
        return this.realUpdateMsg.getChangeNumber();
    }

    @Override
    public boolean isAssured() {
        return false;
    }

    @Override
    public void setAssured(boolean assured) {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj.getClass() != this.realUpdateMsg.getClass()) {
                return false;
            }
            return this.realUpdateMsg.getChangeNumber().equals(((UpdateMsg)obj).getChangeNumber());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.realUpdateMsg.hashCode();
    }

    @Override
    public int compareTo(UpdateMsg msg) {
        return this.realUpdateMsg.compareTo(msg);
    }

    @Override
    public byte[] getBytes(short reqProtocolVersion) throws UnsupportedEncodingException {
        if (reqProtocolVersion == 1) {
            return this.realUpdateMsgNotAssuredBytesV1;
        }
        return this.realUpdateMsgNotAssuredBytesVLatest;
    }

    @Override
    public AssuredMode getAssuredMode() {
        return this.realUpdateMsg.getAssuredMode();
    }

    @Override
    public byte getSafeDataLevel() {
        return this.realUpdateMsg.getSafeDataLevel();
    }

    @Override
    public void setAssuredMode(AssuredMode assuredMode) {
    }

    @Override
    public void setSafeDataLevel(byte safeDataLevel) {
    }

    @Override
    public short getVersion() {
        return this.realUpdateMsg.getVersion();
    }

    @Override
    public int size() {
        return this.realUpdateMsg.size();
    }

    @Override
    protected byte[] encodeHeader(byte type, int additionalLength, short version) throws UnsupportedEncodingException {
        return null;
    }

    @Override
    public int decodeHeader(byte type, byte[] encodedMsg) throws DataFormatException {
        return -1;
    }

    @Override
    public byte[] getPayload() {
        return this.realUpdateMsg.getPayload();
    }
}

