/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.net.SocketException;
import java.util.NoSuchElementException;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.protocol.Session;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.util.StaticUtils;

public class ServerWriter
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final Session session;
    private final ServerHandler handler;
    private final ReplicationServerDomain replicationServerDomain;

    public ServerWriter(Session session, ServerHandler handler, ReplicationServerDomain replicationServerDomain) {
        super("Replication server RS(" + handler.getReplicationServerId() + ") writing to " + handler.toString() + " at " + (session != null ? session.getReadableRemoteAddress() : "unknown"));
        this.session = session;
        this.handler = handler;
        this.replicationServerDomain = replicationServerDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Message errMessage = null;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this.getName() + " starting");
        }
        try {
            while (true) {
                UpdateMsg update;
                if ((update = this.replicationServerDomain.take(this.handler)) == null) {
                    errMessage = Message.raw("Connection closure: null update returned by domain.", new Object[0]);
                    return;
                }
                if (this.handler.isDataServer()) {
                    ServerStatus dsStatus = this.handler.getStatus();
                    if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS || dsStatus == ServerStatus.FULL_UPDATE_STATUS) {
                        long referenceGenerationId = this.replicationServerDomain.getGenerationId();
                        if (dsStatus == ServerStatus.BAD_GEN_ID_STATUS) {
                            ErrorLogger.logError(ReplicationMessages.WARN_IGNORING_UPDATE_TO_DS_BADGENID.get(this.handler.getReplicationServerId(), update.getChangeNumber().toString(), this.handler.getServiceId(), this.handler.getServerId(), this.session.getReadableRemoteAddress(), this.handler.getGenerationId(), referenceGenerationId));
                        }
                        if (dsStatus != ServerStatus.FULL_UPDATE_STATUS) continue;
                        ErrorLogger.logError(ReplicationMessages.WARN_IGNORING_UPDATE_TO_DS_FULLUP.get(this.handler.getReplicationServerId(), update.getChangeNumber().toString(), this.handler.getServiceId(), this.handler.getServerId(), this.session.getReadableRemoteAddress()));
                        continue;
                    }
                } else {
                    long referenceGenerationId = this.replicationServerDomain.getGenerationId();
                    if (referenceGenerationId != this.handler.getGenerationId() || referenceGenerationId == -1L || this.handler.getGenerationId() == -1L) {
                        ErrorLogger.logError(ReplicationMessages.WARN_IGNORING_UPDATE_TO_RS.get(this.handler.getReplicationServerId(), update.getChangeNumber().toString(), this.handler.getServiceId(), this.handler.getServerId(), this.session.getReadableRemoteAddress(), this.handler.getGenerationId(), referenceGenerationId));
                        continue;
                    }
                }
                this.session.publish(update);
                continue;
                break;
            }
        }
        catch (NoSuchElementException e) {
            errMessage = this.handler.isDataServer() ? ReplicationMessages.ERR_DS_BADLY_DISCONNECTED.get(this.handler.getReplicationServerId(), this.handler.getServerId(), this.session.getReadableRemoteAddress(), this.handler.getServiceId()) : ReplicationMessages.ERR_RS_BADLY_DISCONNECTED.get(this.handler.getReplicationServerId(), this.handler.getServerId(), this.session.getReadableRemoteAddress(), this.handler.getServiceId());
            ErrorLogger.logError(errMessage);
            return;
        }
        catch (SocketException e) {
            errMessage = this.handler.isDataServer() ? ReplicationMessages.ERR_DS_BADLY_DISCONNECTED.get(this.handler.getReplicationServerId(), this.handler.getServerId(), this.session.getReadableRemoteAddress(), this.handler.getServiceId()) : ReplicationMessages.ERR_RS_BADLY_DISCONNECTED.get(this.handler.getReplicationServerId(), this.handler.getServerId(), this.session.getReadableRemoteAddress(), this.handler.getServiceId());
            ErrorLogger.logError(errMessage);
            return;
        }
        catch (Exception e) {
            errMessage = ReplicationMessages.ERR_WRITER_UNEXPECTED_EXCEPTION.get(this.handler.toString() + " " + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(errMessage);
            return;
        }
        finally {
            this.session.close();
            this.replicationServerDomain.stopServer(this.handler, false);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo(this.getName() + " stopped " + errMessage);
            }
        }
    }
}

