/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.service;

import java.io.IOException;
import java.io.InputStream;
import org.opends.server.replication.service.ReplicationDomain;

public class ReplInputStream
extends InputStream {
    private boolean closed;
    ReplicationDomain domain;
    private byte[] bytes;
    private int index;

    public ReplInputStream(ReplicationDomain domain) {
        this.domain = domain;
        this.closed = false;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int receivedLength;
        if (this.closed) {
            return -1;
        }
        if (this.bytes == null) {
            this.bytes = this.domain.receiveEntryBytes();
            if (this.bytes == null) {
                this.closed = true;
                return -1;
            }
            receivedLength = this.bytes.length;
            this.index = 0;
        } else {
            receivedLength = this.bytes.length - this.index;
        }
        int copiedLength = receivedLength <= len ? receivedLength : len;
        System.arraycopy(this.bytes, this.index, b, off, copiedLength);
        this.index += copiedLength;
        if (this.index == this.bytes.length) {
            this.bytes = null;
        }
        return copiedLength;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == 0) {
            throw new IOException();
        }
        return b[0];
    }
}

