/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;

class AuthPasswordEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "authPasswordMatch";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.4203.1.2.3";
    }

    @Override
    public String getDescription() {
        return "authentication password matching rule";
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.4203.1.1.2";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        return value.toByteString();
    }

    @Override
    public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
        StringBuilder[] authPWComponents;
        try {
            authPWComponents = AuthPasswordSyntax.decodeAuthPassword(attributeValue.toString());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.FALSE;
        }
        PasswordStorageScheme storageScheme = DirectoryServer.getAuthPasswordStorageScheme(authPWComponents[0].toString());
        if (storageScheme == null) {
            return ConditionResult.FALSE;
        }
        if (storageScheme.authPasswordMatches(assertionValue, authPWComponents[1].toString(), authPWComponents[2].toString())) {
            return ConditionResult.TRUE;
        }
        return ConditionResult.FALSE;
    }

    @Override
    public int generateHashCode(ByteSequence attributeValue) {
        return 1;
    }
}

