/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.messages.Message;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

class TelephoneNumberSubstringMatchingRule
extends SubstringMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "telephoneNumberSubstringsMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.21";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.58";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        String valueString = value.toString();
        int valueLength = valueString.length();
        StringBuilder buffer = new StringBuilder(valueLength);
        for (int i = 0; i < valueLength; ++i) {
            char c = valueString.charAt(i);
            if (!StaticUtils.isDigit(c)) continue;
            buffer.append(c);
        }
        return ByteString.valueOf(buffer.toString());
    }

    @Override
    public ByteString normalizeSubstring(ByteSequence substring) throws DirectoryException {
        ByteString value = this.normalizeValue(substring);
        if (value.length() == 0) {
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, Message.EMPTY);
        }
        return value;
    }
}

