/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.TelephoneNumberAttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class TelephoneNumberSyntax
extends AttributeSyntax<TelephoneNumberAttributeSyntaxCfg>
implements ConfigurationChangeListener<TelephoneNumberAttributeSyntaxCfg> {
    private boolean strictMode;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;
    private TelephoneNumberAttributeSyntaxCfg currentConfig;

    @Override
    public void initializeSyntax(TelephoneNumberAttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.20");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.20", "TelephoneNumber"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.21");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.21", "TelephoneNumber"));
        }
        this.strictMode = false;
        if (configuration != null) {
            this.currentConfig = configuration;
            this.currentConfig.addTelephoneNumberChangeListener(this);
            this.strictMode = this.currentConfig.isStrictFormat();
        }
    }

    @Override
    public void finalizeSyntax() {
        this.currentConfig.removeTelephoneNumberChangeListener(this);
    }

    @Override
    public String getSyntaxName() {
        return "TelephoneNumber";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.50";
    }

    @Override
    public String getDescription() {
        return "Telephone Number";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        String valueStr;
        if (value == null || (valueStr = value.toString().trim()).length() == 0) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_TELEPHONE_EMPTY.get());
            return false;
        }
        int length = valueStr.length();
        if (this.strictMode) {
            if (valueStr.charAt(0) != '+') {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_TELEPHONE_NO_PLUS.get(valueStr);
                invalidReason.append(message);
                return false;
            }
            boolean digitSeen = false;
            for (int i = 1; i < length; ++i) {
                char c = valueStr.charAt(i);
                if (StaticUtils.isDigit(c)) {
                    digitSeen = true;
                    continue;
                }
                if (this.isSeparator(c)) continue;
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_TELEPHONE_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), i);
                invalidReason.append(message);
                return false;
            }
            if (!digitSeen) {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_TELEPHONE_NO_DIGITS.get(valueStr);
                invalidReason.append(message);
                return false;
            }
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (!StaticUtils.isDigit(valueStr.charAt(i))) continue;
            return true;
        }
        Message message = SchemaMessages.ERR_ATTR_SYNTAX_TELEPHONE_NO_DIGITS.get(valueStr);
        invalidReason.append(message);
        return false;
    }

    private boolean isSeparator(char c) {
        switch (c) {
            case ' ': 
            case '-': {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(TelephoneNumberAttributeSyntaxCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(TelephoneNumberAttributeSyntaxCfg configuration) {
        this.currentConfig = configuration;
        this.strictMode = configuration.isStrictFormat();
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }
}

