/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class UTCTimeSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static Object dateFormatLock;
    private static SimpleDateFormat dateFormat;
    private static Date datum1900;
    private static Date datum2000;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.27");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.27", "UTCTime"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.28");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.28", "UTCTime"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "UTCTime"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "UTCTime";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.53";
    }

    @Override
    public String getDescription() {
        return "UTC Time";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        String valueString = value.toString().toUpperCase();
        int length = valueString.length();
        if (length < 11) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_TOO_SHORT.get(valueString);
            invalidReason.append(message);
            return false;
        }
        block56: for (int i = 0; i < 2; ++i) {
            switch (valueString.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block56;
                }
                default: {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_YEAR.get(valueString, String.valueOf(valueString.charAt(i)));
                    invalidReason.append(message);
                    return false;
                }
            }
        }
        char m1 = valueString.charAt(2);
        char m2 = valueString.charAt(3);
        block3 : switch (m1) {
            case '0': {
                switch (m2) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block3;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MONTH.get(valueString, valueString.substring(2, 4));
                invalidReason.append(message);
                return false;
            }
            case '1': {
                switch (m2) {
                    case '0': 
                    case '1': 
                    case '2': {
                        break block3;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MONTH.get(valueString, valueString.substring(2, 4));
                invalidReason.append(message);
                return false;
            }
            default: {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MONTH.get(valueString, valueString.substring(2, 4));
                invalidReason.append(message);
                return false;
            }
        }
        char d1 = valueString.charAt(4);
        char d2 = valueString.charAt(5);
        block13 : switch (d1) {
            case '0': {
                switch (d2) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block13;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_DAY.get(valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
            case '1': 
            case '2': {
                switch (d2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block13;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_DAY.get(valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
            case '3': {
                switch (d2) {
                    case '0': 
                    case '1': {
                        break block13;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_DAY.get(valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
            default: {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_DAY.get(valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
        }
        char h1 = valueString.charAt(6);
        char h2 = valueString.charAt(7);
        block27 : switch (h1) {
            case '0': 
            case '1': {
                switch (h2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block27;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_HOUR.get(valueString, valueString.substring(6, 8));
                invalidReason.append(message);
                return false;
            }
            case '2': {
                switch (h2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block27;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_HOUR.get(valueString, valueString.substring(6, 8));
                invalidReason.append(message);
                return false;
            }
            default: {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_HOUR.get(valueString, valueString.substring(6, 8));
                invalidReason.append(message);
                return false;
            }
        }
        m1 = valueString.charAt(8);
        block37 : switch (m1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 11) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(m1), 8);
                    invalidReason.append(message);
                    return false;
                }
                switch (valueString.charAt(9)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block37;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_MINUTE.get(valueString, valueString.substring(8, 10));
                invalidReason.append(message);
                return false;
            }
            default: {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(m1), 8);
                invalidReason.append(message);
                return false;
            }
        }
        char s1 = valueString.charAt(10);
        block43 : switch (s1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 13) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 10);
                    invalidReason.append(message);
                    return false;
                }
                switch (valueString.charAt(11)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block43;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_SECOND.get(valueString, valueString.substring(10, 12));
                invalidReason.append(message);
                return false;
            }
            case '6': {
                if (length < 13) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 10);
                    invalidReason.append(message);
                    return false;
                }
                if (valueString.charAt(11) == '0') break;
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_SECOND.get(valueString, valueString.substring(10, 12));
                invalidReason.append(message);
                return false;
            }
            case 'Z': {
                if (length == 11) {
                    return true;
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 10);
                invalidReason.append(message);
                return false;
            }
            case '+': 
            case '-': {
                if (length == 15) {
                    return this.hasValidOffset(valueString, 11, invalidReason);
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 10);
                invalidReason.append(message);
                return false;
            }
            default: {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(s1), 10);
                invalidReason.append(message);
                return false;
            }
        }
        switch (valueString.charAt(12)) {
            case 'Z': {
                if (length == 13) {
                    return true;
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(valueString.charAt(12)), 12);
                invalidReason.append(message);
                return false;
            }
            case '+': 
            case '-': {
                if (length == 17 || length == 15) {
                    return this.hasValidOffset(valueString, 13, invalidReason);
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(valueString.charAt(12)), 12);
                invalidReason.append(message);
                return false;
            }
        }
        Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_CHAR.get(valueString, String.valueOf(valueString.charAt(12)), 12);
        invalidReason.append(message);
        return false;
    }

    private boolean hasValidOffset(String value, int startPos, MessageBuilder invalidReason) {
        int offsetLength = value.length() - startPos;
        if (offsetLength < 2) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_TOO_SHORT.get(value);
            invalidReason.append(message);
            return false;
        }
        block0 : switch (value.charAt(startPos)) {
            case '0': 
            case '1': {
                switch (value.charAt(startPos + 1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block0;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET.get(value, value.substring(startPos, startPos + offsetLength));
                invalidReason.append(message);
                return false;
            }
            case '2': {
                switch (value.charAt(startPos + 1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block0;
                    }
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET.get(value, value.substring(startPos, startPos + offsetLength));
                invalidReason.append(message);
                return false;
            }
            default: {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET.get(value, value.substring(startPos, startPos + offsetLength));
                invalidReason.append(message);
                return false;
            }
        }
        if (offsetLength == 4) {
            block10 : switch (value.charAt(startPos + 2)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    switch (value.charAt(startPos + 3)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block10;
                        }
                    }
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET.get(value, value.substring(startPos, startPos + offsetLength));
                    invalidReason.append(message);
                    return false;
                }
                default: {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_INVALID_OFFSET.get(value, value.substring(startPos, startPos + offsetLength));
                    invalidReason.append(message);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeValue createUTCTimeValue(Date d) {
        String valueString;
        Object object = dateFormatLock;
        synchronized (object) {
            valueString = dateFormat.format(d);
        }
        return AttributeValues.create(ByteString.valueOf(valueString), ByteString.valueOf(valueString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date decodeUTCTimeValue(ByteString normalizedValue) throws DirectoryException {
        String valueString = normalizedValue.toString();
        try {
            Object object = dateFormatLock;
            synchronized (object) {
                switch (valueString.charAt(0)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': {
                        dateFormat.set2DigitYearStart(datum2000);
                        break;
                    }
                    default: {
                        dateFormat.set2DigitYearStart(datum1900);
                    }
                }
                return dateFormat.parse(valueString);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UTC_TIME_CANNOT_PARSE.get(valueString, String.valueOf(e));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
        }
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    static {
        dateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(1900, 0, 1);
        datum1900 = cal.getTime();
        cal.clear();
        cal.set(2000, 0, 1);
        datum2000 = cal.getTime();
        dateFormatLock = new Object();
    }
}

