/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

public class ImportTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static Map<String, Message> argDisplayMap = new HashMap<String, Message>();
    private boolean append = false;
    private boolean isCompressed = false;
    private boolean isEncrypted = false;
    private boolean overwrite = false;
    private boolean replaceExisting = false;
    private boolean skipSchemaValidation = false;
    private boolean clearBackend = false;
    private boolean skipDNValidation = false;
    private String tmpDirectory = null;
    private int threadCount = 0;
    private String backendID = null;
    private String rejectFile = null;
    private String skipFile = null;
    private ArrayList<String> excludeAttributeStrings = null;
    private ArrayList<String> excludeBranchStrings = null;
    private ArrayList<String> excludeFilterStrings = null;
    private ArrayList<String> includeAttributeStrings = null;
    private ArrayList<String> includeBranchStrings = null;
    private ArrayList<String> includeFilterStrings = null;
    private ArrayList<String> ldifFiles = null;
    private String templateFile = null;
    private int randomSeed = 0;
    private LDIFImportConfig importConfig;

    @Override
    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_IMPORT_NAME.get();
    }

    @Override
    public Message getAttributeDisplayName(String name) {
        return argDisplayMap.get(name);
    }

    @Override
    public void initializeTask() throws DirectoryException {
        File f;
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.LDIF_IMPORT, operation)) {
            Message message = TaskMessages.ERR_TASK_LDIFIMPORT_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeLdifFile = DirectoryServer.getAttributeType("ds-task-import-ldif-file", true);
        AttributeType typeTemplateFile = DirectoryServer.getAttributeType("ds-task-import-template-file", true);
        AttributeType typeAppend = DirectoryServer.getAttributeType("ds-task-import-append", true);
        AttributeType typeReplaceExisting = DirectoryServer.getAttributeType("ds-task-import-replace-existing", true);
        AttributeType typeBackendID = DirectoryServer.getAttributeType("ds-task-import-backend-id", true);
        AttributeType typeIncludeBranch = DirectoryServer.getAttributeType("ds-task-import-include-branch", true);
        AttributeType typeExcludeBranch = DirectoryServer.getAttributeType("ds-task-import-exclude-branch", true);
        AttributeType typeIncludeAttribute = DirectoryServer.getAttributeType("ds-task-import-include-attribute", true);
        AttributeType typeExcludeAttribute = DirectoryServer.getAttributeType("ds-task-import-exclude-attribute", true);
        AttributeType typeIncludeFilter = DirectoryServer.getAttributeType("ds-task-import-include-filter", true);
        AttributeType typeExcludeFilter = DirectoryServer.getAttributeType("ds-task-import-exclude-filter", true);
        AttributeType typeRejectFile = DirectoryServer.getAttributeType("ds-task-import-reject-file", true);
        AttributeType typeSkipFile = DirectoryServer.getAttributeType("ds-task-import-skip-file", true);
        AttributeType typeOverwrite = DirectoryServer.getAttributeType("ds-task-import-overwrite-rejects", true);
        AttributeType typeSkipSchemaValidation = DirectoryServer.getAttributeType("ds-task-import-skip-schema-validation", true);
        AttributeType typeIsCompressed = DirectoryServer.getAttributeType("ds-task-import-is-compressed", true);
        AttributeType typeIsEncrypted = DirectoryServer.getAttributeType("ds-task-import-is-encrypted", true);
        AttributeType typeClearBackend = DirectoryServer.getAttributeType("ds-task-import-clear-backend", true);
        AttributeType typeRandomSeed = DirectoryServer.getAttributeType("ds-task-import-random-seed", true);
        AttributeType typeThreadCount = DirectoryServer.getAttributeType("ds-task-import-thread-count", true);
        AttributeType typeTmpDirectory = DirectoryServer.getAttributeType("ds-task-import-tmp-directory", true);
        AttributeType typeDNCheckPhase2 = DirectoryServer.getAttributeType("ds-task-import-skip-dn-validation", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeLdifFile);
        ArrayList<String> ldifFilestmp = TaskUtils.getMultiValueString(attrList);
        this.ldifFiles = new ArrayList(ldifFilestmp.size());
        for (String s : ldifFilestmp) {
            File f2 = new File(s);
            if (!f2.isAbsolute()) {
                f2 = new File(DirectoryServer.getInstanceRoot(), s);
                try {
                    s = f2.getCanonicalPath();
                }
                catch (Exception ex) {
                    s = f2.getAbsolutePath();
                }
            }
            if (!f2.canRead()) {
                Message message = ToolMessages.ERR_LDIFIMPORT_LDIF_FILE_DOESNT_EXIST.get(s);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            this.ldifFiles.add(s);
        }
        attrList = taskEntry.getAttribute(typeTemplateFile);
        this.templateFile = TaskUtils.getSingleValueString(attrList);
        if (this.templateFile != null && !(f = new File(this.templateFile)).isAbsolute()) {
            this.templateFile = new File(DirectoryServer.getInstanceRoot(), this.templateFile).getAbsolutePath();
        }
        attrList = taskEntry.getAttribute(typeAppend);
        this.append = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeDNCheckPhase2);
        this.skipDNValidation = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeTmpDirectory);
        this.tmpDirectory = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeReplaceExisting);
        this.replaceExisting = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeBackendID);
        this.backendID = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeIncludeBranch);
        this.includeBranchStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeExcludeBranch);
        this.excludeBranchStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeIncludeAttribute);
        this.includeAttributeStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeExcludeAttribute);
        this.excludeAttributeStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeIncludeFilter);
        this.includeFilterStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeExcludeFilter);
        this.excludeFilterStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeRejectFile);
        this.rejectFile = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeSkipFile);
        this.skipFile = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeOverwrite);
        this.overwrite = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeSkipSchemaValidation);
        this.skipSchemaValidation = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeIsCompressed);
        this.isCompressed = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeIsEncrypted);
        this.isEncrypted = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeClearBackend);
        this.clearBackend = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeRandomSeed);
        this.randomSeed = TaskUtils.getSingleValueInteger(attrList, 0);
        attrList = taskEntry.getAttribute(typeThreadCount);
        this.threadCount = TaskUtils.getSingleValueInteger(attrList, 0);
        if (this.includeBranchStrings.isEmpty() && this.backendID == null) {
            Message message = ToolMessages.ERR_LDIFIMPORT_MISSING_BACKEND_ARGUMENT.get(typeIncludeBranch.getNameOrOID(), typeBackendID.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        Backend backend = null;
        ArrayList<DN> excludeBranches = new ArrayList<DN>(this.excludeBranchStrings.size());
        ArrayList<DN> includeBranches = new ArrayList<DN>(this.includeBranchStrings.size());
        for (String s : this.includeBranchStrings) {
            DN includeBranch;
            try {
                includeBranch = DN.decode(s);
            }
            catch (DirectoryException de) {
                Message message = ToolMessages.ERR_LDIFIMPORT_CANNOT_DECODE_INCLUDE_BASE.get(s, de.getMessageObject());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_LDIFIMPORT_CANNOT_DECODE_INCLUDE_BASE.get(s, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (includeBranches.contains(includeBranch)) continue;
            includeBranches.add(includeBranch);
        }
        for (String s : this.excludeBranchStrings) {
            DN excludeBranch;
            try {
                excludeBranch = DN.decode(s);
            }
            catch (DirectoryException de) {
                Message message = ToolMessages.ERR_LDIFIMPORT_CANNOT_DECODE_EXCLUDE_BASE.get(s, de.getMessageObject());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_LDIFIMPORT_CANNOT_DECODE_EXCLUDE_BASE.get(s, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (excludeBranches.contains(excludeBranch)) continue;
            excludeBranches.add(excludeBranch);
        }
        for (String filterString : this.excludeFilterStrings) {
            try {
                SearchFilter.createFilterFromString(filterString);
            }
            catch (DirectoryException de) {
                Message message = ToolMessages.ERR_LDIFIMPORT_CANNOT_PARSE_EXCLUDE_FILTER.get(filterString, de.getMessageObject());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
        }
        for (String filterString : this.includeFilterStrings) {
            try {
                SearchFilter.createFilterFromString(filterString);
            }
            catch (DirectoryException de) {
                Message message = ToolMessages.ERR_LDIFIMPORT_CANNOT_PARSE_INCLUDE_FILTER.get(filterString, de.getMessageObject());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
        }
        if (this.backendID != null) {
            Message message;
            backend = DirectoryServer.getBackend(this.backendID);
            if (backend == null) {
                message = ToolMessages.ERR_LDIFIMPORT_NO_BACKENDS_FOR_ID.get();
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (!backend.supportsLDIFImport()) {
                message = ToolMessages.ERR_LDIFIMPORT_CANNOT_IMPORT.get(this.backendID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (!this.append && this.includeBranchStrings.isEmpty() && backend.getBaseDNs().length > 1 && !this.clearBackend) {
                StringBuilder builder = new StringBuilder();
                for (DN dn : backend.getBaseDNs()) {
                    builder.append(dn.toNormalizedString());
                    builder.append(" ");
                }
                Message message2 = ToolMessages.ERR_LDIFIMPORT_MISSING_CLEAR_BACKEND.get(builder.toString(), typeClearBackend.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message2);
            }
        } else {
            for (DN includeBranch : includeBranches) {
                Backend locatedBackend = DirectoryServer.getBackend(includeBranch);
                if (locatedBackend != null) {
                    if (backend == null) {
                        backend = locatedBackend;
                        continue;
                    }
                    if (backend == locatedBackend) continue;
                    Message message = ToolMessages.ERR_LDIFIMPORT_INVALID_INCLUDE_BASE.get(includeBranch.toNormalizedString(), backend.getBackendID());
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                Message message = ToolMessages.ERR_NO_BACKENDS_FOR_BASE.get(includeBranch.toNormalizedString());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
        }
        ArrayList<DN> defaultIncludeBranches = new ArrayList<DN>(backend.getBaseDNs().length);
        for (DN dn : backend.getBaseDNs()) {
            defaultIncludeBranches.add(dn);
        }
        for (DN includeBranch : includeBranches) {
            if (Backend.handlesEntry(includeBranch, defaultIncludeBranches, excludeBranches)) continue;
            Message message = ToolMessages.ERR_LDIFIMPORT_INVALID_INCLUDE_BASE.get(includeBranch.toNormalizedString(), backend.getBackendID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
    }

    @Override
    public void interruptTask(TaskState interruptState, Message interruptReason) {
        if (TaskState.STOPPED_BY_ADMINISTRATOR.equals((Object)interruptState) && this.importConfig != null) {
            this.addLogMessage(TaskMessages.INFO_TASK_STOPPED_BY_ADMIN.get(interruptReason));
            this.setTaskInterruptState(interruptState);
            this.importConfig.cancel();
        }
    }

    @Override
    public boolean isInterruptable() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected TaskState runTask() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[TRYBLOCK]], but top level block is 60[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        argDisplayMap.put("ds-task-import-ldif-file", TaskMessages.INFO_IMPORT_ARG_LDIF_FILE.get());
        argDisplayMap.put("ds-task-import-template-file", TaskMessages.INFO_IMPORT_ARG_TEMPLATE_FILE.get());
        argDisplayMap.put("ds-task-import-random-seed", TaskMessages.INFO_IMPORT_ARG_RANDOM_SEED.get());
        argDisplayMap.put("ds-task-import-append", TaskMessages.INFO_IMPORT_ARG_APPEND.get());
        argDisplayMap.put("ds-task-import-replace-existing", TaskMessages.INFO_IMPORT_ARG_REPLACE_EXISTING.get());
        argDisplayMap.put("ds-task-import-backend-id", TaskMessages.INFO_IMPORT_ARG_BACKEND_ID.get());
        argDisplayMap.put("ds-task-import-include-branch", TaskMessages.INFO_IMPORT_ARG_INCL_BRANCH.get());
        argDisplayMap.put("ds-task-import-exclude-branch", TaskMessages.INFO_IMPORT_ARG_EXCL_BRANCH.get());
        argDisplayMap.put("ds-task-import-include-attribute", TaskMessages.INFO_IMPORT_ARG_INCL_ATTR.get());
        argDisplayMap.put("ds-task-import-exclude-attribute", TaskMessages.INFO_IMPORT_ARG_EXCL_ATTR.get());
        argDisplayMap.put("ds-task-import-include-filter", TaskMessages.INFO_IMPORT_ARG_INCL_FILTER.get());
        argDisplayMap.put("ds-task-import-exclude-filter", TaskMessages.INFO_IMPORT_ARG_EXCL_FILTER.get());
        argDisplayMap.put("ds-task-import-reject-file", TaskMessages.INFO_IMPORT_ARG_REJECT_FILE.get());
        argDisplayMap.put("ds-task-import-skip-file", TaskMessages.INFO_IMPORT_ARG_SKIP_FILE.get());
        argDisplayMap.put("ds-task-import-overwrite-rejects", TaskMessages.INFO_IMPORT_ARG_OVERWRITE.get());
        argDisplayMap.put("ds-task-import-skip-schema-validation", TaskMessages.INFO_IMPORT_ARG_SKIP_SCHEMA_VALIDATION.get());
        argDisplayMap.put("ds-task-import-is-compressed", TaskMessages.INFO_IMPORT_ARG_IS_COMPRESSED.get());
        argDisplayMap.put("ds-task-import-is-encrypted", TaskMessages.INFO_IMPORT_ARG_IS_ENCRYPTED.get());
        argDisplayMap.put("ds-task-import-clear-backend", TaskMessages.INFO_IMPORT_ARG_CLEAR_BACKEND.get());
    }
}

