/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.SortValuesSet;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.SortKey;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

public class DBTest {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final PrintStream err;
    private final PrintStream out;
    private boolean globalArgumentsInitialized = false;
    private final SubCommandArgumentParser parser;
    private BooleanArgument showUsageArgument;
    private StringArgument configClass;
    private StringArgument configFile;
    private boolean subCommandsInitialized = false;

    public static void main(String[] args) {
        int exitCode = DBTest.main(args, true, System.out, System.err);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    public static int main(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        DBTest app = new DBTest(outStream, errStream);
        return app.run(args, initializeServer);
    }

    public DBTest(OutputStream out, OutputStream err) {
        this.out = out != null ? new PrintStream(out) : NullOutputStream.printStream();
        this.err = err != null ? new PrintStream(err) : NullOutputStream.printStream();
        Message toolDescription = ToolMessages.INFO_DESCRIPTION_DBTEST_TOOL.get();
        this.parser = new SubCommandArgumentParser(this.getClass().getName(), toolDescription, false);
    }

    private void displayMessageAndUsageReference(Message message) {
        this.printMessage(message);
        this.printMessage(Message.EMPTY);
        this.printMessage(this.parser.getHelpUsageReference());
    }

    private void initializeGlobalArguments() throws ArgumentException {
        if (!this.globalArgumentsInitialized) {
            this.configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            this.configClass.setHidden(true);
            this.configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            this.configFile.setHidden(true);
            this.showUsageArgument = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            this.parser.addGlobalArgument(this.showUsageArgument);
            this.parser.setUsageArgument(this.showUsageArgument, this.out);
            this.parser.addGlobalArgument(this.configClass);
            this.parser.addGlobalArgument(this.configFile);
            this.globalArgumentsInitialized = true;
        }
    }

    private void initializeSubCommands() throws ArgumentException {
        if (!this.subCommandsInitialized) {
            SubCommand sub = new SubCommand(this.parser, "list-root-containers", ToolMessages.INFO_DESCRIPTION_DBTEST_SUBCMD_LIST_ROOT_CONTAINERS.get());
            sub = new SubCommand(this.parser, "list-entry-containers", ToolMessages.INFO_DESCRIPTION_DBTEST_SUBCMD_LIST_ENTRY_CONTAINERS.get());
            StringArgument backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BACKEND_ID.get());
            sub.addArgument(backendID);
            sub = new SubCommand(this.parser, "list-database-containers", ToolMessages.INFO_DESCRIPTION_DBTEST_SUBCMD_LIST_DATABASE_CONTAINERS.get());
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BACKEND_ID.get());
            sub.addArgument(backendID);
            StringArgument baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, false, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BASE_DN.get());
            sub.addArgument(baseDN);
            sub = new SubCommand(this.parser, "dump-database-container", ToolMessages.INFO_DESCRIPTION_DBTEST_SUBCMD_DUMP_DATABASE_CONTAINER.get());
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BACKEND_ID.get());
            sub.addArgument(backendID);
            baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", true, false, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BASE_DN.get());
            sub.addArgument(baseDN);
            StringArgument databaseName = new StringArgument("databasename", Character.valueOf('d'), "databaseName", true, false, true, ToolMessages.INFO_DATABASE_NAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_DATABASE_NAME.get());
            sub.addArgument(databaseName);
            BooleanArgument skipDecode = new BooleanArgument("skipdecode", Character.valueOf('p'), "skipDecode", ToolMessages.INFO_DESCRIPTION_DBTEST_SKIP_DECODE.get());
            sub.addArgument(skipDecode);
            BooleanArgument statsOnly = new BooleanArgument("statsonly", Character.valueOf('q'), "statsOnly", ToolMessages.INFO_DESCRIPTION_DBTEST_STATS_ONLY.get());
            sub.addArgument(statsOnly);
            StringArgument maxKeyValue = new StringArgument("maxkeyvalue", Character.valueOf('K'), "maxKeyValue", false, false, true, ToolMessages.INFO_MAX_KEY_VALUE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_MAX_KEY_VALUE.get());
            sub.addArgument(maxKeyValue);
            StringArgument minKeyValue = new StringArgument("minkeyvalue", Character.valueOf('k'), "minKeyValue", false, false, true, ToolMessages.INFO_MIN_KEY_VALUE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_MIN_KEY_VALUE.get());
            sub.addArgument(minKeyValue);
            IntegerArgument maxDataSize = new IntegerArgument("maxdatasize", Character.valueOf('S'), "maxDataSize", false, false, true, ToolMessages.INFO_MAX_DATA_SIZE_PLACEHOLDER.get(), -1, null, ToolMessages.INFO_DESCRIPTION_DBTEST_MAX_DATA_SIZE.get());
            sub.addArgument(maxDataSize);
            IntegerArgument minDataSize = new IntegerArgument("mindatasize", Character.valueOf('s'), "minDataSize", false, false, true, ToolMessages.INFO_MIN_DATA_SIZE_PLACEHOLDER.get(), -1, null, ToolMessages.INFO_DESCRIPTION_DBTEST_MIN_DATA_SIZE.get());
            sub.addArgument(minDataSize);
            sub = new SubCommand(this.parser, "list-index-status", ToolMessages.INFO_DESCRIPTION_DBTEST_SUBCMD_LIST_INDEX_STATUS.get());
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BACKEND_ID.get());
            sub.addArgument(backendID);
            baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", true, true, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_DBTEST_BASE_DN.get());
            sub.addArgument(baseDN);
            this.subCommandsInitialized = true;
        }
    }

    private int run(String[] args, boolean initializeServer) {
        try {
            this.initializeGlobalArguments();
            this.initializeSubCommands();
        }
        catch (ArgumentException e) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(e.getMessage());
            this.printMessage(message);
            return 1;
        }
        try {
            this.parser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.parser.usageOrVersionDisplayed()) {
            return 0;
        }
        try {
            BuildVersion.checkVersionMismatch();
        }
        catch (InitializationException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.printMessage(e.getMessageObject());
            return 1;
        }
        if (initializeServer) {
            DirectoryServer directoryServer = DirectoryServer.getInstance();
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                this.printMessage(message);
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(this.configClass.getValue(), this.configFile.getValue());
            }
            catch (InitializationException ie) {
                Message message = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ie.getMessage());
                this.printMessage(message);
                return 1;
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(e));
                this.printMessage(message);
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                Message message = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ce.getMessage());
                this.printMessage(message);
                return 1;
            }
            catch (InitializationException ie) {
                Message message = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ie.getMessage());
                this.printMessage(message);
                return 1;
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
                this.printMessage(message);
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                Message message = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ce.getMessage());
                this.printMessage(message);
                return 1;
            }
            catch (InitializationException ie) {
                Message message = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ie.getMessage());
                this.printMessage(message);
                return 1;
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(StaticUtils.getExceptionMessage(e));
                this.printMessage(message);
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                Message message = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ce.getMessage());
                this.printMessage(message);
                return 1;
            }
            catch (InitializationException ie) {
                Message message = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ie.getMessage());
                this.printMessage(message);
                return 1;
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(StaticUtils.getExceptionMessage(e));
                this.printMessage(message);
                return 1;
            }
        }
        if (this.parser.getSubCommand() == null) {
            Message message = ToolMessages.ERR_DBTEST_MISSING_SUBCOMMAND.get();
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        SubCommand subCommand = this.parser.getSubCommand();
        try {
            if (subCommand.getName().equals("list-root-containers")) {
                return this.listRootContainers();
            }
            if (subCommand.getName().equals("list-entry-containers")) {
                return this.listEntryContainers(subCommand.getArgument("backendid"));
            }
            if (subCommand.getName().equals("list-database-containers")) {
                return this.listDatabaseContainers(subCommand.getArgument("backendid"), subCommand.getArgument("basedn"));
            }
            if (subCommand.getName().equals("dump-database-container")) {
                return this.dumpDatabaseContainer(subCommand.getArgument("backendid"), subCommand.getArgument("basedn"), subCommand.getArgument("databasename"), subCommand.getArgument("skipdecode"), subCommand.getArgument("statsonly"), subCommand.getArgument("maxkeyvalue"), subCommand.getArgument("minkeyvalue"), subCommand.getArgument("maxdatasize"), subCommand.getArgument("mindatasize"));
            }
            if (subCommand.getName().equals("list-index-status")) {
                return this.listIndexStatus(subCommand.getArgument("backendid"), subCommand.getArgument("basedn"));
            }
            return 0;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.printMessage(Message.raw(StaticUtils.stackTraceToString(e), new Object[0]));
            return 1;
        }
    }

    private int listRootContainers() {
        Map<LocalDBBackendCfg, BackendImpl> jeBackends = this.getJEBackends();
        int count = 0;
        TableBuilder builder = new TableBuilder();
        builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_BACKEND_ID.get());
        builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_DB_DIRECTORY.get());
        for (Map.Entry<LocalDBBackendCfg, BackendImpl> backend : jeBackends.entrySet()) {
            builder.startRow();
            builder.appendCell(backend.getValue().getBackendID());
            builder.appendCell(backend.getKey().getDBDirectory());
            ++count;
        }
        TextTablePrinter printer = new TextTablePrinter(this.out);
        builder.print(printer);
        this.out.format("%nTotal: %d%n", count);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int listEntryContainers(Argument backendID) {
        RootContainer rc;
        Map<LocalDBBackendCfg, BackendImpl> jeBackends = this.getJEBackends();
        Backend backend = null;
        for (BackendImpl b : jeBackends.values()) {
            if (!b.getBackendID().equalsIgnoreCase(backendID.getValue())) continue;
            backend = b;
            break;
        }
        if (backend == null) {
            this.printMessage(ToolMessages.ERR_DBTEST_NO_BACKENDS_FOR_ID.get(backendID.getValue()));
            return 1;
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                this.printMessage(message);
                return 1;
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.printMessage(message);
            return 1;
        }
        try {
            rc = ((BackendImpl)backend).getReadOnlyRootContainer();
        }
        catch (Exception e) {
            this.printMessage(ToolMessages.ERR_DBTEST_ERROR_INITIALIZING_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e)));
            return 1;
        }
        try {
            TableBuilder builder = new TableBuilder();
            int count = 0;
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_BASE_DN.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_JE_DATABASE_PREFIX.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_ENTRY_COUNT.get());
            for (EntryContainer ec : rc.getEntryContainers()) {
                builder.startRow();
                builder.appendCell(ec.getBaseDN().toNormalizedString());
                builder.appendCell(ec.getDatabasePrefix());
                builder.appendCell(ec.getEntryCount());
                ++count;
            }
            TextTablePrinter printer = new TextTablePrinter(this.out);
            builder.print(printer);
            this.out.format("%nTotal: %d%n", count);
            int ec = 0;
            return ec;
        }
        catch (DatabaseException de) {
            this.printMessage(ToolMessages.ERR_DBTEST_ERROR_READING_DATABASE.get(StaticUtils.stackTraceToSingleLineString(de)));
            int n = 1;
            return n;
        }
        finally {
            try {
                rc.close();
            }
            catch (DatabaseException printer) {}
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                    this.printMessage(message);
                }
            }
            catch (Exception e) {
                Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
                this.printMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int listDatabaseContainers(Argument backendID, Argument baseDN) {
        RootContainer rc;
        Map<LocalDBBackendCfg, BackendImpl> jeBackends = this.getJEBackends();
        Backend backend = null;
        DN base = null;
        for (BackendImpl b : jeBackends.values()) {
            if (!b.getBackendID().equalsIgnoreCase(backendID.getValue())) continue;
            backend = b;
            break;
        }
        if (backend == null) {
            this.printMessage(ToolMessages.ERR_DBTEST_NO_BACKENDS_FOR_ID.get(backendID.getValue()));
            return 1;
        }
        if (baseDN.isPresent()) {
            try {
                base = DN.decode(baseDN.getValue());
            }
            catch (DirectoryException de) {
                this.printMessage(ToolMessages.ERR_DBTEST_DECODE_BASE_DN.get(baseDN.getValue(), StaticUtils.getExceptionMessage(de)));
                return 1;
            }
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                this.printMessage(message);
                return 1;
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.printMessage(message);
            return 1;
        }
        try {
            rc = ((BackendImpl)backend).getReadOnlyRootContainer();
        }
        catch (Exception e) {
            this.printMessage(ToolMessages.ERR_DBTEST_ERROR_INITIALIZING_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e)));
            return 1;
        }
        try {
            TableBuilder builder = new TableBuilder();
            int count = 0;
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_DATABASE_NAME.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_DATABASE_TYPE.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_JE_DATABASE_NAME.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_ENTRY_COUNT.get());
            if (base != null) {
                EntryContainer ec = rc.getEntryContainer(base);
                if (ec == null) {
                    this.printMessage(ToolMessages.ERR_DBTEST_NO_ENTRY_CONTAINERS_FOR_BASE_DN.get(base.toNormalizedString(), backend.getBackendID()));
                    int n = 1;
                    return n;
                }
                ArrayList<DatabaseContainer> databaseContainers = new ArrayList<DatabaseContainer>();
                ec.listDatabases(databaseContainers);
                for (DatabaseContainer dc : databaseContainers) {
                    builder.startRow();
                    builder.appendCell(dc.getName().replace(ec.getDatabasePrefix() + "_", ""));
                    builder.appendCell(dc.getClass().getSimpleName());
                    builder.appendCell(dc.getName());
                    builder.appendCell(dc.getRecordCount());
                    ++count;
                }
            } else {
                for (EntryContainer ec : rc.getEntryContainers()) {
                    builder.startRow();
                    ArrayList<DatabaseContainer> databaseContainers = new ArrayList<DatabaseContainer>();
                    ec.listDatabases(databaseContainers);
                    builder.appendCell("Base DN: " + ec.getBaseDN().toNormalizedString());
                    for (DatabaseContainer dc : databaseContainers) {
                        builder.startRow();
                        builder.appendCell(dc.getName().replace(ec.getDatabasePrefix() + "_", ""));
                        builder.appendCell(dc.getClass().getSimpleName());
                        builder.appendCell(dc.getName());
                        builder.appendCell(dc.getRecordCount());
                        ++count;
                    }
                }
            }
            TextTablePrinter printer = new TextTablePrinter(this.out);
            builder.print(printer);
            this.out.format("%nTotal: %d%n", count);
            int ec = 0;
            return ec;
        }
        catch (DatabaseException de) {
            this.printMessage(ToolMessages.ERR_DBTEST_ERROR_READING_DATABASE.get(StaticUtils.stackTraceToSingleLineString(de)));
            int n = 1;
            return n;
        }
        finally {
            try {
                rc.close();
            }
            catch (DatabaseException printer) {}
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                    this.printMessage(message);
                }
            }
            catch (Exception e) {
                Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
                this.printMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int listIndexStatus(Argument backendID, Argument baseDN) {
        RootContainer rc;
        Map<LocalDBBackendCfg, BackendImpl> jeBackends = this.getJEBackends();
        Backend backend = null;
        DN base = null;
        for (BackendImpl b : jeBackends.values()) {
            if (!b.getBackendID().equalsIgnoreCase(backendID.getValue())) continue;
            backend = b;
            break;
        }
        if (backend == null) {
            this.printMessage(ToolMessages.ERR_DBTEST_NO_BACKENDS_FOR_ID.get(backendID.getValue()));
            return 1;
        }
        if (baseDN.isPresent()) {
            try {
                base = DN.decode(baseDN.getValue());
            }
            catch (DirectoryException de) {
                this.printMessage(ToolMessages.ERR_DBTEST_DECODE_BASE_DN.get(baseDN.getValue(), StaticUtils.getExceptionMessage(de)));
                return 1;
            }
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                this.printMessage(message);
                return 1;
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.printMessage(message);
            return 1;
        }
        try {
            rc = ((BackendImpl)backend).getReadOnlyRootContainer();
        }
        catch (Exception e) {
            this.printMessage(ToolMessages.ERR_DBTEST_ERROR_INITIALIZING_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e)));
            return 1;
        }
        try {
            TableBuilder builder = new TableBuilder();
            int count = 0;
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_INDEX_NAME.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_INDEX_TYPE.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_JE_DATABASE_NAME.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_INDEX_STATUS.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_JE_RECORD_COUNT.get());
            builder.appendHeading(ToolMessages.INFO_LABEL_DBTEST_INDEX_UNDEFINED_RECORD_COUNT.get());
            builder.appendHeading(Message.raw("95%", new Object[0]));
            builder.appendHeading(Message.raw("90%", new Object[0]));
            builder.appendHeading(Message.raw("85%", new Object[0]));
            EntryContainer ec = rc.getEntryContainer(base);
            if (ec == null) {
                this.printMessage(ToolMessages.ERR_DBTEST_NO_ENTRY_CONTAINERS_FOR_BASE_DN.get(base.toNormalizedString(), backend.getBackendID()));
                int n = 1;
                return n;
            }
            ArrayList<DatabaseContainer> databaseContainers = new ArrayList<DatabaseContainer>();
            HashMap<Index, StringBuilder> undefinedKeys = new HashMap<Index, StringBuilder>();
            ec.listDatabases(databaseContainers);
            for (DatabaseContainer dc : databaseContainers) {
                if (!(dc instanceof Index) && !(dc instanceof VLVIndex)) continue;
                builder.startRow();
                builder.appendCell(dc.getName().replace(ec.getDatabasePrefix() + "_", ""));
                builder.appendCell(dc.getClass().getSimpleName());
                builder.appendCell(dc.getName());
                if (dc instanceof Index) {
                    builder.appendCell(ec.getState().getIndexTrustState(null, (Index)dc));
                } else if (dc instanceof VLVIndex) {
                    builder.appendCell(ec.getState().getIndexTrustState(null, (VLVIndex)dc));
                }
                builder.appendCell(dc.getRecordCount());
                if (dc instanceof Index) {
                    Index index = (Index)dc;
                    long undefined = 0L;
                    long ninetyFive = 0L;
                    long ninety = 0L;
                    long eighty = 0L;
                    DatabaseEntry key = new DatabaseEntry();
                    DatabaseEntry data = new DatabaseEntry();
                    LockMode lockMode = LockMode.DEFAULT;
                    Cursor cursor = dc.openCursor(null, CursorConfig.DEFAULT);
                    OperationStatus status = cursor.getFirst(key, data, lockMode);
                    while (status == OperationStatus.SUCCESS) {
                        byte[] bytes = data.getData();
                        if (bytes.length == 0 || (bytes[0] & 0x80) == 128) {
                            ++undefined;
                            StringBuilder keyList = (StringBuilder)undefinedKeys.get(index);
                            if (keyList == null) {
                                keyList = new StringBuilder();
                                undefinedKeys.put(index, keyList);
                            } else {
                                keyList.append(" ");
                            }
                            if (index == ec.getID2Children() || index == ec.getID2Subtree()) {
                                keyList.append("[").append(JebFormat.entryIDFromDatabase(key.getData())).append("]");
                            } else {
                                keyList.append("[").append(new String(key.getData())).append("]");
                            }
                        } else {
                            double percentFull = (double)bytes.length / 8.0 / (double)index.getIndexEntryLimit();
                            if (percentFull >= 0.8) {
                                if (percentFull < 0.9) {
                                    ++eighty;
                                } else if (percentFull < 0.95) {
                                    ++ninety;
                                } else {
                                    ++ninetyFive;
                                }
                            }
                        }
                        status = cursor.getNext(key, data, lockMode);
                    }
                    builder.appendCell(undefined);
                    builder.appendCell(ninetyFive);
                    builder.appendCell(ninety);
                    builder.appendCell(eighty);
                    cursor.close();
                } else {
                    builder.appendCell("-");
                    builder.appendCell("-");
                    builder.appendCell("-");
                    builder.appendCell("-");
                }
                ++count;
            }
            TextTablePrinter printer = new TextTablePrinter(this.out);
            builder.print(printer);
            this.out.format("%nTotal: %d%n", count);
            for (Map.Entry e : undefinedKeys.entrySet()) {
                this.out.format("%nIndex: %s%n", ((Index)e.getKey()).getName().replace(ec.getDatabasePrefix() + "_", ""));
                this.out.format("Undefined keys: %s%n", ((StringBuilder)e.getValue()).toString());
            }
            int n = 0;
            return n;
        }
        catch (DatabaseException de) {
            this.printMessage(ToolMessages.ERR_DBTEST_ERROR_READING_DATABASE.get(StaticUtils.stackTraceToSingleLineString(de)));
            int n = 1;
            return n;
        }
        finally {
            try {
                rc.close();
            }
            catch (DatabaseException ec) {}
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                    this.printMessage(message);
                }
            }
            catch (Exception e) {
                Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
                this.printMessage(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dumpDatabaseContainer(Argument backendID, Argument baseDN, Argument databaseName, Argument skipDecode, Argument statsOnly, Argument maxKeyValue, Argument minKeyValue, Argument maxDataSize, Argument minDataSize) {
        RootContainer rc;
        Map<LocalDBBackendCfg, BackendImpl> jeBackends = this.getJEBackends();
        BackendImpl backend = null;
        DN base = null;
        for (BackendImpl b : jeBackends.values()) {
            if (!b.getBackendID().equalsIgnoreCase(backendID.getValue())) continue;
            backend = b;
            break;
        }
        if (backend == null) {
            this.printMessage(ToolMessages.ERR_DBTEST_NO_BACKENDS_FOR_ID.get(backendID.getValue()));
            return 1;
        }
        try {
            base = DN.decode(baseDN.getValue());
        }
        catch (DirectoryException de) {
            this.printMessage(ToolMessages.ERR_DBTEST_DECODE_BASE_DN.get(baseDN.getValue(), StaticUtils.getExceptionMessage(de)));
            return 1;
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                this.printMessage(message);
                return 1;
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_DBTEST_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.printMessage(message);
            return 1;
        }
        try {
            rc = backend.getReadOnlyRootContainer();
        }
        catch (Exception e) {
            this.printMessage(ToolMessages.ERR_DBTEST_ERROR_INITIALIZING_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e)));
            return 1;
        }
        try {
            EntryContainer ec = rc.getEntryContainer(base);
            if (ec == null) {
                this.printMessage(ToolMessages.ERR_DBTEST_NO_ENTRY_CONTAINERS_FOR_BASE_DN.get(base.toNormalizedString(), backend.getBackendID()));
                int message = 1;
                return message;
            }
            DatabaseContainer databaseContainer = null;
            ArrayList<DatabaseContainer> databaseContainers = new ArrayList<DatabaseContainer>();
            ec.listDatabases(databaseContainers);
            for (DatabaseContainer dc : databaseContainers) {
                if (!dc.getName().replace(ec.getDatabasePrefix() + "_", "").equalsIgnoreCase(databaseName.getValue())) continue;
                databaseContainer = dc;
                break;
            }
            if (databaseContainer == null) {
                this.printMessage(ToolMessages.ERR_DBTEST_NO_DATABASE_CONTAINERS_FOR_NAME.get(databaseName.getValue(), base.toNormalizedString(), backend.getBackendID()));
                int i$ = 1;
                return i$;
            }
            int count = 0;
            long totalKeySize = 0L;
            long totalDataSize = 0L;
            int indent = 4;
            Cursor cursor = databaseContainer.openCursor(null, CursorConfig.DEFAULT);
            try {
                OperationStatus status;
                ByteStringBuilder builder2;
                byte[] vBytes;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                LockMode lockMode = LockMode.DEFAULT;
                AttributeIndex.KeyComparator defaultComparator = new AttributeIndex.KeyComparator();
                byte[] start = null;
                byte[] end = null;
                int minSize = -1;
                int maxSize = -1;
                if (maxDataSize.isPresent()) {
                    try {
                        maxSize = maxDataSize.getIntValue();
                    }
                    catch (Exception e) {
                        this.printMessage(ToolMessages.ERR_DBTEST_CANNOT_DECODE_SIZE.get(maxDataSize.getValue(), StaticUtils.getExceptionMessage(e)));
                        int n = 1;
                        cursor.close();
                        try {
                            rc.close();
                        }
                        catch (DatabaseException databaseException) {
                            // empty catch block
                        }
                        try {
                            String lockFile = LockFileManager.getBackendLockFileName(backend);
                            StringBuilder failureReason = new StringBuilder();
                            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                                Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                                this.printMessage(message);
                            }
                        }
                        catch (Exception e2) {
                            Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e2));
                            this.printMessage(message);
                        }
                        return n;
                    }
                }
                if (minDataSize.isPresent()) {
                    try {
                        minSize = minDataSize.getIntValue();
                    }
                    catch (Exception e) {
                        this.printMessage(ToolMessages.ERR_DBTEST_CANNOT_DECODE_SIZE.get(minDataSize.getValue(), StaticUtils.getExceptionMessage(e)));
                        int n = 1;
                        cursor.close();
                        try {
                            rc.close();
                        }
                        catch (DatabaseException e2) {
                            // empty catch block
                        }
                        try {
                            String lockFile = LockFileManager.getBackendLockFileName(backend);
                            StringBuilder failureReason = new StringBuilder();
                            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                                Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                                this.printMessage(message);
                            }
                        }
                        catch (Exception e3) {
                            Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e3));
                            this.printMessage(message);
                        }
                        return n;
                    }
                }
                if (minKeyValue.isPresent()) {
                    try {
                        if (minKeyValue.getValue().startsWith("0x")) {
                            start = StaticUtils.hexStringToByteArray(minKeyValue.getValue().substring(2));
                        } else if (databaseContainer instanceof DN2ID || databaseContainer instanceof DN2URI) {
                            start = StaticUtils.getBytes(DN.decode(minKeyValue.getValue()).toNormalizedString());
                        } else if (databaseContainer instanceof ID2Entry) {
                            start = JebFormat.entryIDToDatabase(Long.parseLong(minKeyValue.getValue()));
                        } else if (databaseContainer instanceof VLVIndex) {
                            vBytes = StaticUtils.getBytes(minKeyValue.getValue());
                            builder2 = new ByteStringBuilder();
                            builder2.appendBERLength(vBytes.length);
                            builder2.append(vBytes);
                            start = builder2.toByteArray();
                        } else {
                            start = StaticUtils.getBytes(minKeyValue.getValue());
                        }
                    }
                    catch (Exception e) {
                        this.printMessage(ToolMessages.ERR_DBTEST_CANNOT_DECODE_KEY.get(minKeyValue.getValue(), StaticUtils.getExceptionMessage(e)));
                        int builder2 = 1;
                        cursor.close();
                        try {
                            rc.close();
                        }
                        catch (DatabaseException e3) {
                            // empty catch block
                        }
                        try {
                            String lockFile = LockFileManager.getBackendLockFileName(backend);
                            StringBuilder failureReason = new StringBuilder();
                            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                                Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                                this.printMessage(message);
                            }
                        }
                        catch (Exception e4) {
                            Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e4));
                            this.printMessage(message);
                        }
                        return builder2;
                    }
                }
                if (maxKeyValue.isPresent()) {
                    try {
                        if (maxKeyValue.getValue().startsWith("0x")) {
                            end = StaticUtils.hexStringToByteArray(maxKeyValue.getValue().substring(2));
                        } else if (databaseContainer instanceof DN2ID || databaseContainer instanceof DN2URI) {
                            end = StaticUtils.getBytes(DN.decode(maxKeyValue.getValue()).toNormalizedString());
                        } else if (databaseContainer instanceof ID2Entry) {
                            end = JebFormat.entryIDToDatabase(Long.parseLong(maxKeyValue.getValue()));
                        } else if (databaseContainer instanceof VLVIndex) {
                            vBytes = StaticUtils.getBytes(maxKeyValue.getValue());
                            builder2 = new ByteStringBuilder();
                            builder2.appendBERLength(vBytes.length);
                            builder2.append(vBytes);
                            start = builder2.toByteArray();
                        } else {
                            end = StaticUtils.getBytes(maxKeyValue.getValue());
                        }
                    }
                    catch (Exception e) {
                        this.printMessage(ToolMessages.ERR_DBTEST_CANNOT_DECODE_KEY.get(maxKeyValue.getValue(), StaticUtils.getExceptionMessage(e)));
                        int builder3 = 1;
                        cursor.close();
                        try {
                            rc.close();
                        }
                        catch (DatabaseException e4) {
                            // empty catch block
                        }
                        try {
                            String lockFile = LockFileManager.getBackendLockFileName(backend);
                            StringBuilder failureReason = new StringBuilder();
                            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                                Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                                this.printMessage(message);
                            }
                        }
                        catch (Exception e5) {
                            Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e5));
                            this.printMessage(message);
                        }
                        return builder3;
                    }
                }
                if (start != null) {
                    key.setData(start);
                    status = cursor.getSearchKey(key, data, lockMode);
                } else {
                    status = cursor.getFirst(key, data, lockMode);
                }
                while (status == OperationStatus.SUCCESS) {
                    if (minSize > 0 && data.getSize() < minSize || maxSize > 0 && data.getSize() > maxSize) {
                        status = cursor.getNext(key, data, lockMode);
                        continue;
                    }
                    if (end != null) {
                        if (databaseContainer instanceof DN2ID) {
                            if (defaultComparator.compare(key.getData(), end) > 0) {
                                break;
                            }
                        } else if (databaseContainer instanceof DN2URI) {
                            if (defaultComparator.compare(key.getData(), end) > 0) {
                                break;
                            }
                        } else if (databaseContainer instanceof Index) {
                            if (((Index)databaseContainer).indexer.getComparator().compare(key.getData(), end) > 0) {
                                break;
                            }
                        } else if (databaseContainer instanceof VLVIndex ? ((VLVIndex)databaseContainer).comparator.compare(key.getData(), end) > 0 : defaultComparator.compare(key.getData(), end) > 0) break;
                    }
                    if (!statsOnly.isPresent()) {
                        Message keyLabel = ToolMessages.INFO_LABEL_DBTEST_KEY.get();
                        Message dataLabel = ToolMessages.INFO_LABEL_DBTEST_DATA.get();
                        String formatedKey = null;
                        String formatedData = null;
                        if (!skipDecode.isPresent()) {
                            if (databaseContainer instanceof DN2ID) {
                                try {
                                    formatedKey = JebFormat.dnFromDNKey(key.getData(), 0, key.getSize(), ec.getBaseDN()).toNormalizedString();
                                    keyLabel = ToolMessages.INFO_LABEL_DBTEST_ENTRY_DN.get();
                                }
                                catch (Exception e) {
                                    Message message = ToolMessages.ERR_DBTEST_DECODE_FAIL.get(StaticUtils.getExceptionMessage(e));
                                    this.printMessage(message);
                                }
                                formatedData = String.valueOf(JebFormat.entryIDFromDatabase(data.getData()));
                                dataLabel = ToolMessages.INFO_LABEL_DBTEST_ENTRY_ID.get();
                            } else if (databaseContainer instanceof ID2Entry) {
                                formatedKey = String.valueOf(JebFormat.entryIDFromDatabase(key.getData()));
                                keyLabel = ToolMessages.INFO_LABEL_DBTEST_ENTRY_ID.get();
                                try {
                                    formatedData = System.getProperty("line.separator") + ID2Entry.entryFromDatabase(ByteString.wrap(data.getData()), ec.getRootContainer().getCompressedSchema()).toLDIFString();
                                    dataLabel = ToolMessages.INFO_LABEL_DBTEST_ENTRY.get();
                                }
                                catch (Exception e) {
                                    Message message = ToolMessages.ERR_DBTEST_DECODE_FAIL.get(StaticUtils.getExceptionMessage(e));
                                    this.printMessage(message);
                                }
                            } else if (databaseContainer instanceof DN2URI) {
                                try {
                                    formatedKey = new String(key.getData());
                                    keyLabel = ToolMessages.INFO_LABEL_DBTEST_ENTRY_DN.get();
                                }
                                catch (Exception e) {
                                    Message message = ToolMessages.ERR_DBTEST_DECODE_FAIL.get(StaticUtils.getExceptionMessage(e));
                                    this.printMessage(message);
                                }
                                formatedData = new String(key.getData());
                                dataLabel = ToolMessages.INFO_LABEL_DBTEST_URI.get();
                            } else if (databaseContainer instanceof Index) {
                                formatedKey = new String(key.getData());
                                keyLabel = ToolMessages.INFO_LABEL_DBTEST_INDEX_VALUE.get();
                                EntryIDSet idSet = new EntryIDSet(key.getData(), data.getData());
                                if (idSet.isDefined()) {
                                    int lineCount = 0;
                                    StringBuilder builder4 = new StringBuilder();
                                    Iterator<EntryID> i = idSet.iterator();
                                    while (i.hasNext()) {
                                        builder4.append(i.next());
                                        if (lineCount == 10) {
                                            builder4.append(System.getProperty("line.separator"));
                                            lineCount = 0;
                                            continue;
                                        }
                                        builder4.append(" ");
                                        ++lineCount;
                                    }
                                    formatedData = builder4.toString();
                                } else {
                                    formatedData = idSet.toString();
                                }
                                dataLabel = ToolMessages.INFO_LABEL_DBTEST_INDEX_ENTRY_ID_LIST.get();
                            } else if (databaseContainer instanceof VLVIndex) {
                                StringBuilder builder5;
                                VLVIndex index = (VLVIndex)databaseContainer;
                                SortKey[] sortKeys = index.sortOrder.getSortKeys();
                                int pos = 0;
                                byte[] keyBytes = key.getData();
                                if (keyBytes.length > 0) {
                                    builder5 = new StringBuilder();
                                    for (SortKey sortKey : sortKeys) {
                                        int valueLength;
                                        if (keyBytes[pos++] != (valueLength = keyBytes[pos] & 0x7F)) {
                                            int numLengthBytes = valueLength;
                                            valueLength = 0;
                                            int k = 0;
                                            while (k < numLengthBytes) {
                                                valueLength = valueLength << 8 | keyBytes[pos] & 0xFF;
                                                ++k;
                                                ++pos;
                                            }
                                        }
                                        byte[] valueBytes = new byte[valueLength];
                                        System.arraycopy(keyBytes, pos, valueBytes, 0, valueLength);
                                        builder5.append(sortKey.getAttributeType().getNameOrOID());
                                        builder5.append(": ");
                                        if (valueBytes.length == 0) {
                                            builder5.append("NULL");
                                        } else {
                                            builder5.append(new String(valueBytes));
                                        }
                                        builder5.append(" ");
                                        pos += valueLength;
                                    }
                                    byte[] entryIDBytes = new byte[8];
                                    System.arraycopy(keyBytes, pos, entryIDBytes, 0, entryIDBytes.length);
                                    long entryID = JebFormat.entryIDFromDatabase(entryIDBytes);
                                    formatedKey = System.getProperty("line.separator") + String.valueOf(entryID) + ": " + builder5.toString();
                                } else {
                                    formatedKey = "UNBOUNDED";
                                }
                                keyLabel = ToolMessages.INFO_LABEL_DBTEST_VLV_INDEX_LAST_SORT_KEYS.get();
                                try {
                                    builder5 = new StringBuilder();
                                    SortValuesSet svs = new SortValuesSet(key.getData(), data.getData(), index);
                                    long[] entryIDs = svs.getEntryIDs();
                                    for (int i = 0; i < entryIDs.length; ++i) {
                                        builder5.append(String.valueOf(entryIDs[i]));
                                        builder5.append(": ");
                                        for (int j = 0; j < sortKeys.length; ++j) {
                                            SortKey sortKey = index.sortOrder.getSortKeys()[j];
                                            ByteString value = svs.getValue(i * sortKeys.length + j);
                                            builder5.append(sortKey.getAttributeType().getNameOrOID());
                                            builder5.append(": ");
                                            if (value == null) {
                                                builder5.append("NULL");
                                            } else if (value.length() == 0) {
                                                builder5.append("SIZE-EXCEEDED");
                                            } else {
                                                builder5.append(value.toString());
                                            }
                                            builder5.append(" ");
                                        }
                                        builder5.append(System.getProperty("line.separator"));
                                    }
                                    formatedData = System.getProperty("line.separator") + builder5.toString();
                                    dataLabel = ToolMessages.INFO_LABEL_DBTEST_INDEX_ENTRY_ID_LIST.get();
                                }
                                catch (Exception e) {
                                    Message message = ToolMessages.ERR_DBTEST_DECODE_FAIL.get(StaticUtils.getExceptionMessage(e));
                                    this.printMessage(message);
                                }
                            }
                        }
                        if (formatedKey == null) {
                            StringBuilder keyBuilder = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii(keyBuilder, key.getData(), indent);
                            formatedKey = System.getProperty("line.separator") + keyBuilder.toString();
                        }
                        if (formatedData == null) {
                            StringBuilder dataBuilder = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii(dataBuilder, data.getData(), indent);
                            formatedData = System.getProperty("line.separator") + dataBuilder.toString();
                        }
                        this.out.format("%s (%d bytes): %s%n", keyLabel, key.getData().length, formatedKey);
                        this.out.format("%s (%d bytes): %s%n%n", dataLabel, data.getData().length, formatedData);
                    }
                    status = cursor.getNext(key, data, lockMode);
                    ++count;
                    totalKeySize += (long)key.getData().length;
                    totalDataSize += (long)data.getData().length;
                }
            }
            finally {
                cursor.close();
            }
            this.out.format("%nTotal Records: %d%n", count);
            if (count > 0) {
                this.out.format("Total / Average Key Size: %d bytes / %d bytes%n", totalKeySize, totalKeySize / (long)count);
                this.out.format("Total / Average Data Size: %d bytes / %d bytes%n", totalDataSize, totalDataSize / (long)count);
            }
            int n = 0;
            return n;
        }
        catch (DatabaseException de) {
            this.printMessage(ToolMessages.ERR_DBTEST_ERROR_READING_DATABASE.get(StaticUtils.stackTraceToSingleLineString(de)));
            int n = 1;
            return n;
        }
        finally {
            try {
                rc.close();
            }
            catch (DatabaseException databaseContainers) {}
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                StringBuilder failureReason = new StringBuilder();
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                    this.printMessage(message);
                }
            }
            catch (Exception e) {
                Message message = ToolMessages.WARN_DBTEST_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
                this.printMessage(message);
            }
        }
    }

    private Map<LocalDBBackendCfg, BackendImpl> getJEBackends() {
        ArrayList<Backend> backendList = new ArrayList<Backend>();
        ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
        ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
        int code = BackendToolUtils.getBackends(backendList, entryList, dnList);
        LinkedHashMap<LocalDBBackendCfg, BackendImpl> jeBackends = new LinkedHashMap<LocalDBBackendCfg, BackendImpl>();
        for (int i = 0; i < backendList.size(); ++i) {
            Backend backend = backendList.get(i);
            if (!(backend instanceof BackendImpl)) continue;
            jeBackends.put((LocalDBBackendCfg)entryList.get(i), (BackendImpl)backend);
        }
        return jeBackends;
    }

    public final void printMessage(Message msg) {
        this.err.println(StaticUtils.wrapText(msg.toString(), ServerConstants.MAX_LINE_WIDTH));
    }
}

