/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.controls.AuthorizationIdentityResponseControl;
import org.opends.server.controls.PasswordExpiringControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.loggers.debug.TraceSettings;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.ConsoleDebugLogPublisher;
import org.opends.server.tools.LDAPAuthenticationHandler;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.tools.SSLConnectionException;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;

public class LDAPConnection {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private String hostName = null;
    private int portNumber = 389;
    private LDAPConnectionOptions connectionOptions = null;
    private LDAPWriter ldapWriter;
    private LDAPReader ldapReader;
    private int versionNumber = 3;
    private final PrintStream out;
    private final PrintStream err;

    public LDAPConnection(String host, int port, LDAPConnectionOptions options) {
        this(host, port, options, System.out, System.err);
    }

    public LDAPConnection(String host, int port, LDAPConnectionOptions options, PrintStream out, PrintStream err) {
        this.hostName = host;
        this.portNumber = port;
        this.connectionOptions = options;
        this.versionNumber = options.getVersionNumber();
        this.out = out;
        this.err = err;
    }

    public void connectToHost(String bindDN, String bindPassword) throws LDAPConnectionException {
        this.connectToHost(bindDN, bindPassword, new AtomicInteger(1));
    }

    public void connectToHost(String bindDN, String bindPassword, AtomicInteger nextMessageID) throws LDAPConnectionException {
        this.connectToHost(bindDN, bindPassword, nextMessageID, 0);
    }

    public void connectToHost(String bindDN, String bindPassword, AtomicInteger nextMessageID, int timeout) throws LDAPConnectionException {
        Socket socket;
        ArrayList<Control> responseControls;
        ArrayList<Control> requestControls;
        block58: {
            Message msg;
            Socket startTLSSocket = null;
            requestControls = new ArrayList<Control>();
            responseControls = new ArrayList<Control>();
            if (this.connectionOptions.isVerbose()) {
                ConsoleDebugLogPublisher publisher = new ConsoleDebugLogPublisher(this.err);
                publisher.addTraceSettings(null, new TraceSettings(DebugLogLevel.VERBOSE));
                DebugLogger.addDebugLogPublisher(publisher);
            }
            if (this.connectionOptions.useStartTLS()) {
                try {
                    startTLSSocket = this.createSocket();
                    this.ldapWriter = new LDAPWriter(startTLSSocket);
                    this.ldapReader = new LDAPReader(startTLSSocket);
                }
                catch (LDAPConnectionException e) {
                    throw e;
                }
                catch (Exception ex) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                    }
                    throw new LDAPConnectionException(Message.raw(ex.getMessage(), new Object[0]), (Throwable)ex);
                }
                ExtendedRequestProtocolOp extendedRequest = new ExtendedRequestProtocolOp("1.3.6.1.4.1.1466.20037");
                LDAPMessage msg2 = new LDAPMessage(nextMessageID.getAndIncrement(), extendedRequest);
                try {
                    this.ldapWriter.writeMessage(msg2);
                    msg2 = this.ldapReader.readMessage();
                }
                catch (LDAPException ex1) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex1);
                    }
                    throw new LDAPConnectionException(Message.raw(ex1.getMessage(), new Object[0]), ex1.getResultCode(), null, ex1);
                }
                catch (Exception ex1) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex1);
                    }
                    throw new LDAPConnectionException(Message.raw(ex1.getMessage(), new Object[0]), (Throwable)ex1);
                }
                ExtendedResponseProtocolOp res = msg2.getExtendedResponseProtocolOp();
                int resultCode = res.getResultCode();
                if (resultCode != 0) {
                    throw new LDAPConnectionException(res.getErrorMessage(), resultCode, res.getErrorMessage(), res.getMatchedDN(), null);
                }
            }
            SSLConnectionFactory sslConnectionFactory = this.connectionOptions.getSSLConnectionFactory();
            try {
                socket = this.createSSLOrBasicSocket(startTLSSocket, sslConnectionFactory);
                this.ldapWriter = new LDAPWriter(socket);
                this.ldapReader = new LDAPReader(socket);
            }
            catch (UnknownHostException uhe) {
                msg = CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get();
                throw new LDAPConnectionException(msg, 91, null, uhe);
            }
            catch (ConnectException ce) {
                msg = CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get();
                throw new LDAPConnectionException(msg, 91, null, ce);
            }
            catch (LDAPConnectionException e) {
                throw e;
            }
            catch (Exception ex2) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex2);
                }
                throw new LDAPConnectionException(Message.raw(ex2.getMessage(), new Object[0]), (Throwable)ex2);
            }
            try {
                socket.setSoLinger(true, 1);
                socket.setReuseAddress(true);
                if (timeout > 0) {
                    socket.setSoTimeout(timeout);
                }
            }
            catch (IOException e) {
                if (!DebugLogger.debugEnabled()) break block58;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        if (this.connectionOptions.getReportAuthzID()) {
            requestControls.add(new LDAPControl("2.16.840.1.113730.3.4.16"));
        }
        if (this.connectionOptions.usePasswordPolicyControl()) {
            requestControls.add(new LDAPControl("1.3.6.1.4.1.42.2.27.8.5.1"));
        }
        LDAPAuthenticationHandler handler = new LDAPAuthenticationHandler(this.ldapReader, this.ldapWriter, this.hostName, nextMessageID);
        try {
            ByteString bindDNBytes = bindDN == null ? ByteString.empty() : ByteString.valueOf(bindDN);
            ByteString bindPW = bindPassword == null ? null : ByteString.valueOf(bindPassword);
            String result = null;
            if (this.connectionOptions.useSASLExternal()) {
                result = handler.doSASLExternal(bindDNBytes, this.connectionOptions.getSASLProperties(), requestControls, responseControls);
            } else if (this.connectionOptions.getSASLMechanism() != null) {
                result = handler.doSASLBind(bindDNBytes, bindPW, this.connectionOptions.getSASLMechanism(), this.connectionOptions.getSASLProperties(), requestControls, responseControls);
            } else if (bindDN != null) {
                result = handler.doSimpleBind(this.versionNumber, bindDNBytes, bindPW, requestControls, responseControls);
            }
            if (result != null) {
                this.out.println(result);
            }
            for (Control c : responseControls) {
                PasswordPolicyWarningType warningType;
                Message message;
                Control control;
                if (c.getOID().equals("2.16.840.1.113730.3.4.15")) {
                    control = c instanceof LDAPControl ? AuthorizationIdentityResponseControl.DECODER.decode(c.isCritical(), ((LDAPControl)c).getValue()) : (AuthorizationIdentityResponseControl)c;
                    Message message2 = ToolMessages.INFO_BIND_AUTHZID_RETURNED.get(((AuthorizationIdentityResponseControl)control).getAuthorizationID());
                    this.out.println(message2);
                    continue;
                }
                if (c.getOID().equals("2.16.840.1.113730.3.4.4")) {
                    Message message3 = ToolMessages.INFO_BIND_PASSWORD_EXPIRED.get();
                    this.out.println(message3);
                    continue;
                }
                if (c.getOID().equals("2.16.840.1.113730.3.4.5")) {
                    control = c instanceof LDAPControl ? PasswordExpiringControl.DECODER.decode(c.isCritical(), ((LDAPControl)c).getValue()) : (PasswordExpiringControl)c;
                    Message timeString = StaticUtils.secondsToTimeString(((PasswordExpiringControl)control).getSecondsUntilExpiration());
                    message = ToolMessages.INFO_BIND_PASSWORD_EXPIRING.get(timeString);
                    this.out.println(message);
                    continue;
                }
                if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
                PasswordPolicyResponseControl pwPolicyControl = c instanceof LDAPControl ? PasswordPolicyResponseControl.DECODER.decode(c.isCritical(), ((LDAPControl)c).getValue()) : (PasswordPolicyResponseControl)c;
                PasswordPolicyErrorType errorType = pwPolicyControl.getErrorType();
                if (errorType != null) {
                    switch (errorType) {
                        case PASSWORD_EXPIRED: {
                            message = ToolMessages.INFO_BIND_PASSWORD_EXPIRED.get();
                            this.out.println(message);
                            break;
                        }
                        case ACCOUNT_LOCKED: {
                            message = ToolMessages.INFO_BIND_ACCOUNT_LOCKED.get();
                            this.out.println(message);
                            break;
                        }
                        case CHANGE_AFTER_RESET: {
                            message = ToolMessages.INFO_BIND_MUST_CHANGE_PASSWORD.get();
                            this.out.println(message);
                        }
                    }
                }
                if ((warningType = pwPolicyControl.getWarningType()) == null) continue;
                switch (warningType) {
                    case TIME_BEFORE_EXPIRATION: {
                        Message timeString = StaticUtils.secondsToTimeString(pwPolicyControl.getWarningValue());
                        Message message4 = ToolMessages.INFO_BIND_PASSWORD_EXPIRING.get(timeString);
                        this.out.println(message4);
                        break;
                    }
                    case GRACE_LOGINS_REMAINING: {
                        Message message4 = ToolMessages.INFO_BIND_GRACE_LOGINS_REMAINING.get(pwPolicyControl.getWarningValue());
                        this.out.println(message4);
                    }
                }
            }
        }
        catch (ClientException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            throw new LDAPConnectionException(ce.getMessageObject(), ce.getExitCode(), null, ce);
        }
        catch (LDAPException le) {
            throw new LDAPConnectionException(le.getMessageObject(), le.getResultCode(), le.getErrorMessage(), le.getMatchedDN(), le.getCause());
        }
        catch (DirectoryException de) {
            throw new LDAPConnectionException(de.getMessageObject(), de.getResultCode().getIntValue(), null, de.getMatchedDN(), de.getCause());
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new LDAPConnectionException(Message.raw(ex.getLocalizedMessage(), new Object[0]), (Throwable)ex);
        }
        finally {
            block60: {
                if (timeout > 0) {
                    try {
                        socket.setSoTimeout(0);
                    }
                    catch (SocketException e) {
                        e.printStackTrace();
                        if (!DebugLogger.debugEnabled()) break block60;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
    }

    private Socket createSocket() throws LDAPConnectionException {
        ConnectException ce = null;
        try {
            for (InetAddress inetAddress : InetAddress.getAllByName(this.hostName)) {
                try {
                    return new Socket(inetAddress, this.portNumber);
                }
                catch (ConnectException ce2) {
                    if (ce != null) continue;
                    ce = ce2;
                }
            }
        }
        catch (UnknownHostException uhe) {
            Message msg = CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get();
            throw new LDAPConnectionException(msg, 91, null, uhe);
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new LDAPConnectionException(Message.raw(ex.getMessage(), new Object[0]), (Throwable)ex);
        }
        if (ce != null) {
            Message msg = CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get();
            throw new LDAPConnectionException(msg, 91, null, ce);
        }
        return null;
    }

    private Socket createSSLSocket(SSLConnectionFactory sslConnectionFactory) throws SSLConnectionException, LDAPConnectionException {
        ConnectException ce = null;
        try {
            for (InetAddress inetAddress : InetAddress.getAllByName(this.hostName)) {
                try {
                    return sslConnectionFactory.createSocket(inetAddress, this.portNumber);
                }
                catch (ConnectException ce2) {
                    if (ce != null) continue;
                    ce = ce2;
                }
            }
        }
        catch (UnknownHostException uhe) {
            Message msg = CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get();
            throw new LDAPConnectionException(msg, 91, null, uhe);
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new LDAPConnectionException(Message.raw(ex.getMessage(), new Object[0]), (Throwable)ex);
        }
        if (ce != null) {
            Message msg = CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get();
            throw new LDAPConnectionException(msg, 91, null, ce);
        }
        return null;
    }

    private Socket createSSLOrBasicSocket(Socket startTLSSocket, SSLConnectionFactory sslConnectionFactory) throws SSLConnectionException, LDAPConnectionException {
        if (sslConnectionFactory == null) {
            return this.createSocket();
        }
        if (!this.connectionOptions.useStartTLS()) {
            return this.createSSLSocket(sslConnectionFactory);
        }
        try {
            return sslConnectionFactory.createSocket(startTLSSocket, this.hostName, this.portNumber, true);
        }
        catch (IOException e) {
            Message msg = CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get();
            throw new LDAPConnectionException(msg, 91, null, e);
        }
    }

    public void close(AtomicInteger nextMessageID) {
        if (this.ldapWriter != null) {
            if (nextMessageID != null) {
                try {
                    LDAPMessage message = new LDAPMessage(nextMessageID.getAndIncrement(), new UnbindRequestProtocolOp());
                    this.ldapWriter.writeMessage(message);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.ldapWriter.close();
        }
        if (this.ldapReader != null) {
            this.ldapReader.close();
        }
    }

    public LDAPWriter getLDAPWriter() {
        return this.ldapWriter;
    }

    public LDAPReader getLDAPReader() {
        return this.ldapReader;
    }
}

