/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RawModification;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.ChangeRecordEntry;
import org.opends.server.util.DeleteChangeRecordEntry;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ModifyChangeRecordEntry;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class LDIFModify {
    private static final String CLASS_NAME = "org.opends.server.tools.LDIFModify";

    public static boolean modifyLDIF(LDIFReader sourceReader, LDIFReader changeReader, LDIFWriter targetWriter, List<Message> errorList) throws IOException, LDIFException {
        LinkedList mods;
        TreeMap<DN, AddChangeRecordEntry> adds = new TreeMap<DN, AddChangeRecordEntry>();
        TreeMap<DN, Entry> ldifEntries = new TreeMap<DN, Entry>();
        HashMap<DN, DeleteChangeRecordEntry> deletes = new HashMap<DN, DeleteChangeRecordEntry>();
        HashMap<DN, LinkedList<Modification>> modifications = new HashMap<DN, LinkedList<Modification>>();
        block14: while (true) {
            ChangeRecordEntry changeRecord;
            try {
                changeRecord = changeReader.readChangeRecord(false);
            }
            catch (LDIFException le) {
                if (le.canContinueReading()) {
                    errorList.add(le.getMessageObject());
                    continue;
                }
                throw le;
            }
            if (changeRecord == null) break;
            DN changeDN = changeRecord.getDN();
            switch (changeRecord.getChangeOperationType()) {
                case ADD: {
                    if (adds.containsKey(changeDN)) {
                        errorList.add(ToolMessages.ERR_LDIFMODIFY_CANNOT_ADD_ENTRY_TWICE.get(String.valueOf(changeDN)));
                        continue block14;
                    }
                    adds.put(changeDN, (AddChangeRecordEntry)changeRecord);
                    break;
                }
                case DELETE: {
                    if (adds.containsKey(changeDN)) {
                        errorList.add(ToolMessages.ERR_LDIFMODIFY_CANNOT_DELETE_AFTER_ADD.get(String.valueOf(changeDN)));
                        continue block14;
                    }
                    modifications.remove(changeDN);
                    deletes.put(changeDN, (DeleteChangeRecordEntry)changeRecord);
                    break;
                }
                case MODIFY: {
                    if (adds.containsKey(changeDN) || deletes.containsKey(changeDN)) {
                        errorList.add(ToolMessages.ERR_LDIFMODIFY_CANNOT_MODIFY_ADDED_OR_DELETED.get(String.valueOf(changeDN)));
                        continue block14;
                    }
                    mods = (LinkedList)modifications.get(changeDN);
                    if (mods == null) {
                        mods = new LinkedList();
                        modifications.put(changeDN, mods);
                    }
                    Iterator<RawModification> i$ = ((ModifyChangeRecordEntry)changeRecord).getModifications().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block14;
                        RawModification mod = i$.next();
                        try {
                            mods.add((Modification)mod.toModification());
                        }
                        catch (LDAPException le) {
                            errorList.add(le.getMessageObject());
                        }
                    }
                }
                case MODIFY_DN: {
                    errorList.add(ToolMessages.ERR_LDIFMODIFY_MODDN_NOT_SUPPORTED.get(String.valueOf(changeDN)));
                    continue block14;
                }
                default: {
                    errorList.add(ToolMessages.ERR_LDIFMODIFY_UNKNOWN_CHANGETYPE.get(String.valueOf(changeDN), String.valueOf((Object)changeRecord.getChangeOperationType())));
                    continue block14;
                }
            }
        }
        while (true) {
            Entry entry;
            try {
                entry = sourceReader.readEntry();
            }
            catch (LDIFException le) {
                if (le.canContinueReading()) {
                    errorList.add(le.getMessageObject());
                    continue;
                }
                throw le;
            }
            if (entry == null) break;
            DN entryDN = entry.getDN();
            if (deletes.remove(entryDN) != null) continue;
            if (adds.remove(entryDN) != null) {
                errorList.add(ToolMessages.ERR_LDIFMODIFY_ADD_ALREADY_EXISTS.get(String.valueOf(entryDN)));
                continue;
            }
            mods = (LinkedList)modifications.remove(entryDN);
            if (mods != null && !mods.isEmpty()) {
                try {
                    entry.applyModifications(mods);
                }
                catch (DirectoryException de) {
                    errorList.add(de.getMessageObject());
                    continue;
                }
            }
            ldifEntries.put(entry.getDN(), entry);
        }
        for (AddChangeRecordEntry add : adds.values()) {
            LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>();
            LinkedHashMap<AttributeType, List<Attribute>> userAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
            LinkedHashMap<AttributeType, List<Attribute>> operationalAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
            for (Attribute a : add.getAttributes()) {
                List<Attribute> attrList;
                AttributeType t = a.getAttributeType();
                if (t.isObjectClassType()) {
                    for (AttributeValue v : a) {
                        String stringValue = v.getValue().toString();
                        String lowerValue = StaticUtils.toLowerCase(stringValue);
                        ObjectClass oc = DirectoryServer.getObjectClass(lowerValue, true);
                        objectClasses.put(oc, stringValue);
                    }
                    continue;
                }
                if (t.isOperational()) {
                    attrList = (LinkedList<Attribute>)operationalAttributes.get(t);
                    if (attrList == null) {
                        attrList = new LinkedList<Attribute>();
                        operationalAttributes.put(t, attrList);
                    }
                    attrList.add(a);
                    continue;
                }
                attrList = (List)userAttributes.get(t);
                if (attrList == null) {
                    attrList = new LinkedList();
                    userAttributes.put(t, attrList);
                }
                attrList.add(a);
            }
            Entry e = new Entry(add.getDN(), objectClasses, userAttributes, operationalAttributes);
            ldifEntries.put(e.getDN(), e);
        }
        if (!deletes.isEmpty()) {
            for (DN dn : deletes.keySet()) {
                errorList.add(ToolMessages.ERR_LDIFMODIFY_DELETE_NO_SUCH_ENTRY.get(String.valueOf(dn)));
            }
        }
        if (!modifications.isEmpty()) {
            for (DN dn : modifications.keySet()) {
                errorList.add(ToolMessages.ERR_LDIFMODIFY_MODIFY_NO_SUCH_ENTRY.get(String.valueOf(dn)));
            }
        }
        return targetWriter.writeEntries(ldifEntries.values()) && errorList.isEmpty();
    }

    public static void main(String[] args) {
        int returnCode = LDIFModify.ldifModifyMain(args, false, System.out, System.err);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    public static int ldifModifyMain(String[] args, boolean serverInitialized, OutputStream outStream, OutputStream errStream) {
        boolean successful;
        LDIFWriter targetWriter;
        LDIFReader changeReader;
        LDIFReader sourceReader;
        File source;
        StringArgument targetFile;
        StringArgument changesFile;
        StringArgument sourceFile;
        StringArgument configClass;
        StringArgument configFile;
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        Message toolDescription = ToolMessages.INFO_LDIFMODIFY_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        try {
            configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            sourceFile = new StringArgument("sourceldif", Character.valueOf('s'), "sourceLDIF", true, false, true, ToolMessages.INFO_LDIFFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFMODIFY_DESCRIPTION_SOURCE.get());
            argParser.addArgument(sourceFile);
            changesFile = new StringArgument("changesldif", Character.valueOf('m'), "changesLDIF", true, false, true, ToolMessages.INFO_LDIFFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFMODIFY_DESCRIPTION_CHANGES.get());
            argParser.addArgument(changesFile);
            targetFile = new StringArgument("targetldif", Character.valueOf('t'), "targetLDIF", true, false, true, ToolMessages.INFO_LDIFFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFMODIFY_DESCRIPTION_TARGET.get());
            argParser.addArgument(targetFile);
            BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_LDIFMODIFY_DESCRIPTION_HELP.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(message);
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(message);
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        try {
            BuildVersion.checkVersionMismatch();
        }
        catch (InitializationException e) {
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (!serverInitialized) {
            DirectoryServer directoryServer = DirectoryServer.getInstance();
            DirectoryServer.bootstrapClient();
            boolean checkSchema = configFile.isPresent();
            if (checkSchema) {
                try {
                    DirectoryServer.initializeJMX();
                }
                catch (Exception e) {
                    Message message = ToolMessages.ERR_LDIFMODIFY_CANNOT_INITIALIZE_JMX.get(String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
                try {
                    directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
                }
                catch (Exception e) {
                    Message message = ToolMessages.ERR_LDIFMODIFY_CANNOT_INITIALIZE_CONFIG.get(String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
                try {
                    directoryServer.initializeSchema();
                }
                catch (Exception e) {
                    Message message = ToolMessages.ERR_LDIFMODIFY_CANNOT_INITIALIZE_SCHEMA.get(String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
            }
        }
        if (!(source = new File(sourceFile.getValue())).exists()) {
            Message message = ToolMessages.ERR_LDIFMODIFY_SOURCE_DOES_NOT_EXIST.get(sourceFile.getValue());
            err.println(message);
            return 89;
        }
        LDIFImportConfig importConfig = new LDIFImportConfig(sourceFile.getValue());
        try {
            sourceReader = new LDIFReader(importConfig);
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDIFMODIFY_CANNOT_OPEN_SOURCE.get(sourceFile.getValue(), String.valueOf(ioe));
            err.println(message);
            return 82;
        }
        File changes = new File(changesFile.getValue());
        if (!changes.exists()) {
            Message message = ToolMessages.ERR_LDIFMODIFY_CHANGES_DOES_NOT_EXIST.get(changesFile.getValue());
            err.println(message);
            return 89;
        }
        importConfig = new LDIFImportConfig(changesFile.getValue());
        try {
            changeReader = new LDIFReader(importConfig);
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDIFMODIFY_CANNOT_OPEN_CHANGES.get(sourceFile.getValue(), ioe.getMessage());
            err.println(message);
            return 82;
        }
        LDIFExportConfig exportConfig = new LDIFExportConfig(targetFile.getValue(), ExistingFileBehavior.OVERWRITE);
        try {
            targetWriter = new LDIFWriter(exportConfig);
        }
        catch (IOException ioe) {
            Message message = ToolMessages.ERR_LDIFMODIFY_CANNOT_OPEN_TARGET.get(sourceFile.getValue(), ioe.getMessage());
            err.println(message);
            return 82;
        }
        LinkedList<Message> errorList = new LinkedList<Message>();
        try {
            successful = LDIFModify.modifyLDIF(sourceReader, changeReader, targetWriter, errorList);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDIFMODIFY_ERROR_PROCESSING_LDIF.get(String.valueOf(e));
            err.println(message);
            successful = false;
        }
        try {
            sourceReader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            changeReader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            targetWriter.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (Message s : errorList) {
            err.println(s);
        }
        return successful ? 0 : 1;
    }
}

