/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;

public class PromptTrustManager
implements X509TrustManager {
    private static TrustManager[] trustManagerArray = new TrustManager[]{new PromptTrustManager()};

    private PromptTrustManager() {
    }

    public static TrustManager[] getTrustManagers() {
        return trustManagerArray;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Message message = ToolMessages.ERR_PROMPTTM_REJECTING_CLIENT_CERT.get();
        throw new CertificateException(message.toString());
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Message message;
        if (chain == null || chain.length == 0) {
            System.out.println(ToolMessages.WARN_PROMPTTM_NO_SERVER_CERT_CHAIN.get());
        } else {
            Date currentDate = new Date();
            Date notAfterDate = chain[0].getNotAfter();
            Date notBeforeDate = chain[0].getNotBefore();
            if (currentDate.after(notAfterDate)) {
                message = ToolMessages.WARN_PROMPTTM_CERT_EXPIRED.get(String.valueOf(notAfterDate));
                System.err.println(message);
            } else if (currentDate.before(notBeforeDate)) {
                message = ToolMessages.WARN_PROMPTTM_CERT_NOT_YET_VALID.get(String.valueOf(notBeforeDate));
                System.err.println(message);
            }
            System.out.println(ToolMessages.INFO_PROMPTTM_SERVER_CERT.get(chain[0].getSubjectDN().getName(), chain[0].getIssuerDN().getName(), String.valueOf(notBeforeDate), String.valueOf(notAfterDate)));
        }
        Message prompt = ToolMessages.INFO_PROMPTTM_YESNO_PROMPT.get();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                System.out.print(prompt);
                String line = reader.readLine().toLowerCase();
                if (line.equalsIgnoreCase(ToolMessages.INFO_PROMPT_YES_COMPLETE_ANSWER.get().toString()) || line.equalsIgnoreCase(ToolMessages.INFO_PROMPT_YES_FIRST_LETTER_ANSWER.get().toString())) {
                    return;
                }
                if (line.equalsIgnoreCase(ToolMessages.INFO_PROMPT_NO_COMPLETE_ANSWER.get().toString()) || line.equalsIgnoreCase(ToolMessages.INFO_PROMPT_NO_FIRST_LETTER_ANSWER.get().toString())) {
                    message = ToolMessages.ERR_PROMPTTM_USER_REJECTED.get();
                    throw new CertificateException(message.toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

