/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.jeb.RebuildConfig;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextErrorLogPublisher;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.TextDebugLogPublisher;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.tasks.RebuildTask;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.tools.tasks.TaskTool;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.RawAttribute;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.LDAPConnectionArgumentParser;
import org.opends.server.util.args.StringArgument;

public class RebuildIndex
extends TaskTool {
    private StringArgument configClass = null;
    private StringArgument configFile = null;
    private StringArgument baseDNString = null;
    private StringArgument indexList = null;
    private StringArgument tmpDirectory = null;
    private BooleanArgument rebuildAll = null;
    private BooleanArgument rebuildDegraded = null;
    private BooleanArgument clearDegradedState = null;
    private final LDAPConnectionArgumentParser argParser = this.createArgParser("org.opends.server.tools.RebuildIndex", ToolMessages.INFO_REBUILDINDEX_TOOL_DESCRIPTION.get());
    private RebuildConfig rebuildConfig = new RebuildConfig();
    private Backend currentBackend = null;

    public static void main(String[] args) {
        int retCode = RebuildIndex.mainRebuildIndex(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainRebuildIndex(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        RebuildIndex tool = new RebuildIndex();
        return tool.process(args, initializeServer, outStream, errStream);
    }

    private int process(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        PrintStream out = NullOutputStream.wrapOrNullStream(outStream);
        PrintStream err = NullOutputStream.wrapOrNullStream(errStream);
        try {
            this.initializeArguments(false);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            this.argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(this.argParser.getUsage());
            return 1;
        }
        if (this.argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        int numArgs = args.length;
        if (numArgs == 0) {
            out.println(this.argParser.getUsage());
            return 1;
        }
        if (this.indexList.getValues().size() <= 0 && !this.rebuildAll.isPresent() && !this.rebuildDegraded.isPresent()) {
            Message message = ToolMessages.ERR_REBUILDINDEX_REQUIRES_AT_LEAST_ONE_INDEX.get();
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            out.println(this.argParser.getUsage());
            return 1;
        }
        if (this.rebuildAll.isPresent() && this.indexList.isPresent()) {
            Message msg = ToolMessages.ERR_REBUILDINDEX_REBUILD_ALL_ERROR.get();
            err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
            out.println(this.argParser.getUsage());
            return 1;
        }
        if (this.rebuildDegraded.isPresent() && this.indexList.isPresent()) {
            Message msg = ToolMessages.ERR_REBUILDINDEX_REBUILD_DEGRADED_ERROR.get("index");
            err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
            out.println(this.argParser.getUsage());
            return 1;
        }
        if (this.rebuildDegraded.isPresent() && this.clearDegradedState.isPresent()) {
            Message msg = ToolMessages.ERR_REBUILDINDEX_REBUILD_DEGRADED_ERROR.get("clearDegradedState");
            err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
            out.println(this.argParser.getUsage());
            return 1;
        }
        if (this.rebuildAll.isPresent() && this.rebuildDegraded.isPresent()) {
            Message msg = ToolMessages.ERR_REBUILDINDEX_REBUILD_ALL_DEGRADED_ERROR.get("rebuildDegraded");
            err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
            out.println(this.argParser.getUsage());
            return 1;
        }
        if (this.rebuildAll.isPresent() && this.clearDegradedState.isPresent()) {
            Message msg = ToolMessages.ERR_REBUILDINDEX_REBUILD_ALL_DEGRADED_ERROR.get("clearDegradedState");
            err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
            out.println(this.argParser.getUsage());
            return 1;
        }
        try {
            BuildVersion.checkVersionMismatch();
        }
        catch (InitializationException e) {
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        return this.process(this.argParser, initializeServer, out, err);
    }

    private void initializeArguments(boolean isMultipleBackends) throws ArgumentException {
        this.configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
        this.configClass.setHidden(true);
        this.argParser.addArgument(this.configClass);
        this.configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
        this.configFile.setHidden(true);
        this.argParser.addArgument(this.configFile);
        this.baseDNString = new StringArgument("basedn", Character.valueOf('b'), "baseDN", true, isMultipleBackends, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_REBUILDINDEX_DESCRIPTION_BASE_DN.get());
        this.argParser.addArgument(this.baseDNString);
        this.indexList = new StringArgument("index", Character.valueOf('i'), "index", false, true, true, ToolMessages.INFO_INDEX_PLACEHOLDER.get(), null, null, ToolMessages.INFO_REBUILDINDEX_DESCRIPTION_INDEX_NAME.get());
        this.argParser.addArgument(this.indexList);
        this.rebuildAll = new BooleanArgument("rebuildAll", null, "rebuildAll", ToolMessages.INFO_REBUILDINDEX_DESCRIPTION_REBUILD_ALL.get());
        this.argParser.addArgument(this.rebuildAll);
        this.rebuildDegraded = new BooleanArgument("rebuildDegraded", null, "rebuildDegraded", ToolMessages.INFO_REBUILDINDEX_DESCRIPTION_REBUILD_DEGRADED.get());
        this.argParser.addArgument(this.rebuildDegraded);
        this.clearDegradedState = new BooleanArgument("clearDegradedState", null, "clearDegradedState", ToolMessages.INFO_REBUILDINDEX_DESCRIPTION_CLEAR_DEGRADED_STATE.get());
        this.argParser.addArgument(this.clearDegradedState);
        this.tmpDirectory = new StringArgument("tmpdirectory", null, "tmpdirectory", false, false, true, ToolMessages.INFO_REBUILDINDEX_TEMP_DIR_PLACEHOLDER.get(), "import-tmp", null, ToolMessages.INFO_REBUILDINDEX_DESCRIPTION_TEMP_DIRECTORY.get());
        this.argParser.addArgument(this.tmpDirectory);
        BooleanArgument displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
        this.argParser.addArgument(displayUsage);
        this.argParser.setUsageArgument(displayUsage);
    }

    @Override
    protected int processLocal(boolean initializeServer, PrintStream out, PrintStream err) {
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            int init = this.initializeServer(directoryServer, out, err);
            if (init != 0) {
                return init;
            }
            this.setErrorAndDebugLogPublisher(out, err);
        }
        if (!this.configureRebuildProcess(this.baseDNString.getValue())) {
            return 1;
        }
        return this.rebuildIndex(this.currentBackend, this.rebuildConfig);
    }

    private boolean configureRebuildProcess(String dn) {
        DN rebuildBaseDN = null;
        try {
            rebuildBaseDN = DN.decode(dn);
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_CANNOT_DECODE_BASE_DN.get(dn, StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            return false;
        }
        try {
            this.setCurrentBackend(this.retrieveBackend(rebuildBaseDN));
        }
        catch (Exception e) {
            ErrorLogger.logError(Message.raw(e.getMessage(), new Object[0]));
            return false;
        }
        this.setRebuildConfig(this.initializeRebuildIndexConfiguration(rebuildBaseDN));
        return true;
    }

    private void setErrorAndDebugLogPublisher(PrintStream out, PrintStream err) {
        try {
            TextErrorLogPublisher errorLogPublisher = TextErrorLogPublisher.getToolStartupTextErrorPublisher(new TextWriter.STREAM(out));
            TextDebugLogPublisher debugLogPublisher = TextDebugLogPublisher.getStartupTextDebugPublisher(new TextWriter.STREAM(out));
            ErrorLogger.addErrorLogPublisher(errorLogPublisher);
            DebugLogger.addDebugLogPublisher(debugLogPublisher);
        }
        catch (Exception e) {
            err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
        }
    }

    private int initializeServer(DirectoryServer directoryServer, PrintStream out, PrintStream err) {
        try {
            DirectoryServer.bootstrapClient();
            DirectoryServer.initializeJMX();
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            directoryServer.initializeConfiguration(this.configClass.getValue(), this.configFile.getValue());
        }
        catch (Exception ex) {
            Message message = null;
            message = ex instanceof InitializationException ? ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ex.getMessage()) : ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(ex));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (Exception e) {
            Message message = null;
            message = e instanceof ConfigException || e instanceof InitializationException ? ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(e.getMessage()) : ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            CoreConfigManager coreConfigManager = new CoreConfigManager();
            coreConfigManager.initializeCoreConfig();
        }
        catch (Exception ex) {
            Message message = null;
            message = ex instanceof ConfigException || ex instanceof InitializationException ? ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ex.getMessage()) : ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(StaticUtils.getExceptionMessage(ex));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            directoryServer.initializeCryptoManager();
        }
        catch (Exception ex) {
            Message message = null;
            message = ex instanceof ConfigException || ex instanceof InitializationException ? ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ex.getMessage()) : ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(StaticUtils.getExceptionMessage(ex));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        return 0;
    }

    private RebuildConfig initializeRebuildIndexConfiguration(DN rebuildBaseDN) {
        RebuildConfig config = new RebuildConfig();
        config.setBaseDN(rebuildBaseDN);
        for (String s : this.indexList.getValues()) {
            config.addRebuildIndex(s);
        }
        if (this.rebuildAll.isPresent()) {
            config.setRebuildMode(RebuildConfig.RebuildMode.ALL);
        } else if (this.rebuildDegraded.isPresent()) {
            config.setRebuildMode(RebuildConfig.RebuildMode.DEGRADED);
        } else {
            if (this.clearDegradedState.isPresent()) {
                config.isClearDegradedState(true);
            }
            config.setRebuildMode(RebuildConfig.RebuildMode.USER_DEFINED);
        }
        config.setTmpDirectory(this.tmpDirectory.getValue());
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rebuildIndex(Backend backend, RebuildConfig rebuildConfig) {
        StringBuilder failureReason;
        int returnCode = 0;
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_REBUILDINDEX_CANNOT_EXCLUSIVE_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message);
                return 1;
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_REBUILDINDEX_CANNOT_EXCLUSIVE_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            return 1;
        }
        try {
            BackendImpl jebBackend = (BackendImpl)backend;
            jebBackend.rebuildBackend(rebuildConfig);
        }
        catch (InitializationException e) {
            ErrorLogger.logError(ToolMessages.ERR_REBUILDINDEX_ERROR_DURING_REBUILD.get(e.getMessage()));
            returnCode = 1;
        }
        catch (Exception e) {
            ErrorLogger.logError(ToolMessages.ERR_REBUILDINDEX_ERROR_DURING_REBUILD.get(StaticUtils.getExceptionMessage(e)));
            returnCode = 1;
        }
        finally {
            try {
                String lockFile = LockFileManager.getBackendLockFileName(backend);
                failureReason = new StringBuilder();
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    ErrorLogger.logError(ToolMessages.WARN_REBUILDINDEX_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason)));
                }
            }
            catch (Exception e) {
                ErrorLogger.logError(ToolMessages.WARN_REBUILDINDEX_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e)));
            }
        }
        return returnCode;
    }

    private Backend retrieveBackend(DN selectedDN) throws ConfigException, Exception {
        Backend backend = null;
        ArrayList<Backend> backendList = new ArrayList<Backend>();
        ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
        ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
        BackendToolUtils.getBackends(backendList, entryList, dnList);
        int numBackends = backendList.size();
        block0: for (int i = 0; i < numBackends; ++i) {
            Backend b = backendList.get(i);
            List<DN> baseDNs = dnList.get(i);
            for (DN baseDN : baseDNs) {
                if (!baseDN.equals(selectedDN)) continue;
                if (backend == null) {
                    backend = b;
                    DN[] baseDNArray = new DN[baseDNs.size()];
                    baseDNs.toArray(baseDNArray);
                    continue block0;
                }
                Message message = ToolMessages.ERR_MULTIPLE_BACKENDS_FOR_BASE.get(this.baseDNString.getValue());
                throw new ConfigException(message);
            }
        }
        if (backend == null) {
            Message message = ToolMessages.ERR_NO_BACKENDS_FOR_BASE.get(this.baseDNString.getValue());
            throw new ConfigException(message);
        }
        if (!(backend instanceof BackendImpl)) {
            Message message = ToolMessages.ERR_BACKEND_NO_INDEXING_SUPPORT.get();
            throw new ConfigException(message);
        }
        return backend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rebuildIndexesWithinMultipleBackends(boolean initializeServer, PrintStream out, String ... args) {
        int n;
        block12: {
            int init;
            this.setErrorAndDebugLogPublisher(out, out);
            try {
                this.initializeArguments(true);
            }
            catch (ArgumentException ae) {
                Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
                out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                int n2 = 1;
                StaticUtils.close(out);
                return n2;
            }
            try {
                this.argParser.parseArguments(args);
            }
            catch (ArgumentException ae) {
                Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
                out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                int n3 = 1;
                StaticUtils.close(out);
                return n3;
            }
            DirectoryServer directoryServer = DirectoryServer.getInstance();
            if (!initializeServer || (init = this.initializeServer(directoryServer, out, out)) == 0) break block12;
            int n4 = init;
            StaticUtils.close(out);
            return n4;
        }
        try {
            for (String dn : this.baseDNString.getValues()) {
                if (this.configureRebuildProcess(dn)) break block13;
                n = 1;
            }
        }
        catch (Throwable throwable) {
            StaticUtils.close(out);
            throw throwable;
        }
        {
            block14: {
                String dn;
                block13: {
                    StaticUtils.close(out);
                    return n;
                }
                int result = this.rebuildIndex(this.getCurrentBackend(), this.getRebuildConfig());
                if (result == 0) break block14;
                out.println(String.format("An error occurs during the rebuild index process in %s, rebuild index(es) aborted.", dn));
                int n5 = 1;
                StaticUtils.close(out);
                return n5;
            }
            continue;
        }
        StaticUtils.close(out);
        return 0;
    }

    @Override
    public String getTaskId() {
        return null;
    }

    @Override
    public void addTaskAttributes(List<RawAttribute> attributes) {
        String baseDN = this.baseDNString.getValue();
        ArrayList<ByteString> values = new ArrayList<ByteString>(1);
        values.add(ByteString.valueOf(baseDN));
        attributes.add(new LDAPAttribute("ds-task-rebuild-base-dn", values));
        LinkedList<String> indexes = this.indexList.getValues();
        values = new ArrayList(indexes.size());
        for (String s : indexes) {
            values.add(ByteString.valueOf(s));
        }
        attributes.add(new LDAPAttribute("ds-task-rebuild-index", values));
        if (this.tmpDirectory.getValue() != null && !this.tmpDirectory.getValue().equals(this.tmpDirectory.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.tmpDirectory.getValue()));
            attributes.add(new LDAPAttribute("ds-task-rebuild-tmp-directory", values));
        }
        if (this.rebuildAll.getValue() != null && !this.rebuildAll.getValue().equals(this.rebuildAll.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf("rebuildall"));
            attributes.add(new LDAPAttribute("ds-task-rebuild-index", values));
        }
        if (this.rebuildDegraded.getValue() != null && !this.rebuildDegraded.getValue().equals(this.rebuildDegraded.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf("rebuilddegraded"));
            attributes.add(new LDAPAttribute("ds-task-rebuild-index", values));
        }
        if (this.clearDegradedState.getValue() != null && !this.clearDegradedState.getValue().equals(this.clearDegradedState.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf("true"));
            attributes.add(new LDAPAttribute("ds-task-rebuild-index-clear-degraded-state", values));
        }
    }

    @Override
    public String getTaskObjectclass() {
        return "ds-task-rebuild";
    }

    @Override
    public Class<?> getTaskClass() {
        return RebuildTask.class;
    }

    public RebuildConfig getRebuildConfig() {
        return this.rebuildConfig;
    }

    public void setRebuildConfig(RebuildConfig rebuildConfig) {
        this.rebuildConfig = rebuildConfig;
    }

    public Backend getCurrentBackend() {
        return this.currentBackend;
    }

    public void setCurrentBackend(Backend currentBackend) {
        this.currentBackend = currentBackend;
    }
}

