/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.text.NumberFormat;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.DurationUnit;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.SizeUnit;

final class PropertyValuePrinter {
    private final MyPropertyValueVisitor pimpl;

    public PropertyValuePrinter(SizeUnit sizeUnit, DurationUnit timeUnit, boolean isScriptFriendly) {
        this.pimpl = new MyPropertyValueVisitor(sizeUnit, timeUnit, isScriptFriendly);
    }

    public <T> Message print(PropertyDefinition<T> pd, T value) {
        return pd.accept(this.pimpl, value, null);
    }

    private static class MyPropertyValueVisitor
    extends PropertyValueVisitor<Message, Void> {
        private final SizeUnit sizeUnit;
        private final DurationUnit timeUnit;
        private final boolean isScriptFriendly;
        private final NumberFormat numberFormat;

        private MyPropertyValueVisitor(SizeUnit sizeUnit, DurationUnit timeUnit, boolean isScriptFriendly) {
            this.sizeUnit = sizeUnit;
            this.timeUnit = timeUnit;
            this.isScriptFriendly = isScriptFriendly;
            this.numberFormat = NumberFormat.getNumberInstance();
            if (this.isScriptFriendly) {
                this.numberFormat.setGroupingUsed(false);
                this.numberFormat.setMaximumFractionDigits(2);
            } else {
                this.numberFormat.setGroupingUsed(true);
                this.numberFormat.setMaximumFractionDigits(2);
            }
        }

        @Override
        public Message visitBoolean(BooleanPropertyDefinition pd, Boolean v, Void p) {
            if (!v.booleanValue()) {
                return DSConfigMessages.INFO_VALUE_FALSE.get();
            }
            return DSConfigMessages.INFO_VALUE_TRUE.get();
        }

        @Override
        public Message visitDuration(DurationPropertyDefinition pd, Long v, Void p) {
            if (pd.getUpperLimit() == null && (v < 0L || v == Long.MAX_VALUE)) {
                return DSConfigMessages.INFO_VALUE_UNLIMITED.get();
            }
            MessageBuilder builder = new MessageBuilder();
            long ms = pd.getBaseUnit().toMilliSeconds(v.longValue());
            if (this.timeUnit == null && !this.isScriptFriendly && ms != 0L) {
                builder.append(DurationUnit.toString(ms));
            } else {
                DurationUnit unit = this.timeUnit;
                if (unit == null) {
                    unit = pd.getBaseUnit();
                }
                builder.append(this.numberFormat.format(unit.fromMilliSeconds(ms)));
                builder.append(' ');
                builder.append(unit.getShortName());
            }
            return builder.toMessage();
        }

        @Override
        public Message visitSize(SizePropertyDefinition pd, Long v, Void p) {
            if (pd.isAllowUnlimited() && v < 0L) {
                return DSConfigMessages.INFO_VALUE_UNLIMITED.get();
            }
            SizeUnit unit = this.sizeUnit;
            if (unit == null) {
                unit = this.isScriptFriendly ? SizeUnit.getBestFitUnitExact(v) : SizeUnit.getBestFitUnit(v);
            }
            MessageBuilder builder = new MessageBuilder();
            builder.append(this.numberFormat.format(unit.fromBytes(v)));
            builder.append(' ');
            builder.append(unit.getShortName());
            return builder.toMessage();
        }

        @Override
        public <T> Message visitUnknown(PropertyDefinition<T> pd, T v, Void p) {
            String s = pd.encodeValue(v);
            if (this.isScriptFriendly) {
                return Message.raw("%s", s);
            }
            if (s.trim().length() == 0 || s.contains(",")) {
                return Message.raw("\"%s\"", s);
            }
            return Message.raw("%s", s);
        }
    }
}

