/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.tasks;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.backends.task.TaskState;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.tools.tasks.TaskClientException;
import org.opends.server.tools.tasks.TaskEntry;
import org.opends.server.tools.tasks.TaskScheduleInformation;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

public class TaskClient {
    protected LDAPConnection connection;
    private final AtomicInteger nextMessageID = new AtomicInteger(0);

    public TaskClient(LDAPConnection conn) {
        this.connection = conn;
    }

    public static String getTaskID(List<RawAttribute> taskAttributes) {
        String taskID = null;
        RawAttribute recurringIDAttr = TaskClient.getAttribute("ds-recurring-task-id", taskAttributes);
        if (recurringIDAttr != null) {
            taskID = recurringIDAttr.getValues().get(0).toString();
        } else {
            RawAttribute taskIDAttr = TaskClient.getAttribute("ds-task-id", taskAttributes);
            taskID = taskIDAttr.getValues().get(0).toString();
        }
        return taskID;
    }

    private static RawAttribute getAttribute(String attrName, List<RawAttribute> taskAttributes) {
        for (RawAttribute attr : taskAttributes) {
            if (!attr.getAttributeType().equalsIgnoreCase(attrName)) continue;
            return attr;
        }
        return null;
    }

    public static String getTaskDN(List<RawAttribute> taskAttributes) {
        String entryDN = null;
        String taskID = TaskClient.getTaskID(taskAttributes);
        RawAttribute recurringIDAttr = TaskClient.getAttribute("ds-recurring-task-id", taskAttributes);
        entryDN = recurringIDAttr != null ? "ds-recurring-task-id=" + taskID + "," + "cn=Recurring Tasks" + "," + "cn=Tasks" : "ds-task-id=" + taskID + "," + "cn=Scheduled Tasks" + "," + "cn=Tasks";
        return entryDN;
    }

    private static boolean isScheduleRecurring(TaskScheduleInformation information) {
        boolean scheduleRecurring = false;
        if (information.getRecurringDateTime() != null) {
            scheduleRecurring = true;
        }
        return scheduleRecurring;
    }

    public static ArrayList<RawAttribute> getTaskAttributes(TaskScheduleInformation information) {
        List<String> errNotifEmailAddresss;
        List<String> compNotifEmailAddresss;
        List<String> dependencyIds;
        String taskID = null;
        boolean scheduleRecurring = TaskClient.isScheduleRecurring(information);
        if (scheduleRecurring) {
            taskID = information.getTaskId();
            if (taskID == null || taskID.length() == 0) {
                taskID = information.getTaskClass().getSimpleName() + "-" + UUID.randomUUID().toString();
            }
        } else {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            taskID = df.format(new Date());
        }
        ArrayList<RawAttribute> attributes = new ArrayList<RawAttribute>();
        ArrayList<ByteString> ocValues = new ArrayList<ByteString>(3);
        ocValues.add(ByteString.valueOf("top"));
        ocValues.add(ByteString.valueOf("ds-task"));
        if (scheduleRecurring) {
            ocValues.add(ByteString.valueOf("ds-recurring-task"));
        }
        ocValues.add(ByteString.valueOf(information.getTaskObjectclass()));
        attributes.add(new LDAPAttribute("objectClass", ocValues));
        ArrayList<ByteString> taskIDValues = new ArrayList<ByteString>(1);
        taskIDValues.add(ByteString.valueOf(taskID));
        if (scheduleRecurring) {
            attributes.add(new LDAPAttribute("ds-recurring-task-id", taskIDValues));
        }
        attributes.add(new LDAPAttribute("ds-task-id", taskIDValues));
        ArrayList<ByteString> classValues = new ArrayList<ByteString>(1);
        classValues.add(ByteString.valueOf(information.getTaskClass().getName()));
        attributes.add(new LDAPAttribute("ds-task-class-name", classValues));
        Date startDate = information.getStartDateTime();
        if (startDate != null) {
            String startTimeString = StaticUtils.formatDateTimeString(startDate);
            ArrayList<ByteString> startDateValues = new ArrayList<ByteString>(1);
            startDateValues.add(ByteString.valueOf(startTimeString));
            attributes.add(new LDAPAttribute("ds-task-scheduled-start-time", startDateValues));
        }
        if (scheduleRecurring) {
            ArrayList<ByteString> recurringPatternValues = new ArrayList<ByteString>(1);
            recurringPatternValues.add(ByteString.valueOf(information.getRecurringDateTime()));
            attributes.add(new LDAPAttribute("ds-recurring-task-schedule", recurringPatternValues));
        }
        if ((dependencyIds = information.getDependencyIds()) != null && dependencyIds.size() > 0) {
            ArrayList<ByteString> dependencyIdValues = new ArrayList<ByteString>(dependencyIds.size());
            for (String dependencyId : dependencyIds) {
                dependencyIdValues.add(ByteString.valueOf(dependencyId));
            }
            attributes.add(new LDAPAttribute("ds-task-dependency-id", dependencyIdValues));
            FailedDependencyAction fda = information.getFailedDependencyAction();
            if (fda == null) {
                fda = FailedDependencyAction.defaultValue();
            }
            ArrayList<ByteString> fdaValues = new ArrayList<ByteString>(1);
            fdaValues.add(ByteString.valueOf(fda.name()));
            attributes.add(new LDAPAttribute("ds-task-failed-dependency-action", fdaValues));
        }
        if ((compNotifEmailAddresss = information.getNotifyUponCompletionEmailAddresses()) != null && compNotifEmailAddresss.size() > 0) {
            ArrayList<ByteString> compNotifEmailAddrValues = new ArrayList<ByteString>(compNotifEmailAddresss.size());
            for (String emailAddr : compNotifEmailAddresss) {
                compNotifEmailAddrValues.add(ByteString.valueOf(emailAddr));
            }
            attributes.add(new LDAPAttribute("ds-task-notify-on-completion", compNotifEmailAddrValues));
        }
        if ((errNotifEmailAddresss = information.getNotifyUponErrorEmailAddresses()) != null && errNotifEmailAddresss.size() > 0) {
            ArrayList<ByteString> errNotifEmailAddrValues = new ArrayList<ByteString>(errNotifEmailAddresss.size());
            for (String emailAddr : errNotifEmailAddresss) {
                errNotifEmailAddrValues.add(ByteString.valueOf(emailAddr));
            }
            attributes.add(new LDAPAttribute("ds-task-notify-on-error", errNotifEmailAddrValues));
        }
        information.addTaskAttributes(attributes);
        return attributes;
    }

    public synchronized TaskEntry schedule(TaskScheduleInformation information) throws LDAPException, IOException, ASN1Exception, TaskClientException {
        LDAPReader reader = this.connection.getLDAPReader();
        LDAPWriter writer = this.connection.getLDAPWriter();
        ArrayList<Control> controls = new ArrayList<Control>();
        ArrayList<RawAttribute> attributes = TaskClient.getTaskAttributes(information);
        ByteString entryDN = ByteString.valueOf(TaskClient.getTaskDN(attributes));
        AddRequestProtocolOp addRequest = new AddRequestProtocolOp(entryDN, attributes);
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), addRequest, controls);
        writer.writeMessage(requestMessage);
        LDAPMessage responseMessage = reader.readMessage();
        if (responseMessage == null) {
            throw new LDAPException(81, ToolMessages.ERR_TASK_CLIENT_UNEXPECTED_CONNECTION_CLOSURE.get());
        }
        if (responseMessage.getProtocolOpType() != 105) {
            throw new LDAPException(82, ToolMessages.ERR_TASK_CLIENT_INVALID_RESPONSE_TYPE.get(responseMessage.getProtocolOpName()));
        }
        AddResponseProtocolOp addResponse = responseMessage.getAddResponseProtocolOp();
        if (addResponse.getResultCode() != 0) {
            throw new LDAPException(82, addResponse.getErrorMessage());
        }
        return this.getTaskEntry(TaskClient.getTaskID(attributes));
    }

    public synchronized List<TaskEntry> getTaskEntries() throws LDAPException, IOException, ASN1Exception {
        byte opType;
        ArrayList<SearchResultEntry> entries = new ArrayList<SearchResultEntry>();
        this.writeSearch(new SearchRequestProtocolOp(ByteString.valueOf("cn=Tasks"), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, Integer.MAX_VALUE, Integer.MAX_VALUE, false, LDAPFilter.decode("(objectclass=ds-task)"), new LinkedHashSet<String>()));
        LDAPReader reader = this.connection.getLDAPReader();
        do {
            LDAPMessage responseMessage;
            if ((responseMessage = reader.readMessage()) == null) {
                throw new LDAPException(81, ToolMessages.ERR_TASK_CLIENT_UNEXPECTED_CONNECTION_CLOSURE.get());
            }
            opType = responseMessage.getProtocolOpType();
            if (opType != 100) continue;
            SearchResultEntryProtocolOp searchEntryOp = responseMessage.getSearchResultEntryProtocolOp();
            Entry entry = searchEntryOp.toSearchResultEntry();
            entries.add((SearchResultEntry)entry);
        } while (opType != 101);
        ArrayList<TaskEntry> taskEntries = new ArrayList<TaskEntry>(entries.size());
        for (Entry entry : entries) {
            taskEntries.add(new TaskEntry(entry));
        }
        return Collections.unmodifiableList(taskEntries);
    }

    public synchronized TaskEntry getTaskEntry(String id) throws LDAPException, IOException, ASN1Exception, TaskClientException {
        byte opType;
        SearchResultEntry entry = null;
        this.writeSearch(new SearchRequestProtocolOp(ByteString.valueOf("cn=Tasks"), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, Integer.MAX_VALUE, Integer.MAX_VALUE, false, LDAPFilter.decode("(ds-task-id=" + id + ")"), new LinkedHashSet<String>()));
        LDAPReader reader = this.connection.getLDAPReader();
        do {
            LDAPMessage responseMessage;
            if ((responseMessage = reader.readMessage()) == null) {
                Message message = ToolMessages.ERR_TASK_CLIENT_UNEXPECTED_CONNECTION_CLOSURE.get();
                throw new LDAPException(ResultCode.UNAVAILABLE.getIntValue(), message);
            }
            opType = responseMessage.getProtocolOpType();
            if (opType != 100) continue;
            SearchResultEntryProtocolOp searchEntryOp = responseMessage.getSearchResultEntryProtocolOp();
            entry = searchEntryOp.toSearchResultEntry();
        } while (opType != 101);
        if (entry == null) {
            throw new TaskClientException(ToolMessages.ERR_TASK_CLIENT_UNKNOWN_TASK.get(id));
        }
        return new TaskEntry(entry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void cancelTask(String id) throws TaskClientException, IOException, ASN1Exception, LDAPException {
        LDAPReader reader = this.connection.getLDAPReader();
        LDAPWriter writer = this.connection.getLDAPWriter();
        TaskEntry entry = this.getTaskEntry(id);
        TaskState state = entry.getTaskState();
        if (state == null) throw new TaskClientException(ToolMessages.ERR_TASK_CLIENT_TASK_STATE_UNKNOWN.get(id));
        if (!TaskState.isDone(state)) {
            ByteString dn = ByteString.valueOf(entry.getDN().toString());
            ArrayList<RawModification> mods = new ArrayList<RawModification>();
            ArrayList<ByteString> values = new ArrayList<ByteString>();
            String newState = TaskState.isPending(state) ? TaskState.CANCELED_BEFORE_STARTING.name() : TaskState.STOPPED_BY_ADMINISTRATOR.name();
            values.add(ByteString.valueOf(newState));
            LDAPAttribute attr = new LDAPAttribute("ds-task-state", values);
            mods.add(new LDAPModification(ModificationType.REPLACE, attr));
            ModifyRequestProtocolOp modRequest = new ModifyRequestProtocolOp(dn, mods);
            LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), modRequest, null);
            writer.writeMessage(requestMessage);
            LDAPMessage responseMessage = reader.readMessage();
            if (responseMessage == null) {
                Message message = ToolMessages.ERR_TASK_CLIENT_UNEXPECTED_CONNECTION_CLOSURE.get();
                throw new LDAPException(ResultCode.UNAVAILABLE.getIntValue(), message);
            }
            if (responseMessage.getProtocolOpType() != 103) {
                throw new LDAPException(82, ToolMessages.ERR_TASK_CLIENT_INVALID_RESPONSE_TYPE.get(responseMessage.getProtocolOpName()));
            }
            ModifyResponseProtocolOp modResponse = responseMessage.getModifyResponseProtocolOp();
            Message errorMessage = modResponse.getErrorMessage();
            if (errorMessage == null) return;
            throw new LDAPException(82, errorMessage);
        }
        if (!TaskState.isRecurring(state)) throw new TaskClientException(ToolMessages.ERR_TASK_CLIENT_UNCANCELABLE_TASK.get(id));
        ByteString dn = ByteString.valueOf(entry.getDN().toString());
        DeleteRequestProtocolOp deleteRequest = new DeleteRequestProtocolOp(dn);
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), deleteRequest, null);
        writer.writeMessage(requestMessage);
        LDAPMessage responseMessage = reader.readMessage();
        if (responseMessage == null) {
            Message message = ToolMessages.ERR_TASK_CLIENT_UNEXPECTED_CONNECTION_CLOSURE.get();
            throw new LDAPException(ResultCode.UNAVAILABLE.getIntValue(), message);
        }
        if (responseMessage.getProtocolOpType() != 107) {
            throw new LDAPException(82, ToolMessages.ERR_TASK_CLIENT_INVALID_RESPONSE_TYPE.get(responseMessage.getProtocolOpName()));
        }
        DeleteResponseProtocolOp deleteResponse = responseMessage.getDeleteResponseProtocolOp();
        Message errorMessage = deleteResponse.getErrorMessage();
        if (errorMessage == null) return;
        throw new LDAPException(82, errorMessage);
    }

    private void writeSearch(SearchRequestProtocolOp searchRequest) throws IOException {
        LDAPWriter writer = this.connection.getLDAPWriter();
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), searchRequest, new ArrayList<Control>());
        writer.writeMessage(requestMessage);
    }
}

