/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.tasks;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.util.PlainTextProgressMessageFormatter;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.server.admin.client.cli.TaskScheduleArgs;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.backends.task.RecurringTask;
import org.opends.server.tools.tasks.TaskEntry;
import org.opends.server.tools.tasks.TaskScheduleUserData;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;

public class TaskScheduleInteraction {
    private boolean headerDisplayed;
    private final TaskScheduleUserData uData;
    private final TaskScheduleArgs args;
    private final ConsoleApplication app;
    private final Message taskName;
    private List<? extends TaskEntry> taskEntries = Collections.emptyList();
    private ProgressMessageFormatter formatter = new PlainTextProgressMessageFormatter();

    public TaskScheduleInteraction(TaskScheduleUserData uData, TaskScheduleArgs args, ConsoleApplication app, Message taskName) {
        this.uData = uData;
        this.args = args;
        this.app = app;
        this.taskName = taskName;
    }

    public void run() throws CLIException {
        this.headerDisplayed = false;
        this.runStartNowOrSchedule();
        this.runCompletionNotification();
        this.runErrorNotification();
        this.runDependency();
        if (!this.uData.getDependencyIds().isEmpty()) {
            this.runFailedDependencyAction();
        }
    }

    public List<? extends TaskEntry> getTaskEntries() {
        return this.taskEntries;
    }

    public void setTaskEntries(List<? extends TaskEntry> taskEntries) {
        this.taskEntries = taskEntries;
    }

    public ProgressMessageFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(ProgressMessageFormatter formatter) {
        this.formatter = formatter;
    }

    private void runFailedDependencyAction() throws CLIException {
        if (this.args.dependencyArg.isPresent()) {
            this.uData.setFailedDependencyAction(this.args.getFailedDependencyAction());
        } else {
            this.askForFailedDependencyAction();
        }
    }

    private void askForFailedDependencyAction() throws CLIException {
        this.checkHeaderDisplay();
        MenuBuilder<FailedDependencyAction> builder = new MenuBuilder<FailedDependencyAction>(this.app);
        builder.setPrompt(AdminToolMessages.INFO_TASK_FAILED_DEPENDENCY_ACTION_PROMPT.get());
        builder.addCancelOption(false);
        for (FailedDependencyAction choice : FailedDependencyAction.values()) {
            MenuResult<FailedDependencyAction> result = MenuResult.success(choice);
            builder.addNumberedOption(choice.getDisplayName(), result, new Message[0]);
            if (!choice.equals((Object)FailedDependencyAction.defaultValue())) continue;
            builder.setDefault(choice.getDisplayName(), result);
        }
        MenuResult m = builder.toMenu().run();
        if (!m.isSuccess()) {
            throw new CLIException(Message.EMPTY);
        }
        this.uData.setFailedDependencyAction((FailedDependencyAction)((Object)m.getValue()));
    }

    private void runDependency() throws CLIException {
        if (this.args.dependencyArg.isPresent()) {
            this.uData.setDependencyIds(this.args.getDependencyIds());
        } else if (!this.taskEntries.isEmpty()) {
            this.askForDependency();
        }
    }

    private void askForDependency() throws CLIException {
        this.checkHeaderDisplay();
        boolean hasDependencies = this.app.confirmAction(AdminToolMessages.INFO_TASK_HAS_DEPENDENCIES_PROMPT.get(), false);
        if (hasDependencies) {
            String dependencyID;
            this.printAvailableDependencyTaskMessage();
            HashSet<String> dependencies = new HashSet<String>();
            while ((dependencyID = this.app.readLineOfInput(AdminToolMessages.INFO_TASK_DEPENDENCIES_PROMPT.get())) != null && !dependencyID.isEmpty()) {
                if (this.isTaskIDDefined(dependencyID)) {
                    dependencies.add(dependencyID);
                    continue;
                }
                this.printTaskIDNotDefinedMessage(dependencyID);
            }
            this.uData.setDependencyIds(new ArrayList<String>(dependencies));
        } else {
            List<String> empty = Collections.emptyList();
            this.uData.setDependencyIds(empty);
        }
    }

    private void printAvailableDependencyTaskMessage() {
        StringBuilder sb = new StringBuilder();
        String separator = this.formatter.getLineBreak().toString() + this.formatter.getTab().toString();
        for (TaskEntry taskEntry : this.taskEntries) {
            sb.append(separator);
            sb.append(taskEntry.getId());
        }
        this.app.printlnProgress();
        this.app.printProgress(AdminToolMessages.INFO_AVAILABLE_DEFINED_TASKS.get(sb.toString()));
        this.app.printlnProgress();
        this.app.printlnProgress();
    }

    private void printTaskIDNotDefinedMessage(String dependencyID) {
        this.app.println();
        this.app.println(AdminToolMessages.ERR_DEPENDENCY_TASK_NOT_DEFINED.get(dependencyID));
    }

    private boolean isTaskIDDefined(String dependencyID) {
        boolean taskIDDefined = false;
        for (TaskEntry taskEntry : this.taskEntries) {
            if (!dependencyID.equalsIgnoreCase(taskEntry.getId())) continue;
            taskIDDefined = true;
            break;
        }
        return taskIDDefined;
    }

    private void runErrorNotification() throws CLIException {
        if (this.args.errorNotificationArg.isPresent()) {
            this.uData.setNotifyUponErrorEmailAddresses(this.args.getNotifyUponErrorEmailAddresses());
        } else {
            this.askForErrorNotification();
        }
    }

    private void askForErrorNotification() throws CLIException {
        List<String> addresses = this.askForEmailNotification(AdminToolMessages.INFO_HAS_ERROR_NOTIFICATION_PROMPT.get(), AdminToolMessages.INFO_ERROR_NOTIFICATION_PROMPT.get());
        this.uData.setNotifyUponErrorEmailAddresses(addresses);
    }

    private List<String> askForEmailNotification(Message hasNotificationPrompt, Message emailAddressPrompt) throws CLIException {
        this.checkHeaderDisplay();
        ArrayList<String> addresses = new ArrayList<String>();
        boolean hasNotification = this.app.confirmAction(hasNotificationPrompt, false);
        if (hasNotification) {
            String address;
            HashSet<String> set = new HashSet<String>();
            while ((address = this.app.readLineOfInput(emailAddressPrompt)) != null && !address.isEmpty()) {
                if (!StaticUtils.isEmailAddress(address)) {
                    this.app.println(AdminToolMessages.ERR_INVALID_EMAIL_ADDRESS.get(address));
                    continue;
                }
                set.add(address);
            }
            addresses.addAll(set);
        }
        return addresses;
    }

    private void runCompletionNotification() throws CLIException {
        if (this.args.completionNotificationArg.isPresent()) {
            this.uData.setNotifyUponCompletionEmailAddresses(this.args.getNotifyUponCompletionEmailAddresses());
        } else {
            this.askForCompletionNotification();
        }
    }

    private void askForCompletionNotification() throws CLIException {
        List<String> addresses = this.askForEmailNotification(AdminToolMessages.INFO_HAS_COMPLETION_NOTIFICATION_PROMPT.get(), AdminToolMessages.INFO_COMPLETION_NOTIFICATION_PROMPT.get());
        this.uData.setNotifyUponCompletionEmailAddresses(addresses);
    }

    private void runStartNowOrSchedule() throws CLIException {
        if (this.args.startArg.isPresent()) {
            this.uData.setStartDate(this.args.getStartDateTime());
            this.uData.setStartNow(this.args.isStartNow());
        }
        if (this.args.recurringArg.isPresent()) {
            this.uData.setRecurringDateTime(this.args.getRecurringDateTime());
            this.uData.setStartNow(false);
        }
        if (!this.args.startArg.isPresent() && !this.args.recurringArg.isPresent()) {
            this.askToStartNowOrSchedule();
        }
    }

    private void askToStartNowOrSchedule() throws CLIException {
        this.checkHeaderDisplay();
        MenuBuilder<ScheduleOption> builder = new MenuBuilder<ScheduleOption>(this.app);
        builder.setPrompt(AdminToolMessages.INFO_TASK_SCHEDULE_PROMPT.get(this.taskName));
        builder.addCancelOption(false);
        for (ScheduleOption choice : ScheduleOption.values()) {
            MenuResult<ScheduleOption> result = MenuResult.success(choice);
            if (choice == ScheduleOption.defaultValue()) {
                builder.setDefault(choice.getPrompt(), result);
            }
            builder.addNumberedOption(choice.getPrompt(), result, new Message[0]);
        }
        MenuResult m = builder.toMenu().run();
        if (m.isSuccess()) {
            switch ((ScheduleOption)((Object)m.getValue())) {
                case RUN_NOW: {
                    this.uData.setStartNow(true);
                    break;
                }
                case RUN_LATER: {
                    this.uData.setStartNow(false);
                    this.askForStartDate();
                    break;
                }
                case SCHEDULE_TASK: {
                    this.uData.setStartNow(false);
                    this.askForTaskSchedule();
                }
            }
        } else {
            throw new CLIException(Message.EMPTY);
        }
    }

    private void askForStartDate() throws CLIException {
        this.checkHeaderDisplay();
        Date startDate = null;
        while (startDate == null) {
            String sDate = this.app.readInput(AdminToolMessages.INFO_TASK_START_DATE_PROMPT.get(), null);
            try {
                startDate = StaticUtils.parseDateTimeString(sDate);
                Date currentDate = new Date(System.currentTimeMillis());
                if (!currentDate.after(startDate)) continue;
                this.app.printProgress(ToolMessages.ERR_START_DATETIME_ALREADY_PASSED.get(sDate));
                this.app.printlnProgress();
                this.app.printlnProgress();
                startDate = null;
            }
            catch (ParseException pe) {
                this.app.println(ToolMessages.ERR_START_DATETIME_FORMAT.get());
                this.app.println();
            }
        }
        this.uData.setStartDate(startDate);
    }

    private void askForTaskSchedule() throws CLIException {
        this.checkHeaderDisplay();
        String schedule = null;
        while (schedule == null) {
            schedule = this.app.readInput(AdminToolMessages.INFO_TASK_RECURRING_SCHEDULE_PROMPT.get(), null);
            try {
                RecurringTask.parseTaskTab(schedule);
                this.app.printlnProgress();
            }
            catch (DirectoryException de) {
                schedule = null;
                this.app.println(ToolMessages.ERR_RECURRING_SCHEDULE_FORMAT_ERROR.get(de.getMessageObject()));
                this.app.println();
            }
        }
        this.uData.setRecurringDateTime(schedule);
    }

    private void checkHeaderDisplay() {
        if (!this.headerDisplayed) {
            this.app.printlnProgress();
            this.app.printProgress(AdminToolMessages.INFO_TASK_SCHEDULE_PROMPT_HEADER.get());
            this.app.printlnProgress();
            this.headerDisplayed = true;
        }
        this.app.printlnProgress();
    }

    private static enum ScheduleOption {
        RUN_NOW(AdminToolMessages.INFO_RUN_TASK_NOW.get()),
        RUN_LATER(AdminToolMessages.INFO_RUN_TASK_LATER.get()),
        SCHEDULE_TASK(AdminToolMessages.INFO_SCHEDULE_TASK.get());

        private Message prompt;

        private ScheduleOption(Message prompt) {
            this.prompt = prompt;
        }

        Message getPrompt() {
            return this.prompt;
        }

        public static ScheduleOption defaultValue() {
            return RUN_NOW;
        }
    }
}

