/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.tasks;

import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.cli.TaskScheduleArgs;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.tasks.TaskClient;
import org.opends.server.tools.tasks.TaskEntry;
import org.opends.server.tools.tasks.TaskScheduleInformation;
import org.opends.server.types.LDAPException;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentGroup;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.LDAPConnectionArgumentParser;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.CLIException;

public abstract class TaskTool
implements TaskScheduleInformation {
    public static final String NOW = "0";
    private static final int RUN_OFFLINE = 51;
    private static final int RUN_ONLINE = 52;
    private static final int SYNCHRONOUS_TASK_POLL_INTERVAL = 1000;
    private LDAPConnectionArgumentParser argParser;
    private TaskScheduleArgs taskScheduleArgs;
    private BooleanArgument testIfOfflineArg;
    private static final boolean alwaysSSL = true;

    protected abstract int processLocal(boolean var1, PrintStream var2, PrintStream var3);

    protected LDAPConnectionArgumentParser createArgParser(String className, Message toolDescription) {
        ArgumentGroup ldapGroup = new ArgumentGroup(ToolMessages.INFO_DESCRIPTION_TASK_LDAP_ARGS.get(), 1001);
        this.argParser = new LDAPConnectionArgumentParser(className, toolDescription, false, ldapGroup, true);
        ArgumentGroup taskGroup = new ArgumentGroup(ToolMessages.INFO_DESCRIPTION_TASK_TASK_ARGS.get(), 1000);
        try {
            StringArgument propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
            this.argParser.addArgument(propertiesFileArgument);
            this.argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
            this.argParser.addArgument(noPropertiesFileArgument);
            this.argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            this.taskScheduleArgs = new TaskScheduleArgs();
            for (Argument arg : this.taskScheduleArgs.getArguments()) {
                this.argParser.addArgument(arg, taskGroup);
            }
            this.testIfOfflineArg = new BooleanArgument("testIfOffline", null, "testIfOffline", ToolMessages.INFO_DESCRIPTION_TEST_IF_OFFLINE.get());
            this.testIfOfflineArg.setHidden(true);
            this.argParser.addArgument(this.testIfOfflineArg);
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
        return this.argParser;
    }

    protected void validateTaskArgs() throws ArgumentException, CLIException {
        if (this.processAsTask()) {
            this.taskScheduleArgs.validateArgs();
        } else {
            this.taskScheduleArgs.validateArgsIfOffline();
        }
    }

    @Override
    public Date getStartDateTime() {
        return this.taskScheduleArgs.getStartDateTime();
    }

    @Override
    public String getRecurringDateTime() {
        return this.taskScheduleArgs.getRecurringDateTime();
    }

    @Override
    public List<String> getDependencyIds() {
        return this.taskScheduleArgs.getDependencyIds();
    }

    @Override
    public FailedDependencyAction getFailedDependencyAction() {
        return this.taskScheduleArgs.getFailedDependencyAction();
    }

    @Override
    public List<String> getNotifyUponCompletionEmailAddresses() {
        return this.taskScheduleArgs.getNotifyUponCompletionEmailAddresses();
    }

    @Override
    public List<String> getNotifyUponErrorEmailAddresses() {
        return this.taskScheduleArgs.getNotifyUponErrorEmailAddresses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int process(LDAPConnectionArgumentParser argParser, boolean initializeServer, PrintStream out, PrintStream err) {
        int ret;
        if (this.testIfOffline()) {
            if (!this.processAsTask()) {
                return 51;
            }
            return 52;
        }
        if (this.processAsTask()) {
            Message message;
            if (initializeServer) {
                try {
                    DirectoryServer.bootstrapClient();
                    DirectoryServer.initializeJMX();
                }
                catch (Exception e) {
                    Message message2 = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                    err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            LDAPConnection conn = null;
            try {
                conn = argParser.connect(out, err);
                TaskClient tc = new TaskClient(conn);
                TaskEntry taskEntry = tc.schedule(this);
                Message startTime = taskEntry.getScheduledStartTime();
                if (taskEntry.getTaskState() == TaskState.RECURRING) {
                    out.println(StaticUtils.wrapText(ToolMessages.INFO_TASK_TOOL_RECURRING_TASK_SCHEDULED.get(taskEntry.getType(), taskEntry.getId()), ServerConstants.MAX_LINE_WIDTH));
                } else if (startTime == null || startTime.length() == 0) {
                    out.println(StaticUtils.wrapText(ToolMessages.INFO_TASK_TOOL_TASK_SCHEDULED_NOW.get(taskEntry.getType(), taskEntry.getId()), ServerConstants.MAX_LINE_WIDTH));
                } else {
                    out.println(StaticUtils.wrapText(ToolMessages.INFO_TASK_TOOL_TASK_SCHEDULED_FUTURE.get(taskEntry.getType(), taskEntry.getId(), taskEntry.getScheduledStartTime()), ServerConstants.MAX_LINE_WIDTH));
                }
                if (!this.taskScheduleArgs.startArg.isPresent()) {
                    String taskId = taskEntry.getId();
                    HashSet<Message> printedLogMessages = new HashSet<Message>();
                    do {
                        taskEntry = tc.getTaskEntry(taskId);
                        List<Message> logs = taskEntry.getLogMessages();
                        for (Message log : logs) {
                            if (printedLogMessages.contains(log)) continue;
                            printedLogMessages.add(log);
                            out.println(log);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!taskEntry.isDone());
                    if (TaskState.isSuccessful(taskEntry.getTaskState())) {
                        if (taskEntry.getTaskState() != TaskState.RECURRING) {
                            out.println(StaticUtils.wrapText(ToolMessages.INFO_TASK_TOOL_TASK_SUCESSFULL.get(taskEntry.getType(), taskEntry.getId()), ServerConstants.MAX_LINE_WIDTH));
                        }
                        int n = 0;
                        return n;
                    }
                    out.println(StaticUtils.wrapText(ToolMessages.INFO_TASK_TOOL_TASK_NOT_SUCESSFULL.get(taskEntry.getType(), taskEntry.getId()), ServerConstants.MAX_LINE_WIDTH));
                    int n = 1;
                    return n;
                }
                ret = 0;
            }
            catch (LDAPConnectionException e) {
                message = this.isWrongPortException(e, new Integer(argParser.getArguments().getPort())) ? TaskMessages.ERR_TASK_LDAP_FAILED_TO_CONNECT_WRONG_PORT.get(argParser.getArguments().getHostName(), argParser.getArguments().getPort()) : ToolMessages.ERR_TASK_TOOL_START_TIME_NO_LDAP.get(e.getMessage());
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 1;
            }
            catch (IOException ioe) {
                message = ToolMessages.ERR_TASK_TOOL_IO_ERROR.get(String.valueOf(ioe));
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 1;
            }
            catch (ASN1Exception ae) {
                message = ToolMessages.ERR_TASK_TOOL_DECODE_ERROR.get(ae.getMessage());
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 1;
            }
            catch (LDAPException le) {
                message = ToolMessages.ERR_TASK_TOOL_DECODE_ERROR.get(le.getMessage());
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 1;
            }
            catch (OpenDsException e) {
                message = e.getMessageObject();
                if (err != null) {
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                }
                ret = 1;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close(null);
                    }
                    catch (Throwable e) {}
                }
            }
        } else {
            ret = this.processLocal(initializeServer, out, err);
        }
        return ret;
    }

    private boolean processAsTask() {
        return this.argParser.connectionArgumentsPresent();
    }

    private boolean isWrongPortException(Throwable t, int port) {
        boolean isDefaultClearPort;
        boolean isWrongPortException = false;
        boolean bl = isDefaultClearPort = (port - 389) % 1000 == 0;
        while (t != null && isDefaultClearPort && !(isWrongPortException = t instanceof SocketTimeoutException)) {
            t = t.getCause();
        }
        return isWrongPortException;
    }

    public boolean testIfOffline() {
        boolean returnValue = false;
        if (this.testIfOfflineArg != null) {
            returnValue = this.testIfOfflineArg.isPresent();
        }
        return returnValue;
    }
}

