/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.upgrade;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.upgrade.UpgradeCli;
import org.opends.server.tools.upgrade.UpgradeUtils;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilePermission;
import org.opends.server.util.StaticUtils;

class FileManager {
    private static final Logger LOG = Logger.getLogger(UpgradeCli.class.getName());

    private FileManager() {
    }

    public static void deleteRecursively(File file) throws IOException {
        FileManager.deleteRecursively(file, null, DeletionPolicy.DELETE_IMMEDIATELY);
    }

    private static void deleteRecursively(File file, FileFilter filter, DeletionPolicy deletePolicy) throws IOException {
        FileManager.operateRecursively(new DeleteOperation(file, deletePolicy), filter);
    }

    public static File copy(File objectFile, File destDir, boolean overwrite) throws IOException {
        CopyOperation co = new CopyOperation(objectFile, destDir, overwrite);
        co.apply();
        return co.getDestination();
    }

    private static void operateRecursively(FileOperation op, FileFilter filter) throws IOException {
        File file = op.getObjectFile();
        if (file.exists()) {
            if (file.isFile()) {
                if (filter != null) {
                    if (filter.accept(file)) {
                        op.apply();
                    }
                } else {
                    op.apply();
                }
            } else {
                File[] children = file.listFiles();
                if (children != null) {
                    for (File aChildren : children) {
                        FileOperation newOp = op.copyForChild(aChildren);
                        FileManager.operateRecursively(newOp, filter);
                    }
                }
                if (filter != null) {
                    if (filter.accept(file)) {
                        op.apply();
                    }
                } else {
                    op.apply();
                }
            }
        } else {
            LOG.log(Level.INFO, "File '" + file.toString() + "' does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(File fileToRename, File target) throws IOException {
        if (fileToRename != null && target != null) {
            File file = target;
            synchronized (file) {
                if (target.exists() && !target.delete()) {
                    throw new IOException(ToolMessages.INFO_ERROR_DELETING_FILE.get(UpgradeUtils.getPath(target)).toString());
                }
            }
            if (!fileToRename.renameTo(target)) {
                throw new IOException(ToolMessages.INFO_ERROR_RENAMING_FILE.get(UpgradeUtils.getPath(fileToRename), UpgradeUtils.getPath(target)).toString());
            }
        }
    }

    private static FilePermission getFileSystemPermissions(File file) throws DirectoryException {
        String name = file.getName();
        if (file.getParent().endsWith(File.separator + "bat") || file.getParent().endsWith(File.separator + "bin")) {
            if (name.endsWith(".bat")) {
                return FilePermission.decodeUNIXMode("644");
            }
            return FilePermission.decodeUNIXMode("755");
        }
        if (name.endsWith(".sh")) {
            return FilePermission.decodeUNIXMode("755");
        }
        if (name.endsWith("setup") || name.endsWith("uninstall") || name.endsWith("upgrade")) {
            return FilePermission.decodeUNIXMode("755");
        }
        if (name.endsWith("JavaApplicationStub")) {
            return FilePermission.decodeUNIXMode("755");
        }
        return FilePermission.decodeUNIXMode("644");
    }

    private static boolean insureParentsExist(File f) {
        File parent = f.getParentFile();
        boolean b = parent.exists();
        if (!b) {
            b = parent.mkdirs();
        }
        return b;
    }

    private static class DeleteOperation
    extends FileOperation {
        private DeletionPolicy deletionPolicy;

        public DeleteOperation(File objectFile, DeletionPolicy deletionPolicy) {
            super(objectFile);
            this.deletionPolicy = deletionPolicy;
        }

        @Override
        public FileOperation copyForChild(File child) {
            return new DeleteOperation(child, this.deletionPolicy);
        }

        @Override
        public void apply() throws IOException {
            File file = this.getObjectFile();
            boolean isFile = file.isFile();
            LOG.log(Level.INFO, "deleting " + (isFile ? " file " : " directory ") + file.getAbsolutePath());
            boolean delete = false;
            int nTries = 5;
            for (int i = 0; i < nTries && !delete; ++i) {
                if (DeletionPolicy.DELETE_ON_EXIT.equals((Object)this.deletionPolicy)) {
                    file.deleteOnExit();
                    delete = true;
                } else {
                    delete = file.delete();
                    if (!delete && DeletionPolicy.DELETE_ON_EXIT_IF_UNSUCCESSFUL.equals((Object)this.deletionPolicy)) {
                        file.deleteOnExit();
                        delete = true;
                    }
                }
                if (delete) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!delete) {
                Message errMsg = isFile ? ToolMessages.INFO_ERROR_DELETING_FILE.get(file.getAbsolutePath()) : ToolMessages.INFO_ERROR_DELETING_DIRECTORY.get(file.getAbsolutePath());
                throw new IOException(errMsg.toString());
            }
        }
    }

    private static class CopyOperation
    extends FileOperation {
        private File destination;
        private boolean overwrite;

        public CopyOperation(File objectFile, File destDir, boolean overwrite) {
            super(objectFile);
            this.destination = new File(destDir, objectFile.getName());
            this.overwrite = overwrite;
        }

        @Override
        public FileOperation copyForChild(File child) {
            return new CopyOperation(child, this.destination, this.overwrite);
        }

        public File getDestination() {
            return this.destination;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void apply() throws IOException {
            File objectFile = this.getObjectFile();
            if (objectFile.isDirectory()) {
                if (this.destination.exists()) return;
                this.destination.mkdirs();
                return;
            }
            if (this.destination.exists() && this.overwrite) {
                FileManager.deleteRecursively(this.destination);
            }
            if (this.destination.exists()) {
                Message message = Message.raw("Ignoring file '%s' since '%s' already exists", objectFile.getAbsolutePath(), this.destination.getAbsolutePath());
                LOG.log(Level.INFO, message.toString());
                return;
            }
            if (!FileManager.insureParentsExist(this.destination)) {
                Message errMsg = ToolMessages.INFO_ERROR_COPYING_FILE.get(objectFile.getAbsolutePath(), this.destination.getAbsolutePath());
                LOG.log(Level.SEVERE, errMsg.toString());
                throw new IOException(errMsg.toString());
            }
            Message message = Message.raw("Copying file '%s' to '%s'", objectFile.getAbsolutePath(), this.destination.getAbsolutePath());
            LOG.log(Level.INFO, message.toString());
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                int i;
                fis = new FileInputStream(objectFile);
                fos = new FileOutputStream(this.destination);
                byte[] buf = new byte[1024];
                while ((i = fis.read(buf)) != -1) {
                    fos.write(buf, 0, i);
                }
                if (this.destination.exists() && UpgradeUtils.isUnix()) {
                    FilePermission permissions = FileManager.getFileSystemPermissions(objectFile);
                    FilePermission.setPermissions(this.destination, permissions);
                }
            }
            catch (IOException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        Message errMsg = ToolMessages.INFO_ERROR_COPYING_FILE.get(objectFile.getAbsolutePath(), this.destination.getAbsolutePath());
                        throw new IOException(errMsg.toString(), e2);
                    }
                }
                catch (Throwable throwable) {
                    StaticUtils.close(fis, fos);
                    throw throwable;
                }
            }
            StaticUtils.close(fis, fos);
        }
    }

    private static abstract class FileOperation {
        private File objectFile = null;

        public FileOperation(File objectFile) {
            this.objectFile = objectFile;
        }

        protected File getObjectFile() {
            return this.objectFile;
        }

        public abstract FileOperation copyForChild(File var1);

        public abstract void apply() throws IOException;
    }

    public static enum DeletionPolicy {
        DELETE_IMMEDIATELY,
        DELETE_ON_EXIT,
        DELETE_ON_EXIT_IF_UNSUCCESSFUL;

    }
}

