/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.upgrade;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.TextOutputCallback;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.upgrade.FormattedNotificationCallback;
import org.opends.server.tools.upgrade.ProgressNotificationCallback;
import org.opends.server.types.InitializationException;
import org.opends.server.util.BuildVersion;

public final class UpgradeContext {
    private final BuildVersion fromVersion;
    private final BuildVersion toVersion;
    private final CallbackHandler handler;
    private boolean isIgnoreErrorsMode;
    private boolean isAcceptLicenseMode;
    private boolean isInteractiveMode;
    private boolean isForceUpgradeMode;

    public UpgradeContext(CallbackHandler handler) throws InitializationException {
        this(BuildVersion.instanceVersion(), BuildVersion.binaryVersion(), handler);
    }

    public UpgradeContext(BuildVersion fromVersion, BuildVersion toVersion, CallbackHandler handler) {
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.handler = handler;
    }

    BuildVersion getFromVersion() {
        return this.fromVersion;
    }

    BuildVersion getToVersion() {
        return this.toVersion;
    }

    boolean isIgnoreErrorsMode() {
        return this.isIgnoreErrorsMode;
    }

    public UpgradeContext setIgnoreErrorsMode(boolean isIgnoreErrorsMode) {
        this.isIgnoreErrorsMode = isIgnoreErrorsMode;
        return this;
    }

    boolean isAcceptLicenseMode() {
        return this.isAcceptLicenseMode;
    }

    public UpgradeContext setAcceptLicenseMode(boolean isAcceptLicenseMode) {
        this.isAcceptLicenseMode = isAcceptLicenseMode;
        return this;
    }

    CallbackHandler getHandler() {
        return this.handler;
    }

    boolean isInteractiveMode() {
        return this.isInteractiveMode;
    }

    public UpgradeContext setInteractiveMode(boolean isInteractiveMode) {
        this.isInteractiveMode = isInteractiveMode;
        return this;
    }

    boolean isForceUpgradeMode() {
        return this.isForceUpgradeMode;
    }

    public UpgradeContext setForceUpgradeMode(boolean isForceUpgradeMode) {
        this.isForceUpgradeMode = isForceUpgradeMode;
        return this;
    }

    void notify(Message message) throws ClientException {
        try {
            this.handler.handle(new Callback[]{new TextOutputCallback(0, message.toString())});
        }
        catch (Exception e) {
            throw new ClientException(1, ToolMessages.ERR_UPGRADE_DISPLAY_NOTIFICATION_ERROR.get(e.getMessage()));
        }
    }

    void notify(Message message, int msgType) throws ClientException {
        try {
            this.handler.handle(new Callback[]{new FormattedNotificationCallback(message, msgType)});
        }
        catch (Exception e) {
            throw new ClientException(1, ToolMessages.ERR_UPGRADE_DISPLAY_NOTIFICATION_ERROR.get(e.getMessage()));
        }
    }

    void notifyProgress(ProgressNotificationCallback callback) throws ClientException {
        try {
            this.handler.handle(new Callback[]{callback});
        }
        catch (Exception e) {
            throw new ClientException(1, ToolMessages.ERR_UPGRADE_DISPLAY_NOTIFICATION_ERROR.get(e.getMessage()));
        }
    }

    int confirmYN(Message message, int defaultOption) throws ClientException {
        ConfirmationCallback confirmYNCallback = new ConfirmationCallback(message.toString(), 1, 0, defaultOption);
        try {
            this.handler.handle(new Callback[]{confirmYNCallback});
        }
        catch (Exception e) {
            throw new ClientException(1, ToolMessages.ERR_UPGRADE_DISPLAY_CONFIRM_ERROR.get(e.getMessage()));
        }
        return confirmYNCallback.getSelectedIndex();
    }
}

