/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.util.Validator;

public final class AdditionalLogItem {
    private final Class<?> source;
    private final String key;
    private final Object value;
    private final boolean isQuoted;

    public static AdditionalLogItem keyOnly(Class<?> source, String key) {
        Validator.ensureNotNull(source, key);
        return new AdditionalLogItem(source, key, null, false);
    }

    public static AdditionalLogItem quotedKeyValue(Class<?> source, String key, Object value) {
        Validator.ensureNotNull(source, key, value);
        return new AdditionalLogItem(source, key, value, true);
    }

    public static AdditionalLogItem unquotedKeyValue(Class<?> source, String key, Object value) {
        Validator.ensureNotNull(source, key, value);
        return new AdditionalLogItem(source, key, value, false);
    }

    private AdditionalLogItem(Class<?> source, String key, Object value, boolean isQuoted) {
        this.source = source;
        this.key = key;
        this.value = value;
        this.isQuoted = isQuoted;
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getSource() {
        return this.source;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isQuoted() {
        return this.isQuoted;
    }

    public String toString() {
        if (this.value == null) {
            return this.key;
        }
        StringBuilder builder = new StringBuilder(this.key.length() + 16);
        this.toString(builder);
        return builder.toString();
    }

    public StringBuilder toString(StringBuilder builder) {
        builder.append(this.key);
        if (this.value != null) {
            builder.append('=');
            if (this.isQuoted) {
                builder.append('\'');
            }
            builder.append(this.value.toString());
            if (this.isQuoted) {
                builder.append('\'');
            }
        }
        return builder;
    }
}

