/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public final class ByteString
implements ByteSequence {
    private static final ByteString EMPTY = ByteString.wrap(new byte[0]);
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final byte[] buffer;
    private final int length;
    private final int offset;

    public static ByteString empty() {
        return EMPTY;
    }

    public static ByteString valueOf(int i) {
        byte[] bytes = new byte[4];
        for (int j = 3; j >= 0; --j) {
            bytes[j] = (byte)(i & 0xFF);
            i >>>= 8;
        }
        return ByteString.wrap(bytes);
    }

    public static ByteString valueOf(long l) {
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        return ByteString.wrap(bytes);
    }

    public static ByteString valueOf(String s) {
        return ByteString.wrap(StaticUtils.getBytes(s));
    }

    public static ByteString wrap(byte[] b) {
        return new ByteString(b, 0, b.length);
    }

    public static ByteString wrap(byte[] b, int offset, int length) throws IndexOutOfBoundsException {
        ByteString.checkArrayBounds(b, offset, length);
        return new ByteString(b, offset, length);
    }

    static void checkArrayBounds(byte[] b, int offset, int length) throws IndexOutOfBoundsException {
        if (offset < 0 || offset > b.length || length < 0 || offset + length > b.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    static int compareTo(byte[] b1, int offset1, int length1, byte[] b2, int offset2, int length2) {
        int count = Math.min(length1, length2);
        int i = offset1;
        int j = offset2;
        while (count-- != 0) {
            int secondByte;
            int firstByte;
            if ((firstByte = 0xFF & b1[i++]) == (secondByte = 0xFF & b2[j++])) continue;
            return firstByte - secondByte;
        }
        return length1 - length2;
    }

    static boolean equals(byte[] b1, int offset1, int length1, byte[] b2, int offset2, int length2) {
        if (length1 != length2) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        int count = length1;
        while (count-- != 0) {
            if (b1[i++] == b2[j++]) continue;
            return false;
        }
        return true;
    }

    static int hashCode(byte[] b, int offset, int length) {
        int hashCode = 1;
        int i = offset;
        int count = length;
        while (count-- != 0) {
            hashCode = 31 * hashCode + b[i++];
        }
        return hashCode;
    }

    static String toString(byte[] b, int offset, int length) {
        String stringValue;
        try {
            stringValue = new String(b, offset, length, "UTF-8");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            stringValue = new String(b, offset, length);
        }
        return stringValue;
    }

    private ByteString(byte[] b, int offset, int length) {
        this.buffer = b;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public ByteSequenceReader asReader() {
        return new ByteSequenceReader(this);
    }

    @Override
    public byte byteAt(int index) throws IndexOutOfBoundsException {
        if (index >= this.length || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.offset + index];
    }

    @Override
    public int compareTo(byte[] b, int offset, int length) throws IndexOutOfBoundsException {
        ByteString.checkArrayBounds(b, offset, length);
        return ByteString.compareTo(this.buffer, this.offset, this.length, b, offset, length);
    }

    @Override
    public int compareTo(ByteSequence o) {
        if (this == o) {
            return 0;
        }
        return -o.compareTo(this.buffer, this.offset, this.length);
    }

    @Override
    public byte[] copyTo(byte[] b) {
        this.copyTo(b, 0);
        return b;
    }

    @Override
    public byte[] copyTo(byte[] b, int offset) throws IndexOutOfBoundsException {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, this.offset, b, offset, Math.min(this.length, b.length - offset));
        return b;
    }

    @Override
    public ByteStringBuilder copyTo(ByteStringBuilder builder) {
        builder.append(this.buffer, this.offset, this.length);
        return builder;
    }

    @Override
    public OutputStream copyTo(OutputStream stream) throws IOException {
        stream.write(this.buffer, this.offset, this.length);
        return stream;
    }

    @Override
    public int copyTo(WritableByteChannel channel) throws IOException {
        return channel.write(ByteBuffer.wrap(this.buffer, this.offset, this.length));
    }

    @Override
    public boolean equals(byte[] b, int offset, int length) throws IndexOutOfBoundsException {
        ByteString.checkArrayBounds(b, offset, length);
        return ByteString.equals(this.buffer, this.offset, this.length, b, offset, length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)o;
            return other.equals(this.buffer, this.offset, this.length);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ByteString.hashCode(this.buffer, this.offset, this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public ByteString subSequence(int start, int end) throws IndexOutOfBoundsException {
        if (start < 0 || start > end || end > this.length) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteString(this.buffer, this.offset + start, end - start);
    }

    @Override
    public byte[] toByteArray() {
        return this.copyTo(new byte[this.length]);
    }

    @Override
    public ByteString toByteString() {
        return this;
    }

    public String toHex() {
        StringBuilder builder = new StringBuilder((this.length - 1) * 3 + 2);
        builder.append(StaticUtils.byteToHex(this.buffer[this.offset]));
        for (int i = 1; i < this.length; ++i) {
            builder.append(" ");
            builder.append(StaticUtils.byteToHex(this.buffer[this.offset + i]));
        }
        return builder.toString();
    }

    public void toHexPlusAscii(StringBuilder builder, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        int pos = 0;
        while (this.length - pos >= 16) {
            StringBuilder asciiBuf = new StringBuilder(17);
            byte currentByte = this.buffer[this.offset + pos];
            builder.append((CharSequence)indentBuf);
            builder.append(StaticUtils.byteToHex(currentByte));
            asciiBuf.append(StaticUtils.byteToASCII(currentByte));
            ++pos;
            int i = 1;
            while (i < 16) {
                currentByte = this.buffer[this.offset + pos];
                builder.append(' ');
                builder.append(StaticUtils.byteToHex(currentByte));
                asciiBuf.append(StaticUtils.byteToASCII(currentByte));
                if (i == 7) {
                    builder.append("  ");
                    asciiBuf.append(' ');
                }
                ++i;
                ++pos;
            }
            builder.append("  ");
            builder.append((CharSequence)asciiBuf);
            builder.append(ServerConstants.EOL);
        }
        int remaining = this.length - pos;
        if (remaining > 0) {
            StringBuilder asciiBuf = new StringBuilder(remaining + 1);
            byte currentByte = this.buffer[this.offset + pos];
            builder.append((CharSequence)indentBuf);
            builder.append(StaticUtils.byteToHex(currentByte));
            asciiBuf.append(StaticUtils.byteToASCII(currentByte));
            ++pos;
            int i = 1;
            while (i < 16) {
                builder.append(' ');
                if (i < remaining) {
                    currentByte = this.buffer[this.offset + pos];
                    builder.append(StaticUtils.byteToHex(currentByte));
                    asciiBuf.append(StaticUtils.byteToASCII(currentByte));
                } else {
                    builder.append("  ");
                }
                if (i == 7) {
                    builder.append("  ");
                    if (i < remaining) {
                        asciiBuf.append(' ');
                    }
                }
                ++i;
                ++pos;
            }
            builder.append("  ");
            builder.append((CharSequence)asciiBuf);
            builder.append(ServerConstants.EOL);
        }
    }

    public int toInt() throws IndexOutOfBoundsException {
        if (this.length < 4) {
            throw new IndexOutOfBoundsException();
        }
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            v <<= 8;
            v |= this.buffer[this.offset + i] & 0xFF;
        }
        return v;
    }

    public long toLong() throws IndexOutOfBoundsException {
        if (this.length < 8) {
            throw new IndexOutOfBoundsException();
        }
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            v <<= 8;
            v |= (long)(this.buffer[this.offset + i] & 0xFF);
        }
        return v;
    }

    @Override
    public String toString() {
        return ByteString.toString(this.buffer, this.offset, this.length);
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.buffer, this.offset, this.length).asReadOnlyBuffer();
    }
}

