/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum OperatingSystem {
    AIX("AIX"),
    FREEBSD("FreeBSD"),
    HPUX("HP-UX"),
    LINUX("Linux"),
    MACOS("Mac OS X"),
    SOLARIS("Solaris"),
    WINDOWS("Windows"),
    ZOS("z/OS"),
    UNKNOWN("Unknown");

    private String osName;

    private OperatingSystem(String osName) {
        this.osName = osName;
    }

    public String toString() {
        return this.osName;
    }

    public static OperatingSystem forName(String osName) {
        if (osName == null) {
            return UNKNOWN;
        }
        String lowerName = osName.toLowerCase();
        if (lowerName.indexOf("solaris") >= 0 || lowerName.indexOf("sunos") >= 0) {
            return SOLARIS;
        }
        if (lowerName.indexOf("linux") >= 0) {
            return LINUX;
        }
        if (lowerName.indexOf("hp-ux") >= 0 || lowerName.indexOf("hp ux") >= 0 || lowerName.indexOf("hpux") >= 0) {
            return HPUX;
        }
        if (lowerName.indexOf("aix") >= 0) {
            return AIX;
        }
        if (lowerName.indexOf("windows") >= 0) {
            return WINDOWS;
        }
        if (lowerName.indexOf("freebsd") >= 0 || lowerName.indexOf("free bsd") >= 0) {
            return FREEBSD;
        }
        if (lowerName.indexOf("macos") >= 0 || lowerName.indexOf("mac os") >= 0) {
            return MACOS;
        }
        if (lowerName.indexOf("z/os") >= 0) {
            return ZOS;
        }
        return UNKNOWN;
    }

    public static boolean isUNIXBased(OperatingSystem os) {
        switch (os) {
            case SOLARIS: 
            case LINUX: 
            case HPUX: 
            case AIX: 
            case FREEBSD: 
            case MACOS: {
                return true;
            }
        }
        return false;
    }
}

